<?php
session_start();

// Include the database connection file
include('db.php');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Get project details from POST request
    $game_name = $_POST['game_name'];
    $game_number = $_POST['game_number'];
    $open_time = $_POST['open_time'];
    $close_time = $_POST['close_time'];

    // Insert project into the database (you need to create a projects table in your DB)
    $sql = "INSERT INTO projects (game_name, game_number, open_time, close_time) 
            VALUES ('$game_name', '$game_number', '$open_time', '$close_time')";

    if ($conn->query($sql) === TRUE) {
        $success_message = "New project created successfully!";
    } else {
        $error_message = "Error: " . $sql . "<br>" . $conn->error;
    }
}

// Fetch existing games for display
$games = [
    "Single Digit",
    "Single Panna",
    "Double Panna",
    "Triple Panna"
];

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create New Game Project</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f0f2f5;
            margin: 0;
            padding: 0;
        }
        .container {
            padding: 20px;
            max-width: 600px;
            margin: auto;
            background-color: white;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        h2 {
            text-align: center;
            color: #333;
        }
        label {
            font-size: 14px;
            color: #555;
        }
        input[type="text"], input[type="time"], input[type="number"] {
            width: 100%;
            padding: 10px;
            margin: 10px 0;
            border-radius: 5px;
            border: 1px solid #ccc;
        }
        button {
            width: 100%;
            padding: 10px;
            background-color: #007bff;
            border: none;
            color: white;
            font-size: 16px;
            border-radius: 5px;
            cursor: pointer;
        }
        button:hover {
            background-color: #0056b3;
        }
        .message {
            text-align: center;
            color: #28a745;
            margin-bottom: 20px;
        }
        .error-message {
            color: #ff0000;
            font-size: 14px;
            text-align: center;
            margin-bottom: 10px;
        }
        .games-list {
            margin-top: 20px;
            list-style-type: none;
            padding-left: 0;
        }
        .games-list li {
            background-color: #f8f9fa;
            padding: 10px;
            margin: 10px 0;
            border-radius: 5px;
            text-align: center;
        }
    </style>
</head>
<body>

    <div class="container">
        <h2>Create New Game Project</h2>

        <!-- Display success message if project is created successfully -->
        <?php if (isset($success_message)): ?>
            <div class="message"><?php echo $success_message; ?></div>
        <?php endif; ?>

        <!-- Display error message if there is any issue -->
        <?php if (isset($error_message)): ?>
            <div class="error-message"><?php echo $error_message; ?></div>
        <?php endif; ?>

        <!-- Project Creation Form -->
        <form method="POST" action="new.php">
            <label for="game_name">Game Name:</label>
            <input type="text" name="game_name" id="game_name" required placeholder="Enter Game Name">

            <label for="game_number">Game Number:</label>
            <input type="number" name="game_number" id="game_number" required placeholder="Enter Game Number">

            <label for="open_time">Open Time:</label>
            <input type="time" name="open_time" id="open_time" required>

            <label for="close_time">Close Time:</label>
            <input type="time" name="close_time" id="close_time" required>

            <button type="submit">Create Project</button>
        </form>

        <!-- List of Games Under the Project -->
        <h3>Games under the project</h3>
        <ul class="games-list">
            <?php foreach ($games as $game): ?>
                <li><?php echo $game; ?></li>
            <?php endforeach; ?>
        </ul>
    </div>

</body>
</html>
