<?php
// add_wallet_api.php — Wallet balance lookup

// JSON & CORS
header('Content-Type: application/json; charset=UTF-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(200); exit; }

// DEV only (turn off in prod)
// ini_set('display_errors', 1); ini_set('display_startup_errors', 1); error_reporting(E_ALL);

require_once __DIR__ . '/db.php';
$conn->set_charset('utf8mb4');

// read body (JSON first; fallback to form/query)
$raw   = file_get_contents('php://input');
$input = json_decode($raw, true) ?: $_REQUEST;

// normalize to last 10–12 digits; your DB has plain 10-digit numbers
$mobile = isset($input['mobile']) ? preg_replace('/\D+/', '', (string)$input['mobile']) : '';
if ($mobile === '') {
  http_response_code(400);
  echo json_encode(['success'=>false,'status'=>false,'message'=>'Mobile number is required.','data'=>[]]);
  exit;
}

try {
  // find user
  $stmt = $conn->prepare("SELECT user_id, username, email FROM users_data WHERE mobile = ? LIMIT 1");
  $stmt->bind_param('s', $mobile);
  $stmt->execute();
  $user = $stmt->get_result()->fetch_assoc();
  $stmt->close();

  if (!$user) {
    http_response_code(404);
    echo json_encode(['success'=>false,'status'=>false,'message'=>'User not found with this mobile number.','data'=>[]]);
    exit;
  }

  $user_id = (int)$user['user_id'];

  // get wallet
  $stmt = $conn->prepare("SELECT balance FROM wallet WHERE user_id = ? LIMIT 1");
  $stmt->bind_param('i', $user_id);
  $stmt->execute();
  $wallet = $stmt->get_result()->fetch_assoc();
  $stmt->close();

  if (!$wallet) {
    // insert zero row (assumes created_at/updated_at have defaults; if not, add NOW(), NOW())
    $stmt = $conn->prepare("INSERT INTO wallet (user_id, balance) VALUES (?, 0.00)");
    $stmt->bind_param('i', $user_id);
    $stmt->execute();
    $stmt->close();
    $balance = 0.00;
  } else {
    $balance = (float)$wallet['balance'];
  }

  echo json_encode([
    'success' => true,
    'status'  => true,
    'message' => 'Wallet balance retrieved successfully.',
    'data'    => [
      'user_id'  => $user_id,
      'username' => $user['username'],
      'email'    => $user['email'] ?? '',
      'mobile'   => $mobile,
      'balance'  => $balance,
    ],
  ]);
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['success'=>false,'status'=>false,'message'=>'Database error','data'=>[]]);
} finally {
  $conn->close();
}
