<?php
require __DIR__ . '/_bootstrap.php';
jheader();

// Inputs
$mobile = post('mobile', '');
$amount = (float)post('amount', 0);

$digits = preg_replace('/\D+/', '', $mobile);
if ($digits === '' || $amount <= 0) {
  jexit(['ok'=>false,'error'=>'Invalid mobile or amount'], 422);
}

// Make unique order_id
$orderId = 'TXN' . time() . random_int(100, 999);

// Insert PENDING in wallet_orders
$stmt = $conn->prepare("INSERT INTO wallet_orders (order_id, mobile, amount, status, created_at, updated_at) VALUES (?,?,?,?,NOW(),NOW())");
$status = 'PENDING';
$stmt->bind_param('ssds', $orderId, $digits, $amount, $status);
if (!$stmt->execute()) {
  $err = $conn->error;
  $stmt->close();
  jexit(['ok'=>false,'error'=>"DB insert failed: $err"], 500);
}
$stmt->close();

// Call IMB: create order
$redirectUrl = 'https://sai7755.com/Sai/imb/return.php?order_id=' . urlencode($orderId);
[$http, $res, $err] = http_post_form(IMB_CREATE, [
  'user_token'      => IMB_TOKEN,
  'order_id'        => $orderId,
  'amount'          => number_format($amount, 2, '.', ''),
  'customer_mobile' => $digits,
  'redirect_url'    => $redirectUrl,
], 30);

if ($http !== 200 || !$res) {
  // Mark failed create (optional)
  $conn->query("UPDATE wallet_orders SET status='FAILED', updated_at=NOW() WHERE order_id='".$conn->real_escape_string($orderId)."'");
  jexit(['ok'=>false,'error'=>'IMB create-order failed','http'=>$http,'detail'=>$err], 502);
}

$data = json_decode($res, true);
$ok   = is_array($data) && !empty($data['status']) && !empty($data['result']['payment_url']);

if (!$ok) {
  $msg = is_array($data) ? ($data['message'] ?? 'Unknown IMB error') : 'Invalid IMB response';
  $conn->query("UPDATE wallet_orders SET status='FAILED', gateway_payload='".$conn->real_escape_string($res)."', updated_at=NOW() WHERE order_id='".$conn->real_escape_string($orderId)."'");
  jexit(['ok'=>false,'error'=>$msg], 400);
}

// Success — return payment_url
$paymentUrl = $data['result']['payment_url'];
// Optionally store raw create response
$stmt = $conn->prepare("UPDATE wallet_orders SET gateway_payload = ?, updated_at = NOW() WHERE order_id = ?");
$gp   = $res;
$stmt->bind_param('ss', $gp, $orderId);
$stmt->execute();
$stmt->close();

jexit(['ok'=>true, 'order_id'=>$orderId, 'payment_url'=>$paymentUrl]);
