<?php
require __DIR__ . '/_bootstrap.php';
jheader();

$orderId = getv('order_id','');
if ($orderId==='') jexit(['ok'=>false,'error'=>'order_id required'],422);

// read row
$stmt = $conn->prepare("SELECT id,order_id,mobile,amount,status,utr,created_at,updated_at FROM wallet_orders WHERE order_id=? LIMIT 1");
$stmt->bind_param('s',$orderId);
$stmt->execute(); $stmt->bind_result($rowId,$oid,$mobile,$amount,$status,$utr,$created,$updated);
if (!$stmt->fetch()) { $stmt->close(); jexit(['ok'=>false,'error'=>'Not found'],404); }
$stmt->close();

if ($status==='PENDING') {
  $chk = imb_check_status($orderId);
  if ($chk['ok']) {
    [$norm,$utrNew] = imb_normalize_status($chk['data']);

    if ($norm === 'success') {
      $conn->begin_transaction();
      try {
        $gp = $chk['raw'] ?? json_encode($chk['data'], JSON_UNESCAPED_UNICODE);
        $stmt = $conn->prepare("UPDATE wallet_orders SET status='SUCCESS', utr=?, gateway_payload=?, updated_at=NOW() WHERE id=?");
        $stmt->bind_param('ssi',$utrNew,$gp,$rowId);
        $stmt->execute(); $stmt->close();

        $userId = getUserIdByMobile($conn, $mobile);
        if ($userId !== null) { creditWallet($conn, $userId, (float)$amount); }

        $conn->commit();
        $status='SUCCESS'; $utr=$utrNew; $updated=date('Y-m-d H:i:s');
      } catch(Throwable $e){ $conn->rollback(); }
    } elseif ($norm === 'failed') {
      $gp = $chk['raw'] ?? json_encode($chk['data'], JSON_UNESCAPED_UNICODE);
      $stmt = $conn->prepare("UPDATE wallet_orders SET status='FAILED', gateway_payload=?, updated_at=NOW() WHERE id=?");
      $stmt->bind_param('si',$gp,$rowId);
      $stmt->execute(); $stmt->close();
      $status='FAILED'; $updated=date('Y-m-d H:i:s');
    }
    // pending: leave as is
  }
}

jexit([
  'ok'=>true,
  'order_id'=>$oid,
  'mobile'=>$mobile,
  'amount'=>(float)$amount,
  'status'=>$status,
  'utr'=>$utr,
  'created_at'=>$created,
  'updated_at'=>$updated
]);
