<?php
require __DIR__ . '/_bootstrap.php';

$raw = file_get_contents('php://input');

if (!empty($raw) && strpos($raw, '%') !== false) {
    
    parse_str(urldecode($raw), $incoming);
} else {
 
    $incoming = json_decode($raw, true) ?: $_POST;
}


if (!empty($incoming['result']) && is_string($incoming['result'])) {
    $incoming['result'] = json_decode($incoming['result'], true);
}


@file_put_contents(IMB_LOG_FILE, date('c') . " RAW:$raw\nFORM:" . print_r($incoming, true) . "\n", FILE_APPEND);

$orderId = '';
foreach (['order_id','orderId','orderid','ORDER_ID'] as $k) {
    if (!empty($incoming[$k])) {
        $orderId = (string)$incoming[$k];
        break;
    }
}
if ($orderId === '') {
    http_response_code(400);
    echo 'Missing order_id';
    exit;
}

$stmt = $conn->prepare("SELECT id,mobile,amount,status FROM wallet_orders WHERE order_id=? LIMIT 1");
$stmt->bind_param('s', $orderId);
$stmt->execute();
$stmt->bind_result($rowId, $mobile, $orderAmt, $curStatus);
if (!$stmt->fetch()) {
    $stmt->close();
    echo 'NOT_FOUND';
    exit;
}
$stmt->close();

if (in_array($curStatus, ['SUCCESS','FAILED'], true)) {
    echo 'OK';
    exit;
}

list($statusNormalized, $utr) = imb_normalize_status($incoming);


if ($statusNormalized === 'success') {
    $conn->begin_transaction();
    try {
        $gp = json_encode($incoming, JSON_UNESCAPED_UNICODE);
        $stmt = $conn->prepare("UPDATE wallet_orders SET status='SUCCESS', utr=?, gateway_payload=?, updated_at=NOW() WHERE id=?");
        $stmt->bind_param('ssi', $utr, $gp, $rowId);
        $stmt->execute();
        $stmt->close();

        $userId = getUserIdByMobile($conn, $mobile);
        if ($userId !== null) {
            creditWallet($conn, $userId, (float)$orderAmt);
        }

        $conn->commit();
        echo 'OK';
    } catch (Throwable $e) {
        $conn->rollback();
        @file_put_contents(IMB_LOG_FILE, "ERROR: " . $e->getMessage() . "\n", FILE_APPEND);
        echo 'ERROR: ' . $e->getMessage();
    }
    exit;
}

if ($statusNormalized === 'failed') {
    $gp = json_encode($incoming, JSON_UNESCAPED_UNICODE);
    $stmt = $conn->prepare("UPDATE wallet_orders SET status='FAILED', gateway_payload=?, updated_at=NOW() WHERE id=?");
    $stmt->bind_param('si', $gp, $rowId);
    $stmt->execute();
    $stmt->close();
    echo 'FAIL';
    exit;
}

echo 'PENDING';
exit;
