<?php
// daemon_user_bids_dp.php — refresh cached table rows every 5s (runs without browser)

ini_set('display_errors', 1);
error_reporting(E_ALL);
set_time_limit(0);
date_default_timezone_set('Asia/Kolkata');

require __DIR__ . '/db.php'; // must create $conn = new mysqli(...)

$CACHE_DIR  = __DIR__ . '/cache';
$CACHE_FILE = $CACHE_DIR . '/user_bids_dp_rows.html';
$LOCK_FILE  = __DIR__ . '/daemon_user_bids_dp.lock';
$PID_FILE   = __DIR__ . '/daemon_user_bids_dp.pid';

if (!is_dir($CACHE_DIR)) mkdir($CACHE_DIR, 0775, true);

// single-instance lock
$lock = fopen($LOCK_FILE, 'c');
if (!$lock || !flock($lock, LOCK_EX | LOCK_NB)) {
    fwrite(STDERR, "Already running.\n");
    exit(1);
}
file_put_contents($PID_FILE, getmypid());

// helpers
function fetch_rows(mysqli $conn): array {
    $sql = "SELECT id,user_id,game_id,bid_details,total_bid_amount,created_at,
                   game_name,sub_games,bid_session,winning_open_time_dp,winning_close_time_dp
            FROM user_bids_dp ORDER BY id DESC LIMIT 200";
    $res = $conn->query($sql);
    if (!$res) return [];
    $rows = [];
    while ($r = $res->fetch_assoc()) $rows[] = $r;
    $res->free();
    return $rows;
}
function rows_to_html(array $rows): string {
    if (!$rows) return '<tr><td colspan="11">No rows</td></tr>';
    $out = '';
    foreach ($rows as $r) {
        $out .= '<tr>'.
            '<td>'.htmlspecialchars($r['id']).'</td>'.
            '<td>'.htmlspecialchars($r['user_id']).'</td>'.
            '<td>'.htmlspecialchars($r['game_id']).'</td>'.
            '<td>'.htmlspecialchars($r['bid_details']).'</td>'.
            '<td>'.htmlspecialchars($r['total_bid_amount']).'</td>'.
            '<td>'.htmlspecialchars($r['created_at']).'</td>'.
            '<td>'.htmlspecialchars($r['game_name']).'</td>'.
            '<td>'.htmlspecialchars($r['sub_games']).'</td>'.
            '<td>'.htmlspecialchars($r['bid_session']).'</td>'.
            '<td>'.htmlspecialchars($r['winning_open_time_dp']).'</td>'.
            '<td>'.htmlspecialchars($r['winning_close_time_dp']).'</td>'.
        '</tr>';
    }
    return $out;
}

// loop forever, writing cache every 5s
while (true) {
    if (!$conn->ping()) { @mysqli_close($conn); require __DIR__ . '/db.php'; }
    $html = rows_to_html(fetch_rows($conn));
    $tmp  = $CACHE_FILE . '.tmp';
    file_put_contents($tmp, $html, LOCK_EX);
    rename($tmp, $CACHE_FILE);               // atomic swap
    echo date('Y-m-d H:i:s') . " wrote cache\n";
    sleep(5);
}
