<?php
session_start();

// Check if user is logged in, if not, redirect to login page
if (!isset($_SESSION['email'])) {
    header("Location: login.php");
    exit;
}

// User's email from session
$email = $_SESSION['email'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Dashboard</title>
  <style>
    /* Basic resets */
    body {
      margin: 0;
      padding: 0;
      font-family: Arial, sans-serif;
      background-color: #f4f4f9;
    }
    /* Top Navbar styles */
    .navbar {
      background-color: #007bff;
      padding: 10px;
      color: white;
      text-align: center;
    }
    .navbar a {
      color: white;
      text-decoration: none;
      margin: 0 15px;
    }
    /* Main container for sidebar and content */
    .container {
      display: flex;
    }
    /* Sidebar styles */
    .sidebar {
      width: 200px;
      background-color: #343a40;
      color: white;
      height: calc(100vh - 50px); /* adjust if navbar height changes */
      padding: 20px;
    }
    .sidebar h3 {
      margin-top: 0;
      color: white;
    }
    .sidebar a {
      display: block;
      color: white;
      text-decoration: none;
      margin: 10px 0;
      padding: 8px;
      border-radius: 4px;
    }
    .sidebar a:hover {
      background-color: #495057;
    }
    /* Content area styles */
    .content {
      flex: 1;
      padding: 20px;
    }
    .card {
      background-color: white;
      border-radius: 8px;
      padding: 20px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
      margin-bottom: 20px;
    }
    .card h3 {
      margin: 0;
      padding: 0;
      color: #333;
    }
    .card p {
      color: #555;
    }
    .logout-btn {
      background-color: #f44336;
      padding: 10px 15px;
      border: none;
      color: white;
      border-radius: 5px;
      cursor: pointer;
    }
    .logout-btn:hover {
      background-color: #d32f2f;
    }
  </style>
</head>
<body>
  <!-- Top Navbar -->
  <div class="navbar">
    <h2>Sai App Dashboard</h2>
    <a href="project.php">Home</a>
    <a href="#">Profile</a>
    <a href="settings.php">Settings</a>
    <a href="logout.php" class="logout-btn">Logout</a>
  </div>

  <!-- Main container with Sidebar and Content -->
  <div class="container">
    <!-- Sidebar Menu -->
    <div class="sidebar">
      <h3>Menu</h3>
      <a href="#">Dashboard</a>
      
      <a href="project.php">Create Game</a>
      <a href="games.php">Games</a>
      <!-- <a href="single_digit.php">Single_Digit</a> -->
      <a href="report.php">Reports</a>
      <a href="invested.php">Invested</a>
      <a href="wallet.php">Wallet</a>
      <a href="resultsd.php">Results</a>
       <a href="userdata.php">Usertable</a>
      <a href="rewards_sd.php"> Score board</a>
       <a href="withdraw.php"> Withdraw </a>
        <a href="deposit.php"> Deposit </a>

         <a href="Single_digit.php"> Single Digit Report </a>
          <a href="jogi_report.php"> Jodi Report </a>
           <a href="single_panna_report.php"> Single panna Report </a>
         <a href="dp_report.php">Doble panna report </a>
        
        
        
        <a href="triple_panna_report.php"> Triple_Paana_Report </a>
               <a href="half_sangam_report.php"> half_sangam_report </a>
       <a href="full_sangam_report.php"> Full Sagnam Report </a>
       
    </div>

    <!-- Content Area -->
    <div class="content">
      <div class="card">
        <h3>Welcome, <?php echo $email; ?>!</h3>
        <p>This is your dashboard where you can manage your account.</p>
      </div>

      <div class="card">
        <h3>Your Recent Activity</h3>
        <p>No recent activity yet. Check back later!</p>
      </div>
      
      <!-- Additional sections or content can be added here -->
    </div>
  </div>
</body>
</html>
