<?php
// delete_bank_details_api.php
header('Content-Type: application/json; charset=utf-8');
ini_set('display_errors',1);
error_reporting(E_ALL);

require __DIR__ . '/db.php';  // gives you $conn

// 1) parse input
$raw = file_get_contents('php://input');
$in  = json_decode($raw, true);
$mobile = trim($in['mobile'] ?? '');

if (!preg_match('/^\d{10}$/', $mobile)) {
    echo json_encode(['status' => false, 'message' => 'Invalid mobile']);
    exit;
}

// 2) lookup user_id
$stmt = $conn->prepare("SELECT user_id FROM users_data WHERE mobile = ? LIMIT 1");
$stmt->bind_param('s', $mobile);
$stmt->execute();
$stmt->bind_result($uid);
if (!$stmt->fetch()) {
    $stmt->close();
    echo json_encode(['status' => false, 'message' => 'User not found']);
    exit;
}
$stmt->close();

// 3) delete the bank details row
$stmt = $conn->prepare("DELETE FROM user_bank_details WHERE user_id = ?");
$stmt->bind_param('i', $uid);
$ok = $stmt->execute();
$stmt->close();
$conn->close();

// 4) always return JSON
if ($ok) {
    echo json_encode(['status' => true, 'message' => 'Bank details removed']);
} else {
    echo json_encode(['status' => false, 'message' => 'Failed to remove details']);
}
