<?php
// Include database connection
include('db.php');

// Handle status update
if ($_POST['action'] ?? '' === 'update_status') {
    $id = (int)$_POST['id'];
    $status = mysqli_real_escape_string($conn, $_POST['status']);
    
    // Get deposit request details
    $getRequest = "SELECT * FROM deposit_requests WHERE id = $id";
    $requestResult = mysqli_query($conn, $getRequest);
    $request = mysqli_fetch_assoc($requestResult);
    
    if ($status === 'approved' && $request['status'] === 'pending') {
        // Update wallet balance
        $updateWallet = "UPDATE wallet SET balance = balance + {$request['amount']} WHERE user_id = {$request['user_id']}";
        mysqli_query($conn, $updateWallet);
    } elseif ($status === 'rejected' && $request['status'] === 'approved') {
        // Deduct from wallet if changing from approved to rejected
        $updateWallet = "UPDATE wallet SET balance = balance - {$request['amount']} WHERE user_id = {$request['user_id']}";
        mysqli_query($conn, $updateWallet);
    }
    
    // Update deposit request status
    $updateStatus = "UPDATE deposit_requests SET status = '$status' WHERE id = $id";
    mysqli_query($conn, $updateStatus);
    
    echo json_encode(['success' => true]);
    exit;
}

// Handle delete request
if ($_POST['action'] ?? '' === 'delete') {
    $id = (int)$_POST['id'];
    
    // Get deposit request details first
    $getRequest = "SELECT * FROM deposit_requests WHERE id = $id";
    $requestResult = mysqli_query($conn, $getRequest);
    $request = mysqli_fetch_assoc($requestResult);
    
    // If approved, deduct from wallet before deleting
    if ($request['status'] === 'approved') {
        $updateWallet = "UPDATE wallet SET balance = balance - {$request['amount']} WHERE user_id = {$request['user_id']}";
        mysqli_query($conn, $updateWallet);
    }
    
    // Delete screenshot file if exists
    if ($request['screenshot'] && file_exists('uploads/' . $request['screenshot'])) {
        unlink('uploads/' . $request['screenshot']);
    }
    
    // Delete deposit request
    $deleteRequest = "DELETE FROM deposit_requests WHERE id = $id";
    mysqli_query($conn, $deleteRequest);
    
    echo json_encode(['success' => true]);
    exit;
}

// Build WHERE clause for date filtering
$whereClause = "1=1";
$startDate = $_GET['start_date'] ?? '';
$endDate = $_GET['end_date'] ?? '';

if (!empty($startDate) && !empty($endDate)) {
    // Convert DD-MM-YYYY to YYYY-MM-DD
    $startDateFormatted = DateTime::createFromFormat('d-m-Y', $startDate);
    $endDateFormatted = DateTime::createFromFormat('d-m-Y', $endDate);
    
    if ($startDateFormatted && $endDateFormatted) {
        $startDateSQL = $startDateFormatted->format('Y-m-d');
        $endDateSQL = $endDateFormatted->format('Y-m-d');
        $whereClause .= " AND DATE(deposit_requests.created_at) BETWEEN '$startDateSQL' AND '$endDateSQL'";
    }
}

// Fetch deposit requests with related user details and wallet balance
$sql = "SELECT 
    deposit_requests.id, 
    deposit_requests.user_id, 
    users_data.username, 
    deposit_requests.amount, 
    deposit_requests.payment_method,
    deposit_requests.screenshot,
    deposit_requests.status, 
    deposit_requests.created_at, 
    wallet.balance 
FROM deposit_requests
JOIN users_data ON deposit_requests.user_id = users_data.user_id
JOIN wallet ON deposit_requests.user_id = wallet.user_id
WHERE $whereClause
ORDER BY deposit_requests.created_at DESC";

$result = mysqli_query($conn, $sql);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Deposit Requests</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
        .screenshot-thumb {
            width: 60px;
            height: 60px;
            object-fit: cover;
            cursor: pointer;
            border-radius: 5px;
        }
        .screenshot-modal img {
            max-width: 100%;
            max-height: 500px;
        }
        .status-pending { background-color: #fff3cd !important; color: #856404 !important; }
        .status-approved { background-color: #d1edff !important; color: #0c5460 !important; }
        .status-rejected { background-color: #f8d7da !important; color: #721c24 !important; }
        .table td { vertical-align: middle; }
    </style>
</head>
<body>
    <div class="container-fluid mt-4">
        <div class="row">
            <div class="col-12">
                <h2 class="mb-4">💰 Deposit Requests Management</h2>
                
                <!-- Filter Section -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0">📅 Filter by Date Range</h5>
                    </div>
                    <div class="card-body">
                        <form method="GET" action="">
                            <div class="row">
                                <div class="col-md-4">
                                    <label for="start_date" class="form-label">Start Date</label>
                                    <input type="text" class="form-control" id="start_date" name="start_date" 
                                           placeholder="dd-mm-yyyy" value="<?= htmlspecialchars($startDate) ?>">
                                </div>
                                <div class="col-md-4">
                                    <label for="end_date" class="form-label">End Date</label>
                                    <input type="text" class="form-control" id="end_date" name="end_date" 
                                           placeholder="dd-mm-yyyy" value="<?= htmlspecialchars($endDate) ?>">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">&nbsp;</label>
                                    <div class="d-grid">
                                        <button type="submit" class="btn btn-primary">🔍 Filter</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Stats Cards -->
                <?php
                $statsSQL = "SELECT 
                    COUNT(*) as total_requests,
                    SUM(CASE WHEN status = 'pending' THEN 1 ELSE 0 END) as pending_count,
                    SUM(CASE WHEN status = 'approved' THEN 1 ELSE 0 END) as approved_count,
                    SUM(CASE WHEN status = 'rejected' THEN 1 ELSE 0 END) as rejected_count,
                    SUM(CASE WHEN status = 'approved' THEN amount ELSE 0 END) as approved_amount
                    FROM deposit_requests WHERE $whereClause";
                $statsResult = mysqli_query($conn, $statsSQL);
                $stats = mysqli_fetch_assoc($statsResult);
                ?>
                <div class="row mb-4">
                    <div class="col-md-2">
                        <div class="card text-center">
                            <div class="card-body">
                                <h5 class="card-title text-primary"><?= $stats['total_requests'] ?></h5>
                                <p class="card-text small">Total Requests</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="card text-center">
                            <div class="card-body">
                                <h5 class="card-title text-warning"><?= $stats['pending_count'] ?></h5>
                                <p class="card-text small">Pending</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="card text-center">
                            <div class="card-body">
                                <h5 class="card-title text-success"><?= $stats['approved_count'] ?></h5>
                                <p class="card-text small">Approved</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="card text-center">
                            <div class="card-body">
                                <h5 class="card-title text-danger"><?= $stats['rejected_count'] ?></h5>
                                <p class="card-text small">Rejected</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card text-center">
                            <div class="card-body">
                                <h5 class="card-title text-success">₹<?= number_format($stats['approved_amount'], 2) ?></h5>
                                <p class="card-text small">Total Approved Amount</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Requests Table -->
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">📋 Deposit Requests</h5>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-striped table-hover mb-0">
                                <thead class="table-dark">
                                    <tr>
                                        <th width="50">#</th>
                                        <th width="80">User ID</th>
                                        <th width="120">Username</th>
                                        <th width="80">Amount</th>
                                        <th width="100">Payment Method</th>
                                        <th width="80">Screenshot</th>
                                        <th width="100">Current Balance</th>
                                        <th width="100">Status</th>
                                        <th width="150">Date</th>
                                        <th width="200">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    if (mysqli_num_rows($result) > 0) {
                                        while ($row = mysqli_fetch_assoc($result)) {
                                            $statusClass = 'status-' . strtolower($row['status']);
                                            echo '<tr>';
                                            echo '<td><strong>' . $row['id'] . '</strong></td>';
                                            echo '<td>' . $row['user_id'] . '</td>';
                                            echo '<td><strong>' . htmlspecialchars($row['username']) . '</strong></td>';
                                            echo '<td><strong class="text-success">₹' . number_format($row['amount'], 2) . '</strong></td>';
                                            echo '<td><span class="badge bg-info">' . strtoupper($row['payment_method']) . '</span></td>';
                                            echo '<td>';
                                            if ($row['screenshot']) {
                                                echo '<img src="uploads/' . $row['screenshot'] . '" class="screenshot-thumb" 
                                                          onclick="showScreenshot(\'' . $row['screenshot'] . '\')" 
                                                          title="Click to view full size">';
                                            } else {
                                                echo '<span class="text-muted">No Screenshot</span>';
                                            }
                                            echo '</td>';
                                            echo '<td><strong class="text-primary">₹' . number_format($row['balance'], 2) . '</strong></td>';
                                            echo '<td><span class="badge ' . $statusClass . '">' . strtoupper($row['status']) . '</span></td>';
                                            echo '<td>' . date('d M Y H:i', strtotime($row['created_at'])) . '</td>';
                                            echo '<td>';
                                            echo '<div class="btn-group" role="group">';
                                            echo '<select class="form-select form-select-sm status-dropdown me-2" data-id="' . $row['id'] . '" style="width: 120px;">';
                                            echo '<option value="pending"' . ($row['status'] == 'pending' ? ' selected' : '') . '>Pending</option>';
                                            echo '<option value="approved"' . ($row['status'] == 'approved' ? ' selected' : '') . '>Approved</option>';
                                            echo '<option value="rejected"' . ($row['status'] == 'rejected' ? ' selected' : '') . '>Rejected</option>';
                                            echo '</select>';
                                            echo '<button class="btn btn-danger btn-sm delete-btn" data-id="' . $row['id'] . '" title="Delete Request">';
                                            echo '🗑️';
                                            echo '</button>';
                                            echo '</div>';
                                            echo '</td>';
                                            echo '</tr>';
                                        }
                                    } else {
                                        echo '<tr><td colspan="10" class="text-center py-4">';
                                        echo '<div class="text-muted">';
                                        echo '<i class="fas fa-inbox fa-3x mb-3"></i>';
                                        echo '<h5>No Deposit Requests Found</h5>';
                                        echo '<p>No deposit requests match your criteria.</p>';
                                        echo '</div>';
                                        echo '</td></tr>';
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Screenshot Modal -->
    <div class="modal fade" id="screenshotModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Payment Screenshot</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body text-center screenshot-modal">
                    <img id="modalScreenshot" src="" alt="Payment Screenshot">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Show screenshot in modal
        function showScreenshot(filename) {
            $('#modalScreenshot').attr('src', 'uploads/' + filename);
            $('#screenshotModal').modal('show');
        }

        // Handle status change
        $(document).on('change', '.status-dropdown', function() {
            var status = $(this).val();
            var id = $(this).data('id');
            var originalStatus = $(this).find('option[selected]').val() || 'pending';
            
            if (confirm('Are you sure you want to change the status to ' + status.toUpperCase() + '?')) {
                $.ajax({
                    url: '',
                    type: 'POST',
                    data: {
                        action: 'update_status',
                        id: id, 
                        status: status
                    },
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            alert('Status updated successfully!');
                            location.reload();
                        } else {
                            alert('Error updating status');
                            // Revert dropdown to original value
                            $('[data-id="' + id + '"]').val(originalStatus);
                        }
                    },
                    error: function() {
                        alert('Network error occurred');
                        // Revert dropdown to original value
                        $('[data-id="' + id + '"]').val(originalStatus);
                    }
                });
            } else {
                // User cancelled, revert dropdown
                $(this).val(originalStatus);
            }
        });

        // Handle delete request
        $(document).on('click', '.delete-btn', function() {
            var id = $(this).data('id');
            if (confirm('Are you sure you want to delete this deposit request? This action cannot be undone.')) {
                $.ajax({
                    url: '',
                    type: 'POST',
                    data: {
                        action: 'delete',
                        id: id
                    },
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            alert('Deposit request deleted successfully!');
                            location.reload();
                        } else {
                            alert('Error deleting request');
                        }
                    },
                    error: function() {
                        alert('Network error occurred');
                    }
                });
            }
        });

        // Date picker formatting
        $('#start_date, #end_date').on('input', function() {
            let value = $(this).val().replace(/\D/g, '');
            if (value.length >= 2) {
                value = value.substring(0,2) + '-' + value.substring(2);
            }
            if (value.length >= 5) {
                value = value.substring(0,5) + '-' + value.substring(5);
            }
            if (value.length > 10) {
                value = value.substring(0,10);
            }
            $(this).val(value);
        });
    </script>
</body>
</html>
