<?php
header('Content-Type: application/json');
include('db.php');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Only POST method allowed']);
    exit;
}

try {
    $mobile = $_POST['mobile'] ?? '';
    $amount = (float)($_POST['amount'] ?? 0);
    $paymentMethod = $_POST['payment_method'] ?? '';
    
    // Validate input
    if (empty($mobile) || $amount <= 0 || empty($paymentMethod)) {
        throw new Exception('All fields are required');
    }
    
    if ($amount < 10) {
        throw new Exception('Minimum deposit amount is ₹10');
    }
    
    // Get user ID
    $userQuery = "SELECT user_id FROM users_data WHERE mobile = '$mobile'";
    $userResult = mysqli_query($conn, $userQuery);
    
    if (mysqli_num_rows($userResult) === 0) {
        throw new Exception('User not found');
    }
    
    $user = mysqli_fetch_assoc($userResult);
    $userId = $user['user_id'];
    
    // Handle screenshot upload
    $screenshotFilename = null;
    if (isset($_FILES['screenshot']) && $_FILES['screenshot']['error'] === UPLOAD_ERR_OK) {
        $uploadDir = 'uploads/';
        if (!file_exists($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }
        
        $fileExtension = pathinfo($_FILES['screenshot']['name'], PATHINFO_EXTENSION);
        $screenshotFilename = 'deposit_' . $userId . '_' . time() . '.' . $fileExtension;
        $uploadPath = $uploadDir . $screenshotFilename;
        
        if (!move_uploaded_file($_FILES['screenshot']['tmp_name'], $uploadPath)) {
            throw new Exception('Failed to upload screenshot');
        }
    }
    
    // Insert deposit request
    $insertSQL = "INSERT INTO deposit_requests (user_id, amount, payment_method, screenshot, status, created_at) 
                  VALUES ($userId, $amount, '$paymentMethod', " . 
                  ($screenshotFilename ? "'$screenshotFilename'" : 'NULL') . 
                  ", 'pending', NOW())";
    
    if (!mysqli_query($conn, $insertSQL)) {
        throw new Exception('Failed to create deposit request: ' . mysqli_error($conn));
    }
    
    echo json_encode([
        'success' => true, 
        'message' => 'Deposit request submitted successfully',
        'data' => [
            'request_id' => mysqli_insert_id($conn),
            'amount' => $amount,
            'status' => 'pending'
        ]
    ]);
    
} catch (Exception $e) {
    // Clean up uploaded file if there was an error
    if (isset($screenshotFilename) && file_exists('uploads/' . $screenshotFilename)) {
        unlink('uploads/' . $screenshotFilename);
    }
    
    echo json_encode([
        'success' => false, 
        'message' => $e->getMessage()
    ]);
}
?>
