<?php
// double_paana_result.php

ini_set('display_errors',1);
ini_set('display_startup_errors',1);
error_reporting(E_ALL);

session_start();
date_default_timezone_set('Asia/Kolkata');

require_once 'db.php';
if ($conn->connect_error) {
    die("DB connect failed: " . $conn->connect_error);
}

// 1) Date filter
$date = $_GET['date'] ?? date('Y-m-d');
if (!preg_match('/^\d{4}-\d{2}-\d{2}$/',$date)) {
    die("Invalid date.");
}
$safeDate = $conn->real_escape_string($date);

// 2) Double-Pana lookup lists
$doublePana = [
  '0'=>['118','226','244','299','334','488','550','668','677'],
  '1'=>['100','119','155','227','335','344','399','588','669'],
  '2'=>['110','200','228','255','336','499','660','688','778'],
  '3'=>['166','229','300','337','355','445','599','779','788'],
  '4'=>['112','220','266','338','400','446','455','699','770'],
  '5'=>['113','122','177','339','366','447','500','799','889'],
  '6'=>['600','114','277','330','448','466','556','880','899'],
  '7'=>['115','133','188','223','377','449','557','566','700'],
  '8'=>['116','224','233','288','440','477','558','800','990'],
  '9'=>['117','144','199','225','388','559','577','667','900'],
];

// 3) Fetch today’s bids
$sql = "
  SELECT
    ub.id            AS bid_id,
    ub.user_id,
    u.username,
    g.id             AS game_id,
    g.game_name,
    g.open_time,
    g.close_time,
    ub.bid_details,
    ub.total_bid_amount,
    ub.bid_session
  FROM user_bids_dp ub
  JOIN users_data u ON ub.user_id = u.user_id
  JOIN game56     g ON ub.game_id  = g.id
  WHERE DATE(ub.created_at) = '$safeDate'
  ORDER BY ub.created_at ASC
";
$bids = $conn->query($sql)->fetch_all(MYSQLI_ASSOC);

// 4) Load existing dp_result rows by bid_id
$stored = [];
if ($bids) {
    $ids = array_column($bids,'bid_id');
    $in  = implode(',', array_map('intval',$ids));
    $qr  = $conn->query("
      SELECT bid_id, win_open_dp, win_close_dp
      FROM dp_result
      WHERE bid_id IN ($in)
    ");
    while ($r = $qr->fetch_assoc()) {
        $stored[$r['bid_id']] = [
          'open'  => $r['win_open_dp'],
          'close' => $r['win_close_dp'],
        ];
    }
}

// 5) Prepare INSERT IGNORE (13 columns → 13 placeholders)
$ins = $conn->prepare("
  INSERT IGNORE INTO dp_result (
    reward_id,
    bid_id,
    user_id,
    username,
    bid_number,
    bid_amount,
    bid_session,
    win_open_dp,
    win_close_dp,
    res_open,
    res_close,
    paid_open,
    paid_close
  ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)
");
if (!$ins) {
    die("INSERT prepare failed: " . $conn->error);
}

// 6) For each bid not yet stored, pick two distinct wins and insert
foreach ($bids as $row) {
    $bidId = $row['bid_id'];
    if (isset($stored[$bidId])) continue;

    // determine open vs close winners
    $last    = substr($row['bid_details'],-1);
    $choices = $doublePana[$last] ?? [];
    if (count($choices) < 2) {
      $wO = $wC = $choices[0] ?? 'N/A';
    } else {
      $keys = array_rand($choices,2);
      $wO   = $choices[$keys[0]];
      do {
        $wC = $choices[array_rand($choices)];
      } while ($wC === $wO);
    }
    $stored[$bidId] = ['open'=>$wO,'close'=>$wC];

    // PREDECLARE every parameter
    $paramRewardId  = 0;
    $paramBidId     = $bidId;
    $paramUserId    = $row['user_id'];
    $paramUsername  = $row['username'];
    $paramBidNumber = $last;
    $paramBidAmount = $row['total_bid_amount'];
    $paramSession   = $row['bid_session'];
    $paramWinOpen   = $wO;
    $paramWinClose  = $wC;
    $paramResOpen   = '';
    $paramResClose  = '';
    $paramPaidOpen  = 0;
    $paramPaidClose = 0;

    // bind 13 variables in order
    $ins->bind_param(
      'iiisidsiissdd',
      $paramRewardId,
      $paramBidId,
      $paramUserId,
      $paramUsername,
      $paramBidNumber,
      $paramBidAmount,
      $paramSession,
      $paramWinOpen,
      $paramWinClose,
      $paramResOpen,
      $paramResClose,
      $paramPaidOpen,
      $paramPaidClose
    );
    $ins->execute();
}

// 7) Render HTML
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Double-Paana : Player Results</title>
  <style>
    body{font-family:Arial,sans-serif;padding:20px}
    form{margin-bottom:20px}
    table{width:100%;border-collapse:collapse;margin-top:10px}
    th,td{border:1px solid #ccc;padding:8px;text-align:center}
    th{background:#007bff;color:#fff}
    .win{color:green;font-weight:bold}
    .lose{color:red;font-weight:bold}
    em{color:#555;font-style:italic}
  </style>
</head>
<body>

  <h2>Double-Paana : Player Results</h2>
  <form method="get">
    <label>Date:</label>
    <input type="date" name="date" value="<?=htmlspecialchars($date)?>">
    <button>View</button>
  </form>

  <?php if (empty($bids)): ?>
    <p><em>No bids found on <?=htmlspecialchars($date)?>.</em></p>
  <?php else: ?>
  <table>
    <thead>
      <tr>
        <th>Game</th><th>Open</th><th>Close</th>
        <th>User</th><th>Digit</th><th>Amt</th><th>Session</th>
        <th>Win # (O)</th><th>Win # (C)</th>
        <th>Result O</th><th>Result C</th>
      </tr>
    </thead>
    <tbody>
      <?php
        $now = date('H:i:s');
        foreach ($bids as $r):
          $winO = $stored[$r['bid_id']]['open'];
          $winC = $stored[$r['bid_id']]['close'];
          $full = $r['bid_details'];
          $sess = $r['bid_session'];
          $isOW = ($sess==='open'  && $full===$winO);
          $isCW = ($sess==='close' && $full===$winC);
          $resO = $isOW?'Congratulations':'Better luck';
          $resC = $isCW?'Congratulations':'Better luck';
      ?>
      <tr>
        <td><?=$r['game_name']?></td>
        <td><?=date('g:i A',strtotime($r['open_time']))?></td>
        <td><?=date('g:i A',strtotime($r['close_time']))?></td>
        <td><?=$r['username']?></td>
        <td><?=$full?></td>
        <td>₹<?=number_format($r['total_bid_amount'],2)?></td>
        <td><?=ucfirst($sess)?></td>
        <td>
          <?= ($now<date('H:i:s',strtotime($r['open_time'])))
             ? '<em>Yet to Open</em>'
             : $winO ?>
        </td>
        <td>
          <?= ($now<date('H:i:s',strtotime($r['close_time'])))
             ? '<em>Game is Running</em>'
             : $winC ?>
        </td>
        <td>
          <span class="<?=$isOW?'win':'lose'?>">
            <?=$isOW?'✔ '.$resO:'✘ '.$resO?>
          </span>
        </td>
        <td>
          <span class="<?=$isCW?'win':'lose'?>">
            <?=$isCW?'✔ '.$resC:'✘ '.$resC?>
          </span>
        </td>
      </tr>
      <?php endforeach;?>
    </tbody>
  </table>
  <?php endif; ?>

</body>
</html>
