<?php
// Show errors for debugging (remove in production)
ini_set('display_errors',1);
ini_set('display_startup_errors',1);
error_reporting(E_ALL);

session_start();
include 'db.php'; // your mysqli connection

// 1) Authentication
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

// 2) Fetch all games
date_default_timezone_set('Asia/Kolkata');

// ===== NEW: WEEKEND CLOSURE LOGIC =====
$currentDay = date('N'); // 1=Monday, 6=Saturday, 7=Sunday

// Define games that close on Saturday and Sunday
$saturdaySundayClosedGames = [
    'KALYAN NIGHT',
    'RAJDHANI NIGHT', 
    'MAIN BAZAR'
];

// Define games that close only on Sunday
$sundayClosedGames = [
    'TIME BAZAR',
    'RAJDHANI DAY',
    'MILAN DAY',
    'KALYAN',
    'MILAN NIGHT'
];

// Function to check if a game should be closed today
function isGameClosedToday($gameName, $currentDay, $satSunClosed, $sunOnlyClosed) {
    $gameNameUpper = strtoupper(trim($gameName));
    
    // Check Saturday and Sunday closures
    if (($currentDay == 6 || $currentDay == 7)) { // Saturday or Sunday
        foreach ($satSunClosed as $closedGame) {
            if (strpos($gameNameUpper, strtoupper($closedGame)) !== false) {
                return true;
            }
        }
    }
    
    // Check Sunday only closures
    if ($currentDay == 7) { // Sunday only
        foreach ($sunOnlyClosed as $closedGame) {
            if (strpos($gameNameUpper, strtoupper($closedGame)) !== false) {
                return true;
            }
        }
    }
    
    return false;
}
// ===== END WEEKEND CLOSURE LOGIC =====

$sql    = "SELECT * FROM game56";
$result = $conn->query($sql);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Running Games</title>
  <style>
    /* Reset & Base */
    * { box-sizing: border-box; margin: 0; padding: 0; }
    body { font-family: Arial, sans-serif; background: #f0f2f5; color: #333; }

    /* Navbar */
    .navbar {
      background: #007bff;
      color: #fff;
      text-align: center;
      position: relative;
      padding: 12px 8px;
    }
    .navbar h2 { font-size: 1.2rem; }
    .back-button {
      position: absolute;
      left: 8px;
      top: 50%;
      transform: translateY(-50%);
      background: #28a745;
      color: #fff;
      padding: 6px 10px;
      text-decoration: none;
      border-radius: 4px;
      font-size: 0.85rem;
    }
    .back-button:hover { background: #218838; }

    /* Content Grid */
    .content {
      max-width: 1000px;
      margin: 16px auto;
      padding: 0 12px;
      display: grid;
      grid-gap: 16px;
      grid-template-columns: repeat(auto-fit, minmax(260px, 1fr));
    }

    /* Card */
    .game-card {
      background: #fff;
      border-radius: 10px;
      overflow: hidden;
      box-shadow: 0 2px 8px rgba(0,0,0,0.1);
      display: flex;
      flex-direction: column;
      transition: transform .2s, box-shadow .2s;
    }
    .game-card:hover {
      transform: translateY(-3px);
      box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    }
    
    /* Closed game styling */
    .game-card.closed {
      opacity: 0.6;
      background: #f8f9fa;
    }
    .game-card.closed:hover {
      transform: none;
      box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }

    /* Header */
    .game-card h3 {
      margin: 0;
      padding: 14px;
      background: linear-gradient(135deg, #007bff, #0056b3);
      color: #fff;
      font-size: 1rem;
      text-align: center;
    }
    
    .game-card.closed h3 {
      background: linear-gradient(135deg, #6c757d, #495057);
    }

    /* Body */
    .game-card .body {
      padding: 12px;
      flex: 1;
      display: flex;
      flex-direction: column;
      gap: 6px;
      font-size: 0.9rem;
      line-height: 1.4;
    }
    .game-card .body p { margin: 0; }
    .game-card .body p.status-message {
      color: #d9534f;
      font-weight: bold;
    }
    .game-card.closed .body p.status-message {
      color: #6c757d;
    }

    /* Footer / Button */
    .game-card .footer {
      padding: 12px;
      background: #f8f9fa;
      text-align: center;
    }
    .game-button {
      background: #28a745;
      color: #fff;
      padding: 8px 16px;
      border: none;
      border-radius: 5px;
      font-size: 0.9rem;
      cursor: pointer;
      transition: background .2s;
      width: 100%;
    }
    .game-button:hover { background: #218838; }
    .game-button:disabled {
      background: #ccc;
      cursor: not-allowed;
    }

    /* Responsive Typography */
    @media (min-width: 600px) {
      .navbar h2 { font-size: 1.4rem; }
      .game-card h3 { font-size: 1.1rem; }
      .game-card .body { font-size: 0.95rem; }
      .game-button { font-size: 1rem; }
    }
  </style>
</head>
<body>

  <div class="navbar">
    <a href="dashboard.php" class="back-button">Back</a>
    <h2>Welcome to Sai App - Running Games</h2>
  </div>

  <div class="content">
    <?php if ($result && $result->num_rows > 0): ?>
      <?php while ($row = $result->fetch_assoc()): ?>
        <?php
          $now          = time();
          $open_ts      = strtotime($row['open_time']);
          $open_bid_ts  = strtotime($row['open_bid_last_time']);   // when open-bidding stops
          $close_ts     = strtotime($row['close_time']);
          $close_bid_ts = strtotime($row['close_bid_last_time']);  // when close-bidding stops

          // ===== NEW: CHECK WEEKEND CLOSURE FIRST =====
          $isClosedToday = isGameClosedToday(
              $row['game_name'], 
              $currentDay, 
              $saturdaySundayClosedGames, 
              $sundayClosedGames
          );
          
          if ($isClosedToday) {
              $status_text = "Game is closed for today";
              $disabled = true;
              $cardClass = "closed";
          } else {
              $cardClass = "";
              // ===== ORIGINAL TIME-BASED LOGIC =====
              if ($now < $open_bid_ts) {
                  // before the open-bid cutoff…
                  $status_text = "Game is open for bid";
                  $disabled    = false;
              }
              elseif ($now < $open_ts) {
                  // after open-bid cutoff, before result-open…
                  $status_text = "Open bidding is closed";
                  $disabled    = true;
              }
              elseif ($now < $close_bid_ts) {
                  // after result-open, before close-bid cutoff…
                  $status_text = "Game is Running";
                  $disabled    = false;
              }
              elseif ($now < $close_ts) {
                  // after close-bid cutoff, before result-close…
                  $status_text = "Close bidding is closed";
                  $disabled    = true;
              }
              else {
                  // after result-close…
                  $status_text = "Game has Closed";
                  $disabled    = true;
              }
          }
          
          // ← ADD THIS: write the computed status back into your DB
          if ($upd = $conn->prepare("UPDATE game56 SET status = ? WHERE id = ?")) {
            $upd->bind_param('si', $status_text, $row['id']);
            $upd->execute();
            $upd->close();
          }
        ?>
        <div class="game-card <?= $cardClass ?>">
          <h3><?= htmlspecialchars($row['game_name']) ?></h3>
          <div class="body">
            <p><strong>Number:</strong> <?= htmlspecialchars($row['game_number']) ?></p>
            <p><strong>Open Result:</strong> <?= date("g:i A", $open_ts) ?> IST</p>
            <p><strong>Close Result:</strong> <?= date("g:i A", $close_ts) ?> IST</p>
            <p><strong>Open Bid Last:</strong> <?= date("g:i A", $open_bid_ts) ?> IST</p>
            <p><strong>Close Bid Last:</strong> <?= date("g:i A", $close_bid_ts) ?> IST</p>
            <p class="<?= $disabled ? 'status-message' : '' ?>"><?= $status_text ?></p>
          </div>
          <div class="footer">
            <form action="play_game.php" method="get">
              <input type="hidden" name="game_id" value="<?= $row['id'] ?>">
              <button type="submit" class="game-button" <?= $disabled ? 'disabled' : '' ?>>
                Play Game
              </button>
            </form>
          </div>
        </div>
      <?php endwhile; ?>
    <?php else: ?>
      <p style="text-align:center; margin-top:32px;">No running games at the moment.</p>
    <?php endif; ?>
  </div>

</body>
</html>