<?php
// generate_dp_rewards.php
// CLI script to seed & roll Double-Panna rewards
declare(strict_types=1);
date_default_timezone_set('Asia/Kolkata');
error_reporting(E_ALL);
ini_set('display_errors','1');

require __DIR__ . '/db.php';   // creates $conn = new mysqli(…)
$today = date('Y-m-d');
$nowTs = time();

// your 0–9 → 9-element DP sets
$doublePanna = [
  0=>['118','226','244','299','334','488','550','668','677'],
  1=>['100','119','155','227','335','344','399','588','669'],
  2=>['110','200','228','255','336','499','660','688','778'],
  3=>['166','229','300','337','355','445','599','779','788'],
  4=>['112','220','266','338','400','446','455','699','770'],
  5=>['113','122','177','339','366','447','500','799','889'],
  6=>['600','114','277','330','448','466','556','880','899'],
  7=>['115','133','188','223','377','449','557','566','700'],
  8=>['116','224','233','288','440','477','558','800','990'],
  9=>['117','144','199','225','388','559','577','667','900'],
];

// 1) pull today’s games
$stmt = $conn->prepare(
  "SELECT id, game_name, open_time, close_time
     FROM game56
    WHERE DATE(open_time)=?"
);
$stmt->bind_param('s',$today);
$stmt->execute();
$stmt->bind_result($gid,$gname,$gopen,$gclose);
$games=[];
while($stmt->fetch()){
  $games[]=[
    'id'=>$gid,
    'name'=>$gname,
    'open_ts'=>strtotime("$today $gopen"),
    'close_ts'=>strtotime("$today $gclose"),
    'open_str'=>$gopen,
    'close_str'=>$gclose
  ];
}
$stmt->close();

// 2) seed one row / game
$ins = $conn->prepare(
  "INSERT IGNORE INTO dp_rewards
     (game_id, game_name, open_time, close_time, reward_date)
   VALUES(?,?,?,?,?)"
);
foreach($games as $g){
  $ins->bind_param(
    'issss',
    $g['id'],
    $g['name'],
    $g['open_str'],
    $g['close_str'],
    $today
  );
  $ins->execute();
}
$ins->close();

// 3) prepare updates for open/close when time arrives
$upOpen = $conn->prepare(
  "UPDATE dp_rewards
      SET winning_open_time_dp = ?, created_at = NOW()
    WHERE reward_date = ?
      AND game_id     = ?
      AND winning_open_time_dp IS NULL
      AND CONCAT(reward_date,' ',open_time) <= NOW()"
);
$upClose = $conn->prepare(
  "UPDATE dp_rewards
      SET winning_close_time_dp = ?, created_at = NOW()
    WHERE reward_date = ?
      AND game_id      = ?
      AND winning_close_time_dp IS NULL
      AND CONCAT(reward_date,' ',close_time) <= NOW()"
);

// 4) roll random picks
foreach($games as $g){
  // OPEN
  if($nowTs >= $g['open_ts']){
    // pick a random 3-digit from one of the sets
    $key      = array_rand($doublePanna);
    $winnerO  = $doublePanna[$key][array_rand($doublePanna[$key])];
    $upOpen->bind_param('sis',$winnerO,$today,$g['id']);
    $upOpen->execute();
  }
  // CLOSE
  if($nowTs >= $g['close_ts']){
    $key      = array_rand($doublePanna);
    $winnerC  = $doublePanna[$key][array_rand($doublePanna[$key])];
    $upClose->bind_param('sis',$winnerC,$today,$g['id']);
    $upClose->execute();
  }
}

// 5) cleanup
$upOpen ->close();
$upClose->close();
$conn->close();
