<?php
// generate_fs_rewards.php
declare(strict_types=1);

date_default_timezone_set('Asia/Kolkata');
error_reporting(E_ALL);
ini_set('display_errors','1');

require __DIR__ . '/db.php';   // $conn = new mysqli(...)
$today    = date('Y-m-d');
$nowTs    = time();

// 1) Build your four pools
// 1.a Jodi (00–99)
$jodi = [];
for ($i = 0; $i < 100; $i++) {
    $jodi[] = str_pad((string)$i, 2, '0', STR_PAD_LEFT);
}
// 1.b Single-Pana (flattened)
$singlePana = [
  '0'=>['127','136','145','190','235','280','370','389','460','479','569','578'],
  '1'=>['128','137','146','236','245','290','380','470','489','560','579','678'],
  '2'=>['129','138','147','156','237','246','345','390','480','570','589','679'],
  '3'=>['120','139','148','157','238','247','256','346','490','580','670','689'],
  '4'=>['130','149','158','167','239','248','257','347','356','590','680','789'],
  '5'=>['140','159','168','230','249','258','267','348','357','456','690','780'],
  '6'=>['123','150','169','178','240','259','268','349','358','367','457','790'],
  '7'=>['124','160','178','179','250','269','340','359','368','458','467','890'],
  '8'=>['125','134','170','189','260','279','350','369','468','378','459','567'],
  '9'=>['126','135','180','234','270','289','360','379','450','469','478','568'],
];
$sp = array_merge(...array_values($singlePana));

// 1.c Double-Pana
$dp = [
  '0'=>['118','226','244','299','334','488','550','668','677'],
  '1'=>['100','119','155','227','335','344','399','588','669'],
  '2'=>['110','200','228','255','336','499','660','688','778'],
  '3'=>['166','229','300','337','355','445','599','779','788'],
  '4'=>['112','220','266','338','400','446','455','699','770'],
  '5'=>['113','122','177','339','366','447','500','799','889'],
  '6'=>['114','224','277','330','448','466','556','880','899'],
  '7'=>['115','133','188','223','377','449','557','566','700'],
  '8'=>['116','224','233','288','440','477','558','800','990'],
  '9'=>['117','144','199','225','388','559','577','667','900'],
];
$dp_flat = array_merge(...array_values($dp));

// 1.d Triple-Pana
$tp = ['000','111','222','333','444','555','666','777','888','999'];

// assemble
$fs_sets = [
  'Jodi Digit'  => $jodi,
  'Single Pana' => $sp,
  'Double Pana' => $dp_flat,
  'Triple Pana' => $tp,
];

// 2) Pull today’s games
$stmt = $conn->prepare(
  "SELECT id, game_name, open_time, close_time
     FROM game56
    WHERE DATE(open_time)=?"
);
$stmt->bind_param('s',$today);
$stmt->execute();
$stmt->bind_result($gid,$gname,$gopen,$gclose);

$games = [];
while($stmt->fetch()){
  $games[] = [
    'id'       => $gid,
    'open_ts'  => strtotime("$today $gopen"),
    'close_ts' => strtotime("$today $gclose"),
  ];
}
$stmt->close();

// 3) Seed fs_rewards
$ins = $conn->prepare(
  "INSERT IGNORE INTO fs_rewards
     (game_id,game_name,open_time,close_time,reward_date)
   VALUES(?,?,?,?,?)"
);
foreach ($games as $g){
  $ins->bind_param(
    'issss',
    $g['id'],
    $g['id'],     // game_name can be fetched by your pages, ID is enough here
    date('H:i:s',$g['open_ts']),
    date('H:i:s',$g['close_ts']),
    $today
  );
  $ins->execute();
}
$ins->close();

// 4) Prepare update statements
$upd = [];
foreach (['open','close'] as $sess) {
  foreach (['op','cp'] as $half) {
    $col = "winning_{$sess}_{$half}_fs";
    $upd["{$sess}_{$half}"] = $conn->prepare(<<<SQL
      UPDATE fs_rewards
         SET {$col} = ?
       WHERE reward_date=?
         AND game_id=?
         AND {$col} IS NULL
         AND CONCAT(reward_date,' ',$sess.'_time') <= NOW()
    SQL
    );
  }
}

// 5) Roll winners
foreach ($games as $g) {
  // OPEN session
  if ($nowTs >= $g['open_ts']) {
    foreach (['op','cp'] as $half) {
      $set = $fs_sets[array_rand($fs_sets)];
      $digit = $set[array_rand($set)];
      $upd["open_{$half}"]->bind_param('sis',$digit,$today,$g['id']);
      $upd["open_{$half}"]->execute();
    }
  }
  // CLOSE session
  if ($nowTs >= $g['close_ts']) {
    foreach (['op','cp'] as $half) {
      $set = $fs_sets[array_rand($fs_sets)];
      $digit = $set[array_rand($set)];
      $upd["close_{$half}"]->bind_param('sis',$digit,$today,$g['id']);
      $upd["close_{$half}"]->execute();
    }
  }
}

// 6) Cleanup
foreach ($upd as $u) $u->close();
$conn->close();
