<?php
// generate_hs_rewards.php
declare(strict_types=1);

date_default_timezone_set('Asia/Kolkata');
error_reporting(E_ALL);
ini_set('display_errors','1');

require __DIR__ . '/db.php';  // sets up $conn = new mysqli(...)
$today  = date('Y-m-d');
$nowTs  = time();

// 1) Your Half-Sangam sets
$hs_sets = [
  '0'=> ['00','01','02','03','04','05','06','07','08','09'],
  '1'=> ['11','10','12','13','14','15','16','17','18','19'],
  '2'=> ['22','20','21','23','24','25','26','27','28','29'],
  '3'=> ['33','30','31','32','34','35','36','37','38','39'],
  '4'=> ['44','40','41','42','43','45','46','47','48','49'],
  '5'=> ['55','50','51','52','53','54','56','57','58','59'],
  '6'=> ['66','60','61','62','63','64','65','67','68','69'],
  '7'=> ['77','70','71','72','73','74','75','76','78','79'],
  '8'=> ['88','80','81','82','83','84','85','86','87','89'],
  '9'=> ['99','90','91','92','93','94','95','96','97','98'],
];

// 2) Fetch today's games
$stmt = $conn->prepare(
  "SELECT id, game_name, open_time, close_time
     FROM game56
    WHERE DATE(open_time)=?"
);
$stmt->bind_param('s', $today);
$stmt->execute();
$stmt->bind_result($gid,$gname,$gopen,$gclose);

$games = [];
while($stmt->fetch()){
  $games[] = [
    'id'        => $gid,
    'name'      => $gname,
    'open_ts'   => strtotime("$today $gopen"),
    'close_ts'  => strtotime("$today $gclose"),
    'open_str'  => $gopen,
    'close_str' => $gclose,
  ];
}
$stmt->close();

// 3) Seed one row per game
$ins = $conn->prepare(
  "INSERT IGNORE INTO hs_rewards
     (game_id,game_name,open_time,close_time,reward_date)
   VALUES(?,?,?,?,?)"
);
foreach($games as $g){
  $ins->bind_param(
    'issss',
    $g['id'],
    $g['name'],
    $g['open_str'],
    $g['close_str'],
    $today
  );
  $ins->execute();
}
$ins->close();

// 4) Prepare update statements
$updOpenOD = $conn->prepare(
  "UPDATE hs_rewards
      SET winning_open_time_od_hs = ?
    WHERE reward_date=? AND game_id=? AND winning_open_time_od_hs IS NULL
      AND CONCAT(reward_date,' ',open_time) <= NOW()"
);
$updOpenCP = $conn->prepare(
  "UPDATE hs_rewards
      SET winning_open_time_cp_hs = ?
    WHERE reward_date=? AND game_id=? AND winning_open_time_cp_hs IS NULL
      AND CONCAT(reward_date,' ',open_time) <= NOW()"
);
$updCloseOD = $conn->prepare(
  "UPDATE hs_rewards
      SET winning_close_time_od_hs = ?
    WHERE reward_date=? AND game_id=? AND winning_close_time_od_hs IS NULL
      AND CONCAT(reward_date,' ',close_time) <= NOW()"
);
$updCloseCP = $conn->prepare(
  "UPDATE hs_rewards
      SET winning_close_time_cp_hs = ?
    WHERE reward_date=? AND game_id=? AND winning_close_time_cp_hs IS NULL
      AND CONCAT(reward_date,' ',close_time) <= NOW()"
);

// 5) Roll winners at open/close
foreach($games as $g){
  // OPEN
  if($nowTs >= $g['open_ts']){
    // OD
    $k = array_rand($hs_sets);
    $d = $hs_sets[$k][array_rand($hs_sets[$k])];
    $updOpenOD->bind_param('sis', $d, $today, $g['id']);
    $updOpenOD->execute();
    // CP
    $k2= array_rand($hs_sets);
    $d2= $hs_sets[$k2][array_rand($hs_sets[$k2])];
    $updOpenCP->bind_param('sis', $d2, $today, $g['id']);
    $updOpenCP->execute();
  }
  // CLOSE
  if($nowTs >= $g['close_ts']){
    // OD
    $k3= array_rand($hs_sets);
    $d3= $hs_sets[$k3][array_rand($hs_sets[$k3])];
    $updCloseOD->bind_param('sis', $d3, $today, $g['id']);
    $updCloseOD->execute();
    // CP
    $k4= array_rand($hs_sets);
    $d4= $hs_sets[$k4][array_rand($hs_sets[$k4])];
    $updCloseCP->bind_param('sis', $d4, $today, $g['id']);
    $updCloseCP->execute();
  }
}

// 6) Clean up
$updOpenOD->close();
$updOpenCP->close();
$updCloseOD->close();
$updCloseCP->close();
$conn->close();
