<?php
// generate_jd_rewards.php
declare(strict_types=1);

// — 0) Setup
date_default_timezone_set('Asia/Kolkata');
error_reporting(E_ALL);
ini_set('display_errors','1');

require __DIR__ . '/db.php';  // sets up $conn = new mysqli(...)

$today = date('Y-m-d');
$nowTs = time();

// — 1) Build the 00–99 jodi list
$jd_nums = [];
for ($i = 0; $i < 100; $i++) {
    $jd_nums[] = str_pad((string)$i, 2, '0', STR_PAD_LEFT);
}

// — 2) Fetch all games opening today
$stmt = $conn->prepare(
  "SELECT id, game_name, open_time, close_time
     FROM game56
    WHERE DATE(open_time)=?"
);
$stmt->bind_param('s', $today);
$stmt->execute();
$stmt->bind_result($gid, $gname, $gopen, $gclose);

$games = [];
while ($stmt->fetch()) {
    $games[] = [
      'id'        => $gid,
      'name'      => $gname,
      'open_ts'   => strtotime("$today $gopen"),
      'close_ts'  => strtotime("$today $gclose"),
      'open_str'  => $gopen,
      'close_str' => $gclose,
    ];
}
$stmt->close();

// — 3) Seed one row per game in jd_rewards
$ins = $conn->prepare(
  "INSERT IGNORE INTO jd_rewards
     (game_id, game_name, open_time, close_time, reward_date)
   VALUES (?,?,?,?,?)"
);
foreach ($games as $g) {
    $ins->bind_param(
      'issss',
      $g['id'],
      $g['name'],
      $g['open_str'],
      $g['close_str'],
      $today
    );
    $ins->execute();
}
$ins->close();

// — 4) Prepare the open/close update statements
$upOpen = $conn->prepare(
  "UPDATE jd_rewards
      SET winning_open_time_jd = ?
    WHERE reward_date = ?
      AND game_id     = ?
      AND winning_open_time_jd IS NULL
      AND CONCAT(reward_date,' ',open_time) <= NOW()"
);
$upClose = $conn->prepare(
  "UPDATE jd_rewards
      SET winning_close_time_jd = ?
    WHERE reward_date = ?
      AND game_id      = ?
      AND winning_close_time_jd IS NULL
      AND CONCAT(reward_date,' ',close_time) <= NOW()"
);

// — 5) Roll at the right times
foreach ($games as $g) {
    // OPEN
    if ($nowTs >= $g['open_ts']) {
        $digit = $jd_nums[array_rand($jd_nums)];
        $upOpen->bind_param('sis', $digit, $today, $g['id']);
        $upOpen->execute();
    }
    // CLOSE
    if ($nowTs >= $g['close_ts']) {
        $digit2 = $jd_nums[array_rand($jd_nums)];
        $upClose->bind_param('sis', $digit2, $today, $g['id']);
        $upClose->execute();
    }
}

$upOpen->close();
$upClose->close();
$conn->close();
