// <?php
// // generate_sd_rewards.php
// // CLI script to pre-generate every day’s single-digit rewards at midnight.
// // Add to crontab (run at 00:00 IST daily):
// //   0 0 * * * /usr/bin/php /path/to/generate_sd_rewards.php

// declare(strict_types=1);
// date_default_timezone_set('Asia/Kolkata');
// error_reporting(E_ALL);
// ini_set('display_errors', '1');

// // 1) Database connection
// require __DIR__ . '/db.php';   // sets up $conn = new mysqli(...)

// // 2) Today's date (IST)
// $utcNow = time();
// $istNow = $utcNow + (5 * 3600 + 30 * 60);

// // 3) figure out “IST today” by formatting that
// $today = gmdate('Y-m-d', $istNow);

// // 3) Fetch all games (no date filter)
// $games = [];
// $stmt = $conn->prepare("
//     SELECT id, game_name, open_time, close_time
//       FROM game56
//     ORDER BY id
// ");
// $stmt->execute();
// $stmt->bind_result($gid, $gname, $gopen, $gclose);

// while ($stmt->fetch()) {
//     $games[] = [
//         'id'        => $gid,
//         'name'      => $gname,
//         'open_str'  => $gopen,
//         'close_str' => $gclose,
//     ];
// }
// $stmt->close();

// // 4) Ensure one row per game in sd_rewards for today
// $ins = $conn->prepare("
//     INSERT IGNORE INTO sd_rewards
//       (game_id, game_name, open_time, close_time, reward_date)
//     VALUES (?, ?, ?, ?, ?)
// ");
// foreach ($games as $g) {
//     $ins->bind_param(
//         'issss',
//         $g['id'],
//         $g['name'],
//         $g['open_str'],
//         $g['close_str'],
//         $today
//     );
//     $ins->execute();
// }
// $ins->close();

// // 5) Prepare our “only if NULL” update statements
// $upOpen = $conn->prepare("
//     UPDATE sd_rewards
//       SET winning_open_time_sd = ?, created_at = NOW()
//      WHERE reward_date = ?
//       AND game_id = ?
//       AND winning_open_time_sd IS NULL
// ");

// $upClose = $conn->prepare("
//     UPDATE sd_rewards
//       SET winning_close_time_sd = ?, created_at = NOW()
//      WHERE reward_date = ?
//       AND game_id = ?
//       AND winning_close_time_sd IS NULL
// ");

// // 6) Generate both digits for every game right now
// foreach ($games as $g) {
//     // — Open digit
//     $digit = random_int(0, 9);
//     $upOpen->bind_param('sis', $digit, $today, $g['id']);
//     $upOpen->execute();
//     error_log("{$today} Open SD for Game {$g['id']}: {$digit}");

//     // — Close digit
//     $digit = random_int(0, 9);
//     $upClose->bind_param('sis', $digit, $today, $g['id']);
//     $upClose->execute();
//     error_log("{$today} Close SD for Game {$g['id']}: {$digit}");
// }

// $upOpen->close();
// $upClose->close();
// $conn->close();

// // 7) Exit cleanly
// exit(0);
