<?php
// generate_sp_rewards.php
declare(strict_types=1);

// 0) Setup
date_default_timezone_set('Asia/Kolkata');
error_reporting(E_ALL);
ini_set('display_errors','1');
require __DIR__ . '/db.php';  // creates $conn = new mysqli(...)

$today    = date('Y-m-d');
$nowTs    = time();

// 1) Your single-panna combos
$sp_nums = [
  '1'=> ['128','137','146','236','245','290','380','470','489','560','579','678'],
  '2'=> ['129','138','147','156','237','246','345','390','480','570','589','679'],
  '3'=> ['120','139','148','157','238','247','256','346','490','580','670','689'],
  '4'=> ['130','149','158','167','239','248','257','347','356','590','680','789'],
  '5'=> ['140','159','168','230','249','258','267','348','357','456','690','780'],
  '6'=> ['123','150','169','178','240','259','268','349','358','367','457','790'],
  '7'=> ['124','160','278','179','250','269','340','359','368','458','467','890'],
  '8'=> ['125','134','170','189','260','279','350','369','468','378','459','567'],
  '9'=> ['126','135','180','234','270','289','360','379','450','469','478','568'],
  '0'=> ['127','136','145','190','235','280','370','389','460','479','569','578'],
];

// 2) Fetch today’s games
$stmt = $conn->prepare(
  "SELECT id, game_name, open_time, close_time
     FROM game56
    WHERE DATE(open_time)=?"
);
$stmt->bind_param('s',$today);
$stmt->execute();
$stmt->bind_result($gid,$gname,$gopen,$gclose);

$games = [];
while($stmt->fetch()){
  $games[] = [
    'id'        => $gid,
    'name'      => $gname,
    'open_ts'   => strtotime("$today $gopen"),
    'close_ts'  => strtotime("$today $gclose"),
    'open_str'  => $gopen,
    'close_str' => $gclose,
  ];
}
$stmt->close();

// 3) Seed one row per game
$ins = $conn->prepare(
  "INSERT IGNORE INTO sp_rewards
     (game_id,game_name,open_time,close_time,reward_date)
   VALUES(?,?,?,?,?)"
);
foreach($games as $g){
  $ins->bind_param(
    'issss',
    $g['id'],
    $g['name'],
    $g['open_str'],
    $g['close_str'],
    $today
  );
  $ins->execute();
}
$ins->close();

// 4) Prepare open/close updates
$upO = $conn->prepare(
  "UPDATE sp_rewards
      SET winning_open_time_sp = ?
    WHERE reward_date=? 
      AND game_id=? 
      AND winning_open_time_sp IS NULL
      AND CONCAT(reward_date,' ',open_time) <= NOW()"
);
$upC = $conn->prepare(
  "UPDATE sp_rewards
      SET winning_close_time_sp = ?
    WHERE reward_date=? 
      AND game_id=? 
      AND winning_close_time_sp IS NULL
      AND CONCAT(reward_date,' ',close_time) <= NOW()"
);

// 5) Roll random winners at the right times
foreach($games as $g){
  // OPEN
  if($nowTs >= $g['open_ts']){
    $key   = array_rand($sp_nums);
    $digit = $sp_nums[$key][array_rand($sp_nums[$key])];
    $upO->bind_param('sis',$digit,$today,$g['id']);
    $upO->execute();
  }
  // CLOSE
  if($nowTs >= $g['close_ts']){
    $key    = array_rand($sp_nums);
    $digit2 = $sp_nums[$key][array_rand($sp_nums[$key])];
    $upC->bind_param('sis',$digit2,$today,$g['id']);
    $upC->execute();
  }
}

$upO->close();
$upC->close();
$conn->close();
