<?php
// generate_tp_rewards.php
declare(strict_types=1);
date_default_timezone_set('Asia/Kolkata');
error_reporting(E_ALL);
ini_set('display_errors','1');

require __DIR__ . '/db.php';  // gives you $conn = new mysqli(...)
$today = date('Y-m-d');
$nowTs = time();

// 000,111,...,999
$tp_nums = ['000','111','222','333','444','555','666','777','888','999'];

// 1) Grab today's games
$stmt = $conn->prepare(
  "SELECT id, game_name, open_time, close_time
     FROM game56
    WHERE DATE(open_time)=?"
);
$stmt->bind_param('s', $today);
$stmt->execute();
$stmt->bind_result($gid,$gname,$gopen,$gclose);

$games = [];
while($stmt->fetch()){
  $games[] = [
    'id'        => $gid,
    'name'      => $gname,
    'open_ts'   => strtotime("$today $gopen"),
    'close_ts'  => strtotime("$today $gclose"),
    'open_str'  => $gopen,
    'close_str' => $gclose,
  ];
}
$stmt->close();

// 2) Seed one row per game
$ins = $conn->prepare(
  "INSERT IGNORE INTO tp_rewards
     (game_id,game_name,open_time,close_time,reward_date)
   VALUES(?,?,?,?,?)"
);
foreach($games as $g){
  $ins->bind_param(
    'issss',
    $g['id'],
    $g['name'],
    $g['open_str'],
    $g['close_str'],
    $today
  );
  $ins->execute();
}
$ins->close();

// 3) Prepare open/close updates
$upO = $conn->prepare(
  "UPDATE tp_rewards
      SET winning_open_time_tp = ?
    WHERE reward_date=? 
      AND game_id=? 
      AND winning_open_time_tp IS NULL
      AND CONCAT(reward_date,' ',open_time) <= NOW()"
);
$upC = $conn->prepare(
  "UPDATE tp_rewards
      SET winning_close_time_tp = ?
    WHERE reward_date=? 
      AND game_id=? 
      AND winning_close_time_tp IS NULL
      AND CONCAT(reward_date,' ',close_time) <= NOW()"
);

// 4) Roll at the right times
foreach($games as $g){
  // OPEN
  if($nowTs >= $g['open_ts']){
    $digit = $tp_nums[array_rand($tp_nums)];
    $upO->bind_param('sis', $digit, $today, $g['id']);
    $upO->execute();
  }
  // CLOSE
  if($nowTs >= $g['close_ts']){
    $digit = $tp_nums[array_rand($tp_nums)];
    $upC->bind_param('sis', $digit, $today, $g['id']);
    $upC->execute();
  }
}

$upO->close();
$upC->close();
$conn->close();
