<?php
// get_balance_api.php

// 1) show errors while debugging
ini_set('display_errors',1);
ini_set('display_startup_errors',1);
error_reporting(E_ALL);

// 2) CORS + JSON
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=UTF-8");

// 3) your DB connection (defines $conn = new mysqli(…))
require_once __DIR__ . '/db.php';

// 4) must be GET + mobile param
if ($_SERVER['REQUEST_METHOD']!=='GET' || !isset($_GET['mobile'])) {
  http_response_code(400);
  exit(json_encode([
    'success'=>false,
    'message'=>'Please provide ?mobile=...'
  ]));
}
$mobile = trim($_GET['mobile']);
if (!preg_match('/^\d{10,15}$/',$mobile)) {
  http_response_code(400);
  exit(json_encode([
    'success'=>false,
    'message'=>'Invalid mobile format.'
  ]));
}

// 5) pull directly from wallet table
$sql = "
  SELECT 
    u.user_id,
    u.mobile,
    COALESCE(w.balance,0) AS balance
  FROM users_data AS u
  LEFT JOIN wallet     AS w ON w.user_id = u.user_id
  WHERE u.mobile = ?
  LIMIT 1
";
$stmt = $conn->prepare($sql);
$stmt->bind_param('s',$mobile);
$stmt->execute();
$stmt->store_result();

if ($stmt->num_rows===1) {
  $stmt->bind_result($uid,$umobile,$bal);
  $stmt->fetch();
  echo json_encode([
    'success'=>true,
    'data'=>[
      'user_id'=>(int)$uid,
      'mobile'=>(string)$umobile,
      'balance'=>(float)$bal
    ]
  ]);
} else {
  http_response_code(404);
  echo json_encode([
    'success'=>false,
    'message'=>'No wallet found for that mobile.'
  ]);
}
$stmt->close();
$conn->close();
