<?php
// get_bank_details_api.php
header('Content-Type: application/json; charset=utf-8');
ini_set('display_errors', 1);
error_reporting(E_ALL);

require __DIR__ . '/db.php';  // provides $conn

// 1) parse input
$raw = file_get_contents('php://input');
$in  = json_decode($raw, true);
$mobile = trim($in['mobile'] ?? '');

if (!preg_match('/^\d{10}$/', $mobile)) {
    echo json_encode(['status' => false, 'message' => 'Invalid mobile']);
    exit;
}

// 2) lookup user_id
$stmt = $conn->prepare("SELECT user_id FROM users_data WHERE mobile = ? LIMIT 1");
$stmt->bind_param('s', $mobile);
$stmt->execute();
$stmt->bind_result($uid);
if (!$stmt->fetch()) {
    $stmt->close();
    echo json_encode(['status' => false, 'message' => 'User not found']);
    exit;
}
$stmt->close();

// 3) fetch bank details
$stmt = $conn->prepare("
    SELECT holder_name, bank_name, account_no, ifsc
      FROM user_bank_details
     WHERE user_id = ?
     LIMIT 1
");
$stmt->bind_param('i', $uid);
$stmt->execute();
$stmt->bind_result($holder, $bank, $acct, $ifsc);

if ($stmt->fetch()) {
    echo json_encode([
        'status' => true,
        'data'   => [
            'holder_name' => $holder,
            'bank_name'   => $bank,
            'account_no'  => $acct,
            'ifsc'        => $ifsc,
        ]
    ]);
} else {
    // no details saved yet
    echo json_encode([
        'status'  => false,
        'message' => 'No saved bank details'
    ]);
}

$stmt->close();
$conn->close();
