<?php
// get_latest_sd_results.php
header('Content-Type: application/json; charset=utf-8');

// Get the filter date from the request
$filter_date = isset($_GET['filter_date']) ? $_GET['filter_date'] : date('Y-m-d');

// Database connection
require_once __DIR__ . '/db.php';

// Fetch results for the given filter date
$stmt = $conn->prepare("SELECT game_id, winning_open_time_sd, winning_close_time_sd FROM sd_rewards WHERE reward_date = ?");
$stmt->bind_param('s', $filter_date);
$stmt->execute();
$stmt->bind_result($game_id, $open_digit, $close_digit);

$results = [];
while ($stmt->fetch()) {
    $results[] = [
    'game_id'     => $gid,
    'open_digit'  => $row['winning_open_time_sd'],
    'close_digit' => $row['winning_close_time_sd'],
    'res_open'    => $row['res_open'],   // make sure you SELECT these!
    'res_close'   => $row['res_close'],
  ];

}

echo json_encode($results);
?>
