<?php
// get_profile_api.php
header('Content-Type: application/json; charset=utf-8');
ini_set('display_errors',1);
ini_set('log_errors',1);
error_reporting(E_ALL);

try {
  require __DIR__.'/db.php';       // gives $conn = new mysqli(...)
  $in = json_decode(file_get_contents('php://input'), true);
  if (empty($in['mobile']) || !preg_match('/^\d{10}$/',$in['mobile'])) {
    throw new Exception('Invalid mobile');
  }
  $mobile = $in['mobile'];

  $stmt = $conn->prepare("
    SELECT username, mobile
      FROM users_data
     WHERE mobile = ?
     LIMIT 1
  ");
  $stmt->bind_param('s',$mobile);
  $stmt->execute();
  $stmt->bind_result($username, $mobileOut);
  if (!$stmt->fetch()) {
    throw new Exception('User not found');
  }
  $stmt->close();

  echo json_encode([
    'status' => 'success',
    'data' => [
      'username' => $username,
      'mobile'   => $mobileOut
    ]
  ], JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT);

} catch(Exception $e) {
  http_response_code(400);
  echo json_encode([
    'status'  => 'error',
    'message' => $e->getMessage()
  ], JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT);
}
