<?php
// /Sai/api/imb/return.php
$orderId = $_GET['order_id'] ?? $_GET['orderId'] ?? '';
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8" />
  <title>Finalizing your payment…</title>
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <style>
    :root { color-scheme: light dark; }
    body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,sans-serif;background:#f6f7fb;color:#0f172a;margin:0}
    .box{max-width:560px;margin:12vh auto;padding:24px;border-radius:12px;background:#fff;box-shadow:0 10px 25px rgba(0,0,0,.06)}
    h1{margin:0 0 8px;font-size:1.25rem}
    .muted{color:#475569}
    .pill{display:inline-block;padding:.25rem .6rem;border-radius:999px;font-weight:600}
    .ok{background:#dcfce7;color:#14532d}
    .bad{background:#fee2e2;color:#7f1d1d}
    .pending{background:#e0e7ff;color:#1e1b4b}
    .btn{display:inline-block;margin-top:16px;background:#ef4444;color:#fff;text-decoration:none;padding:.6rem 1rem;border-radius:8px}
    code{background:#f1f5f9;padding:.15rem .35rem;border-radius:6px}
  </style>
</head>
<body>
  <div class="box">
    <h1>Finalizing your payment…</h1>
    <?php if ($orderId): ?>
      <p class="muted">Order ID: <code><?=htmlspecialchars($orderId)?></code></p>
    <?php endif; ?>
    <p class="muted" id="msg"><span class="pill pending">Checking</span> Waiting for confirmation from bank/UPI…</p>
    <a class="btn" id="openapp" href="#">Back to App</a>
  </div>

<script>
(function(){
  const oid = <?= json_encode($orderId) ?>;
  const statusEl = document.getElementById('msg');
  const scheme = 'saiapp://payment-return'; // your app scheme
  const backHref = (st) => scheme + (oid ? ('?order_id='+encodeURIComponent(oid)+'&status='+encodeURIComponent(st)) : '');
  document.getElementById('openapp').href = backHref('pending');

  if (!oid) { statusEl.innerHTML = '<span class="pill bad">Error</span> order_id missing.'; return; }

  const url = '/Sai/api/imb/order_status.php?order_id='+encodeURIComponent(oid)+'&t='+(Date.now()); // bust cache

  let tries = 0, maxTries = 45;        // ~90s total
  const wait  = 2000;                  // 2s interval
  const firstDelay = 2500;             // let IMB settle for 2.5s before first check

  const step = async () => {
    try {
      const r = await fetch(url, {cache:'no-store'});
      const j = await r.json();
      if (j && j.ok) {
        if (j.status === 'SUCCESS') {
          statusEl.innerHTML = '<span class="pill ok">Success</span> Payment successful! Redirecting to the app…';
          const href = backHref('success');
          document.getElementById('openapp').href = href;
          setTimeout(()=>{ window.location.href = href; }, 700);
          return;
        }
        if (j.status === 'FAILED') {
          statusEl.innerHTML = '<span class="pill bad">Failed</span> Payment failed. You can return to the app.';
          document.getElementById('openapp').href = backHref('failed');
          return;
        }
      }
    } catch(e) { /* keep polling */ }

    tries++;
    if (tries < maxTries) {
      statusEl.innerHTML = '<span class="pill pending">Pending</span> Still waiting for confirmation…';
      setTimeout(step, wait);
    } else {
      statusEl.innerHTML = '<span class="pill pending">Pending</span> Taking longer than usual. You can return to the app; balance will update once confirmed.';
      document.getElementById('openapp').href = backHref('pending');
    }
  };

  setTimeout(step, firstDelay);
})();
</script>

</body>
</html>
