<?php
session_start();
require_once __DIR__.'/db.php'; // $conn = new mysqli(...)
$conn->set_charset('utf8mb4');

// 1) Auth guard
if (empty($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

// 2) Delete a game + its HS bids
if (isset($_GET['delete_game_id'])) {
    $gid = (int)$_GET['delete_game_id'];
    $conn->query("DELETE FROM user_bids_hs WHERE game_id = {$gid}");
    $conn->query("DELETE FROM game56       WHERE id      = {$gid}");
    header('Location: invested_hs.php');
    exit;
}

// 3) Date filters
$date_from = (isset($_GET['date_from']) && preg_match('/^\d{4}-\d{2}-\d{2}$/', $_GET['date_from']))
           ? $_GET['date_from'] : '';
$date_to   = (isset($_GET['date_to'])   && preg_match('/^\d{4}-\d{2}-\d{2}$/', $_GET['date_to']))
           ? $_GET['date_to']   : '';

// 4) Build WHERE on created_at
$where = [];
if ($date_from) $where[] = "ub.created_at >= '{$date_from} 00:00:00'";
if ($date_to)   $where[] = "ub.created_at <= '{$date_to} 23:59:59'";
$where_sql = $where ? 'AND '.implode(' AND ',$where) : '';

// 5) Prepare & execute
$sql = "
  SELECT
    g.id               AS game_id,
    g.game_name,
    DATE_FORMAT(g.open_time,  '%l:%i %p') AS open_time,
    DATE_FORMAT(g.close_time, '%l:%i %p') AS close_time,
    u.username,
    CONCAT(ub.bid_open_hs,' | ',ub.bid_close_hs) AS bid_details,
    ub.total_bid_amount,
    ub.bid_session,
    ub.created_at     AS played_at
  FROM game56        AS g
  JOIN user_bids_hs AS ub ON ub.game_id = g.id
  JOIN users_data   AS u  ON u.user_id  = ub.user_id
  WHERE ub.user_id = ?
    {$where_sql}
  ORDER BY ub.created_at DESC
";
$stmt = $conn->prepare($sql);
$stmt->bind_param('i', $_SESSION['user_id']);
$stmt->execute();
$stmt->store_result();

// 6) Bind columns
$stmt->bind_result(
  $game_id,
  $game_name,
  $open_time,
  $close_time,
  $username,
  $bid_details,
  $total_bid_amount,
  $bid_session,
  $played_at
);

// 7) Fetch into array
$rows = [];
while ($stmt->fetch()) {
    $rows[] = [
      'game_id'          => $game_id,
      'game_name'        => $game_name,
      'open_time'        => $open_time,
      'close_time'       => $close_time,
      'username'         => $username,
      'bid_details'      => $bid_details,
      'total_bid_amount' => $total_bid_amount,
      'bid_session'      => $bid_session,
      'played_at'        => $played_at
    ];
}
$stmt->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Invested Games &amp; Half Sangam Bids</title>
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <style>
    body { font-family:Arial,sans-serif; background:#f0f2f5; margin:0 }
    .navbar { background:#007bff; color:#fff; padding:15px; position:relative; text-align:center }
    .back   { position:absolute; top:15px; left:15px; background:#28a745; color:#fff;
               padding:8px 12px; text-decoration:none; border-radius:4px }
    .back:hover { background:#218838 }
    .container { max-width:900px; margin:20px auto; background:#fff; padding:20px;
                 border-radius:8px; box-shadow:0 2px 5px rgba(0,0,0,0.1) }
    .filter { display:flex; gap:10px; flex-wrap:wrap; align-items:flex-end; margin-bottom:20px }
    .filter label { display:flex; flex-direction:column; font-size:.9rem }
    .filter input, .filter select { padding:6px; font-size:1rem;
                                     border:1px solid #ccc; border-radius:4px }
    .filter button { padding:8px 16px; background:#007bff; color:#fff;
                     border:none; border-radius:4px; cursor:pointer }
    .filter button:hover { background:#0056b3 }
    table { width:100%; border-collapse:collapse }
    th,td { padding:10px; border:1px solid #ddd; text-align:left }
    th { background:#007bff; color:#fff }
    .del { color:#c00; text-decoration:none }
    .del:hover { text-decoration:underline }
  </style>
</head>
<body>

  <div class="navbar">
    <a href="dashboard.php" class="back">← Back</a>
    <h2>Invested Games &amp; Half Sangam Bids</h2>
  </div>

  <div class="container">
    <form class="filter" method="GET" action="invested_hs.php">
      <label>
        Date From:
        <input type="date" name="date_from" value="<?=htmlspecialchars($date_from)?>">
      </label>
      <label>
        Date To:
        <input type="date" name="date_to"   value="<?=htmlspecialchars($date_to)?>">
      </label>
      <label>
        View:
        <select onchange="window.location.href=this.value + window.location.search;">
          <option value="invested.php"    <?=basename($_SERVER['PHP_SELF'])==='invested.php'   ? 'selected':''?>>Single Digit</option>
          <option value="invested_dp.php" <?=basename($_SERVER['PHP_SELF'])==='invested_dp.php'? 'selected':''?>>Double Panna</option>
          <option value="invested_tp.php" <?=basename($_SERVER['PHP_SELF'])==='invested_tp.php'? 'selected':''?>>Triple Panna</option>
          <option value="invested_jd.php" <?=basename($_SERVER['PHP_SELF'])==='invested_jd.php'? 'selected':''?>>Jodi Digit</option>
          <option value="invested_sp.php" <?=basename($_SERVER['PHP_SELF'])==='invested_sp.php'? 'selected':''?>>Single Panna</option>
          <option value="invested_hs.php" <?=basename($_SERVER['PHP_SELF'])==='invested_hs.php'? 'selected':''?>>Half Sangam</option>
        </select>
      </label>
      <button type="submit">Filter</button>
    </form>

    <table>
      <thead>
        <tr>
          <th>Game Name</th>
          <th>Open Time</th>
          <th>Close Time</th>
          <th>Username</th>
          <th>Bid (Open | Close)</th>
          <th>Amount</th>
          <th>Session</th>
          <th>Played At</th>
          <th>Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php if (count($rows)): ?>
          <?php foreach($rows as $r): ?>
            <tr>
              <td><?=htmlspecialchars($r['game_name'])?></td>
              <td><?=htmlspecialchars($r['open_time'])?></td>
              <td><?=htmlspecialchars($r['close_time'])?></td>
              <td><?=htmlspecialchars($r['username'])?></td>
              <td><?=htmlspecialchars($r['bid_details'])?></td>
              <td>₹<?=number_format($r['total_bid_amount'],2)?></td>
              <td><?=htmlspecialchars(ucfirst($r['bid_session']))?></td>
              <td><?=date('d/m/Y g:i A',strtotime($r['played_at']))?></td>
              <td>
                <a href="invested_hs.php?delete_game_id=<?=$r['game_id']?>"
                   class="del"
                   onclick="return confirm('Delete this game and its HS bids?')">
                  Delete
                </a>
              </td>
            </tr>
          <?php endforeach; ?>
        <?php else: ?>
          <tr><td colspan="9" style="text-align:center;">No records found.</td></tr>
        <?php endif;?>
      </tbody>
    </table>
  </div>

</body>
</html>
<?php mysqli_close($conn); ?>
