<?php
// 1) (Optional) error reporting — remove in production
// ini_set('display_errors',1);
// ini_set('display_startup_errors',1);
// error_reporting(E_ALL);

session_start();
include('db.php'); // your mysqli connection in $conn

// 2) Deletion: remove JD bids and the game
if (isset($_GET['delete_game_id'])) {
    $gid = (int)$_GET['delete_game_id'];
    $conn->query("DELETE FROM user_bids_jd WHERE game_id = {$gid}");
    $conn->query("DELETE FROM game56       WHERE id      = {$gid}");
    header("Location: invested_jd.php");
    exit;
}

// 3) Read + sanitize date filters
$date_from = (isset($_GET['date_from']) && preg_match('/^\d{4}-\d{2}-\d{2}$/', $_GET['date_from']))
           ? $_GET['date_from'] : '';
$date_to   = (isset($_GET['date_to'])   && preg_match('/^\d{4}-\d{2}-\d{2}$/', $_GET['date_to']))
           ? $_GET['date_to']   : '';

// 4) Build WHERE clause
$where = [];
if ($date_from) $where[] = "ub.created_at >= '{$date_from} 00:00:00'";
if ($date_to)   $where[] = "ub.created_at <= '{$date_to} 23:59:59'";
$where_sql = $where ? 'WHERE '.implode(' AND ', $where) : '';

// 5) Main query against user_bids_jd
$sql = "
  SELECT
    g.id               AS game_id,
    g.game_name,
    g.open_time,
    g.close_time,
    u.username,
    ub.bid_details,
    ub.total_bid_amount,
    ub.bid_session,
    ub.created_at      AS bid_date,
    TIME(ub.created_at) AS bid_time
  FROM game56 g
  LEFT JOIN user_bids_jd ub ON ub.game_id = g.id
  LEFT JOIN users_data   u  ON u.user_id  = ub.user_id
  {$where_sql}
  ORDER BY ub.created_at DESC
";
$result = $conn->query($sql);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Invested Games &amp; Jodi Digit Bids</title>
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <style>
    body { font-family:Arial,sans-serif; background:#f0f2f5; margin:0; }
    .navbar { background:#007bff; color:#fff; padding:15px; position:relative; text-align:center; }
    .back   { position:absolute; top:15px; left:15px; background:#28a745; color:#fff;
               padding:8px 12px; text-decoration:none; border-radius:4px; }
    .back:hover { background:#218838; }
    .container { max-width:900px; margin:20px auto; background:#fff; padding:20px;
                 border-radius:8px; box-shadow:0 2px 5px rgba(0,0,0,0.1); }
    .filter { display:flex; gap:10px; flex-wrap:wrap; align-items:flex-end; margin-bottom:20px; }
    .filter label { display:flex; flex-direction:column; font-size:.9rem; }
    .filter input, .filter select { padding:6px; font-size:1rem; border:1px solid #ccc; border-radius:4px; }
    .filter button { padding:8px 16px; font-size:1rem; background:#007bff; color:#fff;
                     border:none; border-radius:4px; cursor:pointer; }
    .filter button:hover { background:#0056b3; }
    table { width:100%; border-collapse:collapse; }
    th, td { padding:10px; border:1px solid #ddd; text-align:left; }
    th { background:#007bff; color:#fff; }
    .del { color:#c00; text-decoration:none; }
    .del:hover { text-decoration:underline; }
  </style>
</head>
<body>

  <div class="navbar">
    <a href="dashboard.php" class="back">← Back</a>
    <h2>Invested Games &amp; Jodi Digit Bids</h2>
  </div>

  <div class="container">
    <!-- Date Filter + View Switcher -->
    <form class="filter" method="GET" action="invested_jd.php">
      <label>
        Date From:
        <input type="date" name="date_from" value="<?=htmlspecialchars($date_from)?>">
      </label>
      <label>
        Date To:
        <input type="date" name="date_to"   value="<?=htmlspecialchars($date_to)?>">
      </label>
      <label>
        View:
        <select onchange="window.location.href=this.value + window.location.search;">
          <option value="invested.php"    <?=basename($_SERVER['PHP_SELF'])==='invested.php'    ? 'selected':''?>>Single Digit</option>
          <option value="invested_dp.php"  <?=basename($_SERVER['PHP_SELF'])==='invested_dp.php'  ? 'selected':''?>>Double Panna</option>
          <option value="invested_tp.php"  <?=basename($_SERVER['PHP_SELF'])==='invested_tp.php'  ? 'selected':''?>>Triple Panna</option>
          <option value="invested_jd.php"  <?=basename($_SERVER['PHP_SELF'])==='invested_jd.php'  ? 'selected':''?>>Jodi Digit</option>
          <option value="invested_sp.php"  <?=basename($_SERVER['PHP_SELF'])==='invested_sp.php'  ? 'selected':''?>>Single Panna</option>
        </select>
      </label>
      <button type="submit">Filter</button>
    </form>

    <!-- Results Table -->
    <table>
      <thead>
        <tr>
          <th>Game Name</th>
          <th>Open Time</th>
          <th>Close Time</th>
          <th>Username</th>
          <th>Bid Details</th>
          <th>Bid Amount</th>
          <th>Session</th>
          <th>Played At</th>
          <th>Bid Date</th>
          <th>Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php if ($result && $result->num_rows): ?>
          <?php while ($r = $result->fetch_assoc()): ?>
            <tr>
              <td><?=htmlspecialchars($r['game_name'])?></td>
              <td><?=htmlspecialchars($r['open_time'])?></td>
              <td><?=htmlspecialchars($r['close_time'])?></td>
              <td><?=htmlspecialchars($r['username'] ?: '—')?></td>
              <td><?=htmlspecialchars($r['bid_details'] ?: 'No bids')?></td>
              <td><?=number_format($r['total_bid_amount'],2)?></td>
              <td><?=htmlspecialchars($r['bid_session'])?></td>
              <td><?=htmlspecialchars($r['bid_time'])?></td>
              <td>
                <?= $r['bid_date']
                   ? date('d/m/Y', strtotime($r['bid_date']))
                   : '—' ?>
              </td>
              <td>
                <a href="invested_jd.php?delete_game_id=<?=$r['game_id']?>"
                   class="del"
                   onclick="return confirm('Delete this game and its Jodi Digit bids?')">
                  Delete
                </a>
              </td>
            </tr>
          <?php endwhile; ?>
        <?php else: ?>
          <tr><td colspan="10" style="text-align:center;">No records found.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>

</body>
</html>
<?php
$conn->close();
?>
