<?php
// Map like {"110":70,"112":50}  → ["110"=>70,"112"=>50]
function parse_dp_pairs($raw){
  $out=[]; if(!is_string($raw)||$raw==='') return $out;
  $s=trim($raw);

  $data=json_decode($s,true);
  if(is_array($data) && !isset($data[0])){
    foreach($data as $k=>$v){
      if (preg_match('/^\d{3}$/',(string)$k)) $out[(string)$k]=($out[(string)$k]??0)+(float)$v;
    }
  } elseif (preg_match_all('/"(\d{3})"\s*:\s*"?(\d+(?:\.\d+)?)"?/', $s, $m, PREG_SET_ORDER)) {
    foreach($m as $h){ $out[$h[1]] = ($out[$h[1]] ?? 0) + (float)$h[2]; }
  }
  ksort($out, SORT_NUMERIC); return $out;
}
