<?php
function sd_extract_pairs($raw, $stake = null): array {
  if (!is_string($raw) || $raw === '') return [];
  $s = trim(stripslashes($raw));
  $s = html_entity_decode($s, ENT_QUOTES | ENT_HTML5, 'UTF-8');
  $s = preg_replace('/\x{00A0}|\x{2007}|\x{202F}/u',' ',$s);
  $s = preg_replace('/,(\s*[}\]])/','$1',$s);
  $out = [];

  foreach ([$s, preg_replace('/([{\s,])\'([^\'"]+)\'\s*:/','$1"$2":',$s)] as $cand) {
    $j = json_decode($cand, true);
    if (is_array($j) && $j) {
      foreach ($j as $k=>$v) if (preg_match('/^\d$/',(string)$k))
        $out[(int)$k] = ($out[(int)$k]??0) + (float)$v;
      if ($out) { ksort($out); return $out; }
    }
  }

  if (preg_match_all('/[{,]\s*[\'"]?([0-9])[\'"]?\s*:\s*[\'"]?(\d+(?:\.\d+)?)[\'"]?\s*(?=,|})/u','{'.$s.'}',$m,PREG_SET_ORDER))
    foreach($m as $h){ $d=(int)$h[1]; $out[$d]=($out[$d]??0)+(float)$h[2]; }

  if (preg_match_all('/\b(19[4-9]|20[0-3])\b[^\d\[]*(?:\[\s*(\d+(?:\.\d+)?)\s*\])?/u',$s,$m2,PREG_SET_ORDER))
    foreach($m2 as $h){ $d=(int)$h[1]-194; $amt=($h[2]!==''?(float)$h[2]:(float)$stake); if($amt>0)$out[$d]=($out[$d]??0)+$amt; }

  if (!$out) {
    $j = json_decode($s, true);
    if (is_array($j) && array_keys($j)===range(0,count($j)-1)) {
      foreach ($j as $d) if (is_numeric($d)&&$d>=0&&$d<=9) $out[(int)$d]=(float)$stake;
    } elseif (preg_match('/^\s*\[\s*([0-9])\s*\]\s*$/',$s,$mm)) {
      $out[(int)$mm[1]]=(float)$stake;
    } else {
      foreach (preg_split('/\D+/',$s) as $tok)
        if ($tok!=='' && ctype_digit($tok)) { $d=(int)$tok; if($d>=0&&$d<=9)$out[$d]=(float)$stake; }
    }
  }
  if (!$out && preg_match('/^\s*(?:\[?\s*[\'"]?0[\'"]?\s*\]?)\s*$/u',$s)) $out=[0=>(float)$stake];
  ksort($out); return $out;
}
