<?php
// login.php

// 1) Enable error reporting (disable in production)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// 2) Start session and include DB connection
session_start();
require_once __DIR__ . '/db.php';  // must define $conn = new mysqli(...)

// 3) Handle post‑registration message
if (isset($_GET['registered']) && $_GET['registered'] == 1) {
    $success_message = "Registration successful! Please log in.";
}

// 4) Default credentials (used only to prefill the form)
$default_email    = 'admin@sai.com';
$default_password = 'Admin_6666';

// 5) Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email    = trim($_POST['email']);
    $password = $_POST['password'];

    // Fetch user by email
    $stmt = $conn->prepare("
      SELECT user_id, email, password
        FROM users_data
       WHERE email = ?
    ");
    $stmt->bind_param('s', $email);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows === 1) {
        $stmt->bind_result($user_id, $user_email, $hash);
        $stmt->fetch();

        if ($password === $hash) {
            // Login OK
            $_SESSION['user_id'] = $user_id;
            $_SESSION['email']   = $user_email;
            header("Location: dashboard.php");
            exit;
        }
    }

    $error_message = "Invalid email or password!";
    $stmt->close();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Login</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      background: linear-gradient(to right, #56ccf2, #2f80ed);
      display: flex; justify-content: center; align-items: center;
      height: 100vh; margin: 0;
    }
    .login-container {
      background: #fff; padding: 40px; border-radius: 10px;
      box-shadow: 0 4px 20px rgba(0,0,0,0.1);
      width: 100%; max-width: 400px; text-align: center;
    }
    h2 { color: #333; margin-bottom: 20px; font-size: 24px; }
    .input-group { margin-bottom: 20px; text-align: left; position: relative; }
    label { font-size: 14px; color: #555; }
    input {
      width: 100%; padding: 15px; margin-top: 8px;
      border: 1px solid #ddd; border-radius: 5px; font-size: 16px;
      outline: none;
    }
    input:focus { border-color: #2f80ed; }
    .error-message { color: #ff4747; margin-bottom: 20px; font-size: 14px; }
    .success-message { color: #28a745; margin-bottom: 20px; font-size: 14px; }
    button {
      width: 100%; padding: 15px; background: #2f80ed; color: #fff;
      font-size: 16px; border: none; border-radius: 5px; cursor: pointer;
      transition: background-color 0.3s ease;
    }
    button:hover { background: #56ccf2; }
    .toggle-pwd {
      position: absolute; right: 15px; top: 50%;
      transform: translateY(-50%); cursor: pointer; font-size: 18px; color: #555;
    }
    .link {
      display: block; margin-top: 15px; color: #2f80ed;
      font-size: 14px; text-decoration: none;
    }
    .link:hover { text-decoration: underline; }
  </style>
</head>
<body>
  <div class="login-container">
    <h2>Login</h2>

    <?php if (!empty($success_message)): ?>
      <div class="success-message"><?= htmlspecialchars($success_message) ?></div>
    <?php endif; ?>

    <?php if (!empty($error_message)): ?>
      <div class="error-message"><?= htmlspecialchars($error_message) ?></div>
    <?php endif; ?>

    <form method="POST" action="login.php">
      <div class="input-group">
        <label for="email">Email</label>
        <input
          type="email" id="email" name="email" required
          placeholder="Enter your email"
          value="<?= htmlspecialchars($_POST['email'] ?? $default_email) ?>">
      </div>

      <div class="input-group">
        <label for="password">Password</label>
        <input
          type="password" id="password" name="password" required
          placeholder="Enter your password"
          value="<?= htmlspecialchars($_POST['password'] ?? $default_password) ?>">
        <span id="togglePwd" class="toggle-pwd">👁️</span>
      </div>

      <button type="submit">Login</button>
    </form>

    <a href="register.php" class="link">Don't have an account? Register here</a>
  </div>

  <script>
    const pwdField = document.getElementById('password');
    const toggle   = document.getElementById('togglePwd');
    toggle.addEventListener('click', () => {
      if (pwdField.type === 'password') {
        pwdField.type = 'text';
        toggle.textContent = '🙈';
      } else {
        pwdField.type = 'password';
        toggle.textContent = '👁️';
      }
    });
  </script>
</body>
</html>
