<?php
// api_login.php

// 1) Enable error reporting (disable in production)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// 2) Allow CORS (adjust origin as needed)
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=UTF-8");

// 3) Include your DB connection (must define $conn = new mysqli(...))
require_once __DIR__ . '/db.php';

// 4) Read and decode JSON input
$input = json_decode(file_get_contents('php://input'), true);
if (
    !isset($input['mobile']) || 
    !isset($input['mpin']) ||
    !preg_match('/^\d{10,15}$/', $input['mobile']) ||
    !preg_match('/^\d{4}$/', $input['mpin'])
) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => 'Please provide a valid mobile number and 4-digit MPIN.'
    ]);
    exit;
}

$mobile = $input['mobile'];
$mpin   = $input['mpin'];


// 5) Fetch user by mobile
if ($stmt = $conn->prepare("
    SELECT user_id, mobile, password 
      FROM users_data 
     WHERE mobile = ?
")) {
    $stmt->bind_param('s', $mobile);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows === 1) {
        $stmt->bind_result($user_id, $user_mobile, $hash);
        $stmt->fetch();

        // 6) Verify password
        if ($mpin === $hash) {
            // 7) Successful login: start session if desired, or issue a token
            // session_start();
            // $_SESSION['user_id'] = $user_id;

            echo json_encode([
                'success' => true,
                'message' => 'Login successful.',
                'data'    => [
                    'user_id' => $user_id,
                    'mobile'  => $user_mobile
                ]
            ]);
            exit;
        }
    }
    $stmt->close();
}

// 8) Invalid credentials
http_response_code(401);
echo json_encode([
    'success' => false,
    'message' => 'Invalid mobile number or password.'
]);
