<?php
session_start();

// Include the database connection
include('db.php');

// Check if the user is logged in, if not, redirect to the login page
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

// Initialize IMB Payment Gateway credentials
$api_key = 'a612b3ad1626aadf156ab82f8960ad4f'; // Your IMB API Key
$api_url = 'https://pay.imb.org.in/'; // IMB API URL

// Handle the payment process
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['make_payment'])) {
    $amount = (float)$_POST['amount'];
    $user_id = $_SESSION['user_id'];

    // Generate a unique transaction ID for the payment
    $txnid = uniqid('txn_', true);

    // Prepare data for the IMB payment form
    $product_info = "Wallet Payment"; // Example product description
    $customer_name = $_SESSION['user_name']; // User's name
    $customer_email = $_SESSION['email']; // User's email
    $customer_phone = $_SESSION['phone']; // User's phone number

    // Data to be sent to IMB Payment Gateway
    $payment_data = array(
        "api_key" => $api_key,
        "txnid" => $txnid,
        "amount" => $amount,
        "productinfo" => $product_info,
        "firstname" => $customer_name,
        "email" => $customer_email,
        "phone" => $customer_phone,
        "surl" => "https://yourdomain.com/payment.php?status=success", // Success URL
        "furl" => "https://yourdomain.com/payment.php?status=failure", // Failure URL
    );

    // Prepare payment data as hidden fields in the form
    $payment_url = $api_url . "transaction"; // Change this to the specific API URL endpoint for initiating payments
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Make Payment</title>
    <style>
        body { font-family: Arial, sans-serif; background-color: #f0f2f5; margin: 0; padding: 0; }
        .navbar { background-color: #007bff; padding: 10px; color: white; text-align: center; }
        .container { padding: 20px; max-width: 600px; margin: auto; background-color: #fff; border-radius: 8px; box-shadow: 0 0 10px rgba(0,0,0,0.1); position: relative; }
        .back-button { position: absolute; top: 15px; left: 15px; background-color: #007bff; color: white; padding: 10px; text-decoration: none; border-radius: 5px; }
        .back-button:hover { background-color: #0056b3; }
        .message { margin: 15px 0; padding: 10px; background-color: #e2e3e5; border-radius: 4px; }
        .form-group { margin: 10px 0; }
        .form-group input { padding: 8px; width: 100%; font-size: 14px; }
        .button { padding: 10px 15px; background-color: #28a745; color: white; border: none; border-radius: 5px; cursor: pointer; margin-left: 5px; }
        .button:hover { background-color: #218838; }
    </style>
</head>
<body>

<a href="wallet.php" class="back-button">Back</a>

<div class="navbar">
    <h2>Make Payment</h2>
</div>

<div class="container">
    <h3>Enter Payment Amount</h3>

    <?php if (!empty($message)): ?>
        <div class="message"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>

    <!-- Payment Amount Form -->
    <form method="POST">
        <div class="form-group">
            <input type="number" name="amount" placeholder="Enter amount to pay" required>
        </div>
        <button type="submit" name="make_payment" class="button">Make Payment</button>
    </form>

    <!-- IMB Payment Form (Appears only after submitting Make Payment) -->
    <?php if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['make_payment'])): ?>
        <form action="<?= $payment_url ?>" method="POST" name="imb_payment_form">
            <input type="hidden" name="api_key" value="<?= $api_key ?>">
            <input type="hidden" name="txnid" value="<?= $txnid ?>">
            <input type="hidden" name="amount" value="<?= $amount ?>">
            <input type="hidden" name="productinfo" value="<?= $product_info ?>">
            <input type="hidden" name="firstname" value="<?= $customer_name ?>">
            <input type="hidden" name="email" value="<?= $customer_email ?>">
            <input type="hidden" name="phone" value="<?= $customer_phone ?>">
            <input type="hidden" name="surl" value="https://yourdomain.com/payment.php?status=success">
            <input type="hidden" name="furl" value="https://yourdomain.com/payment.php?status=failure">
            <button type="submit" class="button">Pay Now</button>
        </form>
    <?php endif; ?>
</div>

<?php
// Handle the callback response after the payment
if (isset($_GET['status'])) {
    $status = $_GET['status'];
    $txn_id = $_GET['txnid'];

    if ($status == 'success') {
        // Payment was successful, update wallet balance
        // Example: update_wallet_balance($txn_id, $amount);
        echo "<div class='message'>Payment successful! Transaction ID: $txn_id</div>";
    } else {
        // Payment failed
        echo "<div class='message'>Payment failed for transaction ID: $txn_id</div>";
    }
}
?>

</body>
</html>
