<?php
session_start();

// Include the database connection file
include('db.php');

// Check if the user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// Get the game_id from the URL parameter
$game_id = isset($_GET['game_id']) ? (int)$_GET['game_id'] : null;

// Fetch game details based on game_id
if ($game_id) {
    $sql_game_data = "SELECT game_name, open_time, close_time FROM game56 WHERE id = ?";
    $stmt = $conn->prepare($sql_game_data);
    $stmt->bind_param("i", $game_id);
    $stmt->execute();
    $stmt->bind_result($game_name, $open_time, $close_time);
    if (!$stmt->fetch()) {
        echo "Game not found!";
        exit();
    }
    $stmt->close();
} else {
    echo "Game not specified!";
    exit();
}

// Convert open_time and close_time to 12‑hour format with IST
$formatted_open_time  = date("g:i A", strtotime($open_time))  . " IST";
$formatted_close_time = date("g:i A", strtotime($close_time)) . " IST";

// ─── Build today’s DateTime and decide status ─────────────────────────────────
date_default_timezone_set('Asia/Kolkata');
$now = new DateTime();

// Create DateTime objects for “raw” open/close (today’s date + the stored times)
$openDT  = DateTime::createFromFormat('H:i:s', $open_time);
$closeDT = DateTime::createFromFormat('H:i:s', $close_time);

// If close‐time is earlier or equal, assume it wraps past midnight:
if ($closeDT <= $openDT) {
    $closeDT->modify('+1 day');
}

// We want to treat “bidding open until result‐open” and “bidding close until result‐close”:
// so shift both by 10 minutes to define "running" window
$runStart = (clone $openDT)->modify('-10 minutes'); // bidding must finish 10m before open‐result
$runEnd   = (clone $closeDT)->modify('-10 minutes');

// Now decide gameStatus: “Open” until runStart, “Running” between runStart and runEnd, else “Closed”
if ($now < $runStart) {
    $gameStatus = 'Open';
} elseif ($now >= $runStart && $now <= $runEnd) {
    $gameStatus = 'Running';
} else {
    $gameStatus = 'Closed';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Play Game — <?php echo htmlspecialchars($game_name); ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f9;
            margin: 0;
            padding: 0;
            color: #333;
        }
        .container {
            max-width: 800px;
            margin: 50px auto;
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            position: relative;
        }
        .back-button {
            position: absolute;
            top: 20px;
            left: 20px;
            text-decoration: none;
            font-size: 14px;
            color: #1E90FF;
        }
        .back-button:hover {
            text-decoration: underline;
        }
        h1 {
            text-align: center;
            color: #1E90FF;
            margin-top: 0;
        }
        .game-details {
            margin-bottom: 30px;
        }
        .game-details p {
            margin: 5px 0;
        }
        .game-options h3 {
            color: #444;
            margin-bottom: 10px;
        }
        .game-options a {
            display: block;
            margin: 8px 0;
            padding: 10px 20px;
            background-color: #28a745;
            color: white;
            text-align: center;
            text-decoration: none;
            border-radius: 5px;
        }
        .game-options a:hover {
            background-color: #218838;
        }
    </style>
</head>
<body>

    <div class="container">
        <!-- Back Button -->
        <a href="games.php" class="back-button">← Back to Games</a>

        <h1>Play Game: <?php echo htmlspecialchars($game_name); ?></h1>
f
        <div class="game-details">
            <p><strong>Game Name:</strong> <?php echo htmlspecialchars($game_name); ?></p>
            <p><strong>Open Time:</strong> <?php echo $formatted_open_time; ?></p>
            <p><strong>Close Time:</strong> <?php echo $formatted_close_time; ?></p>
        </div>

        <div class="game-options">
            <h3>Choose your Option:</h3>

            <?php if ($game_name === 'Sai night'): ?>
                <a href="single_digit.php?game_id=<?php echo $game_id; ?>">Single Digit</a>
                <?php if ($gameStatus !== 'Open'): ?>   <a     href="#"     onclick="alert('Bid time is closed for the day.'); return false;"     style="background-color: #ccc; color: #666; cursor: not-allowed;"   >     Jodi Digit   </a> <?php else: ?>   <a href="jodi_digit.php?game_id=<?php echo $game_id; ?>">     Jodi Digit   </a> <?php endif; ?>
                <a href="https://sai7755.com/Sai/singlepanna.php?game_id=<?php echo $game_id; ?>">
                    Single Panna
                </a>
                <a href="https://sai7755.com/Sai/triplepanna.php?game_id=<?php echo $game_id; ?>">
                    Triple Panna
                </a>
                <a href="https://sai7755.com/Sai/halfsangam.php?game_id=<?php echo $game_id; ?>">
                    Half Sangam
                </a>
                <?php if ($gameStatus !== 'Open'): ?>   <a     href="#"     onclick="alert('Bid time is closed for the day.'); return false;"     style="background-color: #ccc; color: #666; cursor: not-allowed;"   >     Full Samgam   </a> <?php else: ?>   <a href="https://smartdigisolution.com/Sai/fullsangam.php?game_id=<?php echo $game_id; ?>">     Full Samgam   </a> <?php endif; ?>

            <?php elseif ($game_name === 'Sai midnight'): ?>
                <a href="single_digit.php?game_id=<?php echo $game_id; ?>">Single Digit</a>
                <a href="double_panna.php?game_id=<?php echo $game_id; ?>">Double Panna</a>
                <?php if ($gameStatus !== 'Open'): ?>   <a     href="#"     onclick="alert('Bid time is closed for the day.'); return false;"     style="background-color: #ccc; color: #666; cursor: not-allowed;"   >     Jodi Digit   </a> <?php else: ?>   <a href="jodi_digit.php?game_id=<?php echo $game_id; ?>">     Jodi Digit   </a> <?php endif; ?>
                <a href="https://sai7755.com/Sai/singlepanna.php?game_id=<?php echo $game_id; ?>">
                    Single Panna
                </a>
                <a href="https://sai7755.com/Sai/triplepanna.php?game_id=<?php echo $game_id; ?>">
                    Triple Panna
                </a>
                <a href="https://sai7755.com/Sai/halfsangam.php?game_id=<?php echo $game_id; ?>">
                    Half Sangam
                </a>
                <?php if ($gameStatus !== 'Open'): ?>   <a     href="#"     onclick="alert('Bid time is closed for the day.'); return false;"     style="background-color: #ccc; color: #666; cursor: not-allowed;"   >     Full Samgam   </a> <?php else: ?>   <a href="https://smartdigisolution.com/Sai/fullsangam.php?game_id=<?php echo $game_id; ?>">     Full Samgam   </a> <?php endif; ?>

            <?php else: ?>
                <a href="single_digit.php?game_id=<?php echo $game_id; ?>">Single Digit</a>
                <a href="double_panna.php?game_id=<?php echo $game_id; ?>">Double Panna</a>
                <?php if ($gameStatus !== 'Open'): ?>   <a     href="#"     onclick="alert('Bid time is closed for the day.'); return false;"     style="background-color: #ccc; color: #666; cursor: not-allowed;"   >     Jodi Digit   </a> <?php else: ?>   <a href="jodi_digit.php?game_id=<?php echo $game_id; ?>">     Jodi Digit   </a> <?php endif; ?>
                <a href="https://sai7755.com/Sai/singlepanna.php?game_id=<?php echo $game_id; ?>">
                    Single Panna
                </a>
                <a href="https://sai7755.com/Sai/triplepanna.php?game_id=<?php echo $game_id; ?>">
                    Triple Panna
                </a>
                <a href="https://sai7755.com/Sai/halfsangam.php?game_id=<?php echo $game_id; ?>">
                    Half Samgam
                </a>
                <?php if ($gameStatus !== 'Open'): ?>   <a     href="#"     onclick="alert('Bid time is closed for the day.'); return false;"     style="background-color: #ccc; color: #666; cursor: not-allowed;"   >     Full Samgam   </a> <?php else: ?>   <a href="https://sai7755.com/Sai/fullsangam.php?game_id=<?php echo $game_id; ?>">     Full Samgam   </a> <?php endif; ?>
            <?php endif; ?>

        </div>
    </div>

</body>
</html>
<?php
$conn->close();
?>
