<?php
session_start();
include('db.php');
date_default_timezone_set('Asia/Kolkata');

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

// ——— Load into form for editing ———
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['load_edit'])) {
    $edit_id = (int) $_POST['game_id'];
    $res = $conn->query("SELECT * FROM game56 WHERE id = $edit_id");
    $edit_row = $res->fetch_assoc();
}

// ——— Save edited game ———
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_game'])) {
    $game_id             = (int) $_POST['game_id'];
    $game_name           = $conn->real_escape_string($_POST['game_name']);
    $game_number         = $conn->real_escape_string($_POST['game_number']);
    $open_time           = $_POST['open_time'];
    $close_time          = $_POST['close_time'];
    $open_bid_last_time  = $_POST['open_bid_last_time'];
    $close_bid_last_time = $_POST['close_bid_last_time'];

    $sql = "
      UPDATE game56 SET
        game_name           = '$game_name',
        game_number         = '$game_number',
        open_time           = '$open_time',
        close_time          = '$close_time',
        open_bid_last_time  = '$open_bid_last_time',
        close_bid_last_time = '$close_bid_last_time'
      WHERE id = $game_id
    ";
    if ($conn->query($sql) === TRUE) {
        $success_message = "Game updated successfully!";
        unset($edit_row);
    } else {
        $error_message = "Error: " . $conn->error;
    }
}

// ——— Add new game ———
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_game'])) {
    $game_name           = $conn->real_escape_string($_POST['game_name']);
    $game_number         = $conn->real_escape_string($_POST['game_number']);
    $open_time           = $_POST['open_time'];
    $close_time          = $_POST['close_time'];
    $open_bid_last_time  = $_POST['open_bid_last_time'];
    $close_bid_last_time = $_POST['close_bid_last_time'];

    $sql = "
      INSERT INTO game56
        (game_name, game_number, open_time, close_time, open_bid_last_time, close_bid_last_time, status)
      VALUES
        ('$game_name', '$game_number', '$open_time', '$close_time', '$open_bid_last_time', '$close_bid_last_time', 'Closed')
    ";
    if ($conn->query($sql) === TRUE) {
        $success_message = "Game added successfully!";
    } else {
        $error_message = "Error: " . $conn->error;
    }
}

// ——— Update status ———
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_status'])) {
    $game_id    = (int) $_POST['game_id'];
    $new_status = $_POST['new_status'];
    $sql = "UPDATE game56 SET status = '$new_status' WHERE id = $game_id";
    if ($conn->query($sql) === TRUE) {
        $status_message = "Game status updated successfully!";
    } else {
        $status_error = "Error: " . $conn->error;
    }
}

// ——— Delete game ———
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_game'])) {
    $game_id = (int) $_POST['game_id'];
    $sql = "DELETE FROM game56 WHERE id = $game_id";
    if ($conn->query($sql) === TRUE) {
        $status_message = "Game deleted successfully!";
    } else {
        $status_error = "Error: " . $conn->error;
    }
}

// Fetch all games
$result = $conn->query("SELECT * FROM game56");
$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Manage Games</title>
  <style>
    body { font-family: Arial,sans-serif; background:#f0f2f5; margin:0; }
    .container { max-width:800px; margin:20px auto; background:#fff; padding:20px; border-radius:8px; box-shadow:0 0 10px rgba(0,0,0,0.1); }
    h2, h3 { text-align:center; color:#333; }
    .form-group { margin-bottom:15px; }
    label { display:block; font-size:14px; color:#555; }
    input { width:100%; padding:10px; margin-top:5px; border:1px solid #ccc; border-radius:5px; box-sizing:border-box; }
    .btn { padding:8px 12px; border:none; border-radius:5px; cursor:pointer; }
    .btn-add { width:100%; background:#007bff; color:#fff; font-size:16px; }
    .btn-add:hover { background:#0056b3; }
    .btn-toggle { background:#28a745; color:#fff; }
    .btn-delete { background:#dc3545; color:#fff; margin-left:8px; }
    .btn-edit { background:#ffc107; color:#000; margin-left:8px; }
    .message { text-align:center; color:#28a745; margin-bottom:20px; }
    .error-message { text-align:center; color:#dc3545; margin-bottom:20px; }
    .games-list { list-style:none; padding:0; margin-top:20px; }
    .games-list li { background:#f8f9fa; margin:10px 0; padding:15px; border-radius:5px; display:grid; grid-template-columns:1fr auto; grid-gap:10px; align-items:center; }
    .info { display:flex; flex-direction:column; gap:4px; }
    .actions { display:flex; align-items:center; }
  </style>
</head>
<body>
  <div class="container">
    <h2>Manage Games</h2>
    <div style="text-align:center; margin-bottom:20px;">
      <a href="dashboard.php"><button type="button" class="btn">Back to Dashboard</button></a>
    </div>

    <?php if (!empty($success_message)): ?>
      <div class="message"><?= $success_message ?></div>
    <?php endif; ?>
    <?php if (!empty($error_message)): ?>
      <div class="error-message"><?= $error_message ?></div>
    <?php endif; ?>
    <?php if (!empty($status_message)): ?>
      <div class="message"><?= $status_message ?></div>
    <?php endif; ?>
    <?php if (!empty($status_error)): ?>
      <div class="error-message"><?= $status_error ?></div>
    <?php endif; ?>

    <!-- Add/Edit Game Form -->
    <form method="POST" action="project.php">
      <input type="hidden" name="<?= isset($edit_row) ? 'update_game' : 'add_game' ?>" value="1">
      <?php if (isset($edit_row)): ?>
        <input type="hidden" name="game_id" value="<?= $edit_row['id'] ?>">
      <?php endif; ?>

      <div class="form-group">
        <label for="game_name">Game Name:</label>
        <input type="text" name="game_name" id="game_name" required
               value="<?= isset($edit_row) ? htmlspecialchars($edit_row['game_name']) : '' ?>"
               placeholder="Enter Game Name">
      </div>
      <div class="form-group">
        <label for="game_number">Game Number:</label>
        <input type="text" name="game_number" id="game_number" required
               value="<?= isset($edit_row) ? htmlspecialchars($edit_row['game_number']) : '' ?>"
               placeholder="Enter Game Number">
      </div>
      <div class="form-group">
        <label for="open_time">Open Time:</label>
        <input type="time" name="open_time" id="open_time" required
               value="<?= isset($edit_row) ? $edit_row['open_time'] : '' ?>">
      </div>
      <div class="form-group">
        <label for="close_time">Close Time:</label>
        <input type="time" name="close_time" id="close_time" required
               value="<?= isset($edit_row) ? $edit_row['close_time'] : '' ?>">
      </div>
      <div class="form-group">
        <label for="open_bid_last_time">Open Bid Last Time:</label>
        <input type="time" name="open_bid_last_time" id="open_bid_last_time" required
               value="<?= isset($edit_row) ? $edit_row['open_bid_last_time'] : '' ?>">
      </div>
      <div class="form-group">
        <label for="close_bid_last_time">Close Bid Last Time:</label>
        <input type="time" name="close_bid_last_time" id="close_bid_last_time" required
               value="<?= isset($edit_row) ? $edit_row['close_bid_last_time'] : '' ?>">
      </div>

      <button type="submit" class="btn btn-add">
        <?= isset($edit_row) ? 'Update Game' : 'Add Game' ?>
      </button>
      <?php if (isset($edit_row)): ?>
        <a href="project.php"><button type="button" class="btn" style="margin-top:10px;">Cancel</button></a>
      <?php endif; ?>
    </form>

    <h3>All Games</h3>
    <ul class="games-list">
      <?php while ($row = $result->fetch_assoc()): ?>
        <li>
          <div class="info">
            <strong><?= htmlspecialchars($row['game_name']) ?> (<?= htmlspecialchars($row['game_number']) ?>)</strong>
            <span>Status: <?= $row['status'] ?></span>
            <span>Open: <?= date("g:i A", strtotime($row['open_time'])) ?> IST</span>
            <span>Close: <?= date("g:i A", strtotime($row['close_time'])) ?> IST</span>
            <span>Open Bid Last: <?= date("g:i A", strtotime($row['open_bid_last_time'])) ?> IST</span>
            <span>Close Bid Last: <?= date("g:i A", strtotime($row['close_bid_last_time'])) ?> IST</span>
          </div>
          <div class="actions">
            <!-- Toggle Status -->
            <form method="POST" action="project.php" style="display:inline;">
              <input type="hidden" name="game_id" value="<?= $row['id'] ?>">
              <input type="hidden" name="new_status" value="<?= $row['status'] === 'Running' ? 'Closed' : 'Running' ?>">
              <button type="submit" name="update_status" class="btn btn-toggle">
                <?= $row['status'] === 'Running' ? 'Close' : 'Open' ?>
              </button>
            </form>
            <!-- Edit -->
            <form method="POST" action="project.php" style="display:inline;">
              <input type="hidden" name="game_id" value="<?= $row['id'] ?>">
              <button type="submit" name="load_edit" class="btn btn-edit">Edit</button>
            </form>
            <!-- Delete -->
            <form method="POST" action="project.php" style="display:inline;">
              <input type="hidden" name="game_id" value="<?= $row['id'] ?>">
              <button type="submit" name="delete_game" class="btn btn-delete" onclick="return confirm('Delete this game?')">
                Delete
              </button>
            </form>
          </div>
        </li>
      <?php endwhile; ?>
    </ul>
  </div>
</body>
</html>
