<?php
// Include database connection
include('db.php');  // This will provide the $conn variable for MySQLi connection

// This will process the form only if it's a POST request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get data from the form
    $username = $_POST['username']; 
    $email = $_POST['email'];
    $password = $_POST['password'];  // Using the password entered by the user

    // Check if any of the fields are empty
    if (empty($username) || empty($email) || empty($password)) {
        echo "<p class='error'>Please fill in all fields.</p>";
    } else {
        // Check if the email already exists
        $check_email_sql = "SELECT * FROM users_data WHERE email = ?";
        $check_stmt = $conn->prepare($check_email_sql);
        $check_stmt->bind_param("s", $email);
        $check_stmt->execute();
        $result = $check_stmt->get_result();

        // If the email already exists
        if ($result->num_rows > 0) {
            echo "<p class='error'>This email is already registered. Please use a different email.</p>";
        } else {
            // Insert user data into the database (now using the 'users_data' table)
            $sql = "INSERT INTO users_data (username, email, password) VALUES (?, ?, ?)";
            $stmt = $conn->prepare($sql);  // Using MySQLi prepare() method

            // Bind the parameters to the query
            $stmt->bind_param("sss", $username, $email, $password);  // 'sss' means 3 strings (username, email, password)

            // Execute the statement
            if ($stmt->execute()) {
                // Get the newly inserted user_id
                $user_id = $stmt->insert_id; // Get the last inserted user ID

                // Insert ₹10 into the user's wallet
                $wallet_balance = 10; // Initial balance to be added to the wallet
                $insert_wallet_sql = "INSERT INTO wallet (user_id, balance) VALUES (?, ?)";
                $wallet_stmt = $conn->prepare($insert_wallet_sql);
                $wallet_stmt->bind_param("id", $user_id, $wallet_balance);
                $wallet_stmt->execute();
                $wallet_stmt->close();

                // Redirect to 'games.php' page after successful registration
                header("Location: games.php?status=success");
                exit();  // Make sure no further code is executed after the redirect
            } else {
                echo "<p class='error'>Error registering user.</p>";
            }

            // Close the statement
            $stmt->close();
        }

        // Close the check email statement
        $check_stmt->close();
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registration Form</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f7fc;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 500px;
            margin: 50px auto;
            padding: 30px;
            background-color: white;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        h1 {
            text-align: center;
            color: #333;
        }
        label {
            font-size: 16px;
            color: #555;
        }
        input {
            width: 100%;
            padding: 12px;
            margin: 8px 0;
            border: 1px solid #ddd;
            border-radius: 4px;
            box-sizing: border-box;
        }
        button {
            background-color: #007BFF;
            color: white;
            padding: 12px 20px;
            border: none;
            border-radius: 4px;
            width: 100%;
            cursor: pointer;
        }
        button:hover {
            background-color: #0056b3;
        }
        .error {
            color: #dc3545;
            text-align: center;
        }
        .success {
            color: #28a745;
            text-align: center;
        }
    </style>
</head>
<body>

<div class="container">
    <h1>User Registration</h1>

    <form method="POST" action="registration_form.php">
        <label for="username">Username:</label> 
        <input type="text" name="username" id="username" required> 

        <label for="email">Email:</label>
        <input type="email" name="email" id="email" required>

        <label for="password">Password:</label>
        <input type="password" name="password" id="password" required>

        <button type="submit">Register</button>
    </form>
</div>

</body>
</html>
