<?php
// save_bank_details_api.php
header('Content-Type: application/json; charset=utf-8');
ini_set('display_errors',1);
error_reporting(E_ALL);

require __DIR__.'/db.php';  // gives $conn

// 1) parse input
$raw = file_get_contents('php://input');
$in  = json_decode($raw, true);

$mobile      = trim($in['mobile']      ?? '');
$holder_name = trim($in['holder_name'] ?? '');
$bank_name   = trim($in['bank_name']   ?? '');
$account_no  = trim($in['account_no']  ?? '');
$ifsc        = trim($in['ifsc']        ?? '');

if (!preg_match('/^\d{10}$/', $mobile)
 || $holder_name==='' 
 || $bank_name==='' 
 || $account_no==='' 
 || $ifsc==='') {
   http_response_code(400);
   exit(json_encode(['status'=>false,'message'=>'Invalid input']));
}

// 2) get user_id
$stmt = $conn->prepare("SELECT user_id FROM users_data WHERE mobile=? LIMIT 1");
$stmt->bind_param('s',$mobile);
$stmt->execute();
$stmt->bind_result($uid);
if (!$stmt->fetch()) {
  http_response_code(404);
  exit(json_encode(['status'=>false,'message'=>'User not found']));
}
$stmt->close();

// 3) upsert bank details
//    use INSERT ... ON DUPLICATE KEY UPDATE
$sql = "
  INSERT INTO user_bank_details 
    (user_id,holder_name,bank_name,account_no,ifsc)
  VALUES (?,?,?,?,?)
  ON DUPLICATE KEY UPDATE
    holder_name=VALUES(holder_name),
    bank_name  =VALUES(bank_name),
    account_no =VALUES(account_no),
    ifsc       =VALUES(ifsc)
";
$stmt = $conn->prepare($sql);
$stmt->bind_param(
  'issss',
  $uid,
  $holder_name,
  $bank_name,
  $account_no,
  $ifsc
);
if ($stmt->execute()) {
  echo json_encode(['status'=>true,'message'=>'Bank details saved']);
} else {
  http_response_code(500);
  echo json_encode(['status'=>false,'message'=>'Server error']);
}
$stmt->close();
$conn->close();
