<?php
// Sai/send_otp.php

// debug-only: show PHP errors in JSON
ini_set('display_errors','1');
ini_set('display_startup_errors','1');
error_reporting(E_ALL);

// JSON headers
header('Content-Type: application/json; charset=UTF-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');

// load DB if you want to log requests (optional)
require_once __DIR__ . '/db.php';        // defines $conn
require_once __DIR__ . '/sms_helper.php';

try {
    $data   = json_decode(file_get_contents('php://input'), true);
    $mobile = trim($data['mobile'] ?? '');
    if (!preg_match('/^[6-9]\d{9}$/', $mobile)) {
        throw new Exception('Invalid mobile number');
    }

    // (Optional) log the send into DB
    // $stmt = $conn->prepare("INSERT INTO otp_requests_log (mobile, requested_at) VALUES (?, NOW())");
    // $stmt->bind_param('s', $mobile);
    // $stmt->execute();
    // $stmt->close();

    // actually send
    $dbg  = [];
    $resp = sendSmsOtp($mobile, $dbg);

    $status = $resp['Status'] ?? $resp['status'] ?? '';
    if (strcasecmp($status, 'success') === 0) {
        echo json_encode(['status'=>'success','message'=>'OTP sent']);
    } else {
        $desc = $resp['description']['desc'] 
              ?? $resp['status_desc'] 
              ?? json_encode($resp);
        throw new Exception("SMSAlert error: $desc");
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'status'  => 'error',
        'message' => $e->getMessage()
    ]);
}
