<?php
// Sai/set_mpin.php  ← you can still call it set_mpin.php

// === Debug (remove in prod) ===
ini_set('display_errors','1');
ini_set('display_startup_errors','1');
error_reporting(E_ALL);

// === JSON + CORS headers ===
header('Content-Type: application/json; charset=UTF-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

// === Bring in mysqli connection ===
require_once __DIR__ . '/db.php';   // must define $conn = new mysqli(...)

try {
    $data   = json_decode(file_get_contents('php://input'), true);
    $mobile = trim($data['mobile'] ?? '');
    $mpin   = trim($data['mpin']   ?? '');

    // ==== Validate ====
    if (!preg_match('/^[6-9]\d{9}$/', $mobile) ||
        !preg_match('/^\d{4}$/',     $mpin)) {
        http_response_code(400);
        throw new Exception('Invalid mobile or MPIN format');
    }

    // ==== Update users_data.password ===
    $stmt = $conn->prepare("
        UPDATE `users_data`
           SET `password` = ?
         WHERE `mobile`   = ?
    ");
    if (! $stmt) {
        throw new Exception('DB prepare failed: ' . $conn->error);
    }
    $stmt->bind_param('ss', $mpin, $mobile);
    if (! $stmt->execute()) {
        throw new Exception('DB execute failed: ' . $stmt->error);
    }
    if ($stmt->affected_rows === 0) {
        http_response_code(404);
        throw new Exception('No user found with that mobile');
    }
    $stmt->close();

    // ==== Success ====
    echo json_encode([
      'status'  => 'success',
      'message' => 'MPIN saved'
    ]);

} catch (Exception $e) {
    http_response_code(http_response_code() ?: 500);
    echo json_encode([
      'status'  => 'error',
      'message' => $e->getMessage()
    ]);
}
