<?php
// settings_api.php

header('Content-Type: application/json; charset=utf-8');
ini_set('display_errors',0);
ini_set('log_errors',1);
error_reporting(E_ALL);

try {
    // 1) connect
    $db = new PDO(
      'mysql:host=localhost;dbname=u672932721_sai_app;charset=utf8mb4',
      'u672932721_sai_app_user',
      'Admin_66666',
      [ PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION ]
    );
    $db->exec("SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci");

    // 2) parse
    $in = json_decode(file_get_contents('php://input'), true);
    if(!$in) throw new Exception('Invalid JSON');

    if(empty($in['mobile']) || !preg_match('/^\d{10}$/',$in['mobile'])) {
      throw new Exception('Please provide your current mobile.');
    }
    $curMobile = $in['mobile'];

    // 3) fetch user
    $stmt = $db->prepare("SELECT user_id, username, email, mobile, password FROM users_data WHERE mobile=? LIMIT 1");
    $stmt->execute([$curMobile]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    if(!$user) throw new Exception('User not found.');

    $updates = [];
    $params  = [];

    // 4) optional profile fields
    if(!empty($in['new_username'])) {
      $updates[] = "username = ?";
      $params[]  = trim($in['new_username']);
    }
    if(!empty($in['new_email'])) {
      if(!filter_var($in['new_email'],FILTER_VALIDATE_EMAIL))
        throw new Exception('Invalid email address.');
      $updates[] = "email = ?";
      $params[]  = trim($in['new_email']);
    }
    if(!empty($in['new_mobile'])) {
      if(!preg_match('/^\d{10}$/',$in['new_mobile']))
        throw new Exception('new_mobile must be 10 digits.');
      $updates[] = "mobile = ?";
      $params[]  = trim($in['new_mobile']);
    }

    // 5) password change?
    $pwChange = false;
    if(isset($in['current_password']) || isset($in['new_password'])) {
      if(empty($in['current_password']) || empty($in['new_password'])) {
        throw new Exception('Both current_password and new_password are required to change password.');
      }
      // plain-text compare
      if($in['current_password'] !== $user['password']) {
        throw new Exception('Current password is incorrect.');
      }
      $updates[] = "password = ?";
      $params[]  = $in['new_password'];
      $pwChange  = true;
    }

    if(empty($updates)) {
      throw new Exception('No changes requested.');
    }

    // 6) run update
    $params[] = $user['user_id'];
    $sql = "UPDATE users_data SET ".implode(', ',$updates)." WHERE user_id = ?";
    $db->prepare($sql)->execute($params);

    // 7) respond with the new values
    $data = [];
    foreach(['username','email','mobile'] as $f) {
      if(isset($in["new_{$f}"])) {
        $data[$f] = trim($in["new_{$f}"]);
      }
    }
    if($pwChange) {
      $data['password_changed'] = true;
    }

    echo json_encode([
      'status'  => 'success',
      'message' => 'Profile updated successfully.',
      'data'    => $data
    ], JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT);

} catch(Exception $e) {
    http_response_code(400);
    echo json_encode([
      'status'  => 'error',
      'message' => $e->getMessage()
    ], JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT);
}
