<?php
// singlepanna.php

// 1) DEV: show errors (remove in prod)
ini_set('display_errors',1);
ini_set('display_startup_errors',1);
error_reporting(E_ALL);

session_start();
include 'db.php'; // $conn

// 2) Auth
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
$user_id = (int)$_SESSION['user_id'];

// 3) game_id
if (empty($_GET['game_id'])) {
    die("No game selected.");
}
$game_id = (int)$_GET['game_id'];

// 4) Mark sub_game
$stmt = $conn->prepare("UPDATE game56 SET sub_games = 'single_panna' WHERE id = ?");
$stmt->bind_param("i", $game_id);
$stmt->execute();
$stmt->close();

// 5) Fetch game details
$stmt = $conn->prepare("
    SELECT game_name, open_time, close_time
      FROM game56
     WHERE id = ?
");
$stmt->bind_param("i", $game_id);
$stmt->execute();
$stmt->bind_result($game_name, $open_time, $close_time);
if (!$stmt->fetch()) {
    die("Game not found.");
}
$stmt->close();

// 6) Compute bid_session and toggle classes
date_default_timezone_set('Asia/Kolkata');
$now    = new DateTime();
$openDT = DateTime::createFromFormat('H:i:s', $open_time);
$closeDT = DateTime::createFromFormat('H:i:s', $close_time);

// If close ≤ open → overnight
if ($closeDT <= $openDT) {
    $closeDT->modify('+1 day');
}

// session = 'close' if now between open–close, else 'open'
$nowTime = $now->format('H:i:s');
if ($open_time < $close_time) {
    $bid_session = ($nowTime >= $open_time && $nowTime <= $close_time)
                 ? 'close' : 'open';
} else {
    $bid_session = ($nowTime >= $open_time || $nowTime <= $close_time)
                 ? 'close' : 'open';
}

$openBtnClass  = $bid_session === 'open'  ? 'btn-blue' : 'btn-default';
$closeBtnClass = $bid_session === 'close' ? 'btn-blue' : 'btn-default';

// 7) Fetch wallet
$stmt = $conn->prepare("SELECT balance FROM wallet WHERE user_id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$stmt->bind_result($wallet_balance);
$stmt->fetch();
$stmt->close();

// 8) SP Pana lists
$singlePanas = [
  "SP Pana’s of 1" => ["128","137","146","236","245","290","380","470","489","560","579","678"],
  "SP Pana’s of 2" => ["129","138","147","156","237","246","345","390","480","570","589","679"],
  "SP Pana’s of 3" => ["120","139","148","157","238","247","256","346","490","580","670","689"],
  "SP Pana’s of 4" => ["130","149","158","167","239","248","257","347","356","590","680","789"],
  "SP Pana’s of 5" => ["140","159","168","230","249","258","267","348","357","456","690","780"],
  "SP Pana’s of 6" => ["123","150","169","178","240","259","268","349","358","367","457","790"],
  "SP Pana’s of 7" => ["124","160","278","179","250","269","340","359","368","458","467","890"],
  "SP Pana’s of 8" => ["125","134","170","189","260","279","350","369","468","378","459","567"],
  "SP Pana’s of 9" => ["126","135","180","234","270","289","360","379","450","469","478","568"],
  "SP Pana’s of 0" => ["127","136","145","190","235","280","370","389","460","479","569","578"],
];
$allNumbers = [];
foreach ($singlePanas as $nums) {
    $allNumbers = array_merge($allNumbers, $nums);
}
$allNumbers = array_unique($allNumbers, SORT_REGULAR);
sort($allNumbers, SORT_NUMERIC);

// 9) Handle bid submission
$message  = '';
$viewLink = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['place_bid'])) {
    $selected = $_POST['selected_number'] ?? '';
    $bid      = floatval($_POST['bid_amount'] ?? 0);

    if (!$selected) {
        $message = "<div class='alert alert-danger'>Please select a number.</div>";
    } elseif ($bid < 10) {
        $message = "<div class='alert alert-danger'>Minimum bid is ₹10.</div>";
    } elseif ($bid > $wallet_balance) {
        $message = "<div class='alert alert-danger'>Insufficient wallet balance.</div>";
    } else {
        $conn->begin_transaction();
        try {
            // Insert with bid_session
            $ins = $conn->prepare("
              INSERT INTO user_bids_sp
                (user_id, game_id, bid_details, total_bid_amount, bid_session, game_name)
              VALUES (?,?,?,?,?,(SELECT game_name FROM game56 WHERE id=?))
            ");
            $ins->bind_param("isddsi",
                $user_id,
                $game_id,
                $selected,
                $bid,
                $bid_session,
                $game_id
            );
            $ins->execute();
            $ins->close();

            // Deduct wallet
            $upd = $conn->prepare("
              UPDATE wallet SET balance = balance - ? WHERE user_id = ?
            ");
            $upd->bind_param("di", $bid, $user_id);
            $upd->execute();
            $upd->close();

            $conn->commit();
            $wallet_balance -= $bid;

            $viewLink = "<p class='view'><a href='invested_sp.php'>View Results</a></p>";
        } catch (Exception $e) {
            $conn->rollback();
            $message = "<div class='alert alert-danger'>Error placing bid: {$e->getMessage()}</div>";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Single Panna Bidding</title>
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <style>
    body { background:#f8f9fa; margin:0; font-family:Arial,sans-serif; color:#333 }
    .back {
      position:absolute; top:20px; left:20px;
      background:#28a745; color:#fff; padding:8px 12px;
      text-decoration:none; border-radius:4px;
    }
    .back:hover { background:#218838 }
    .header { text-align:center; padding:20px }
    .wallet { font-size:1.2rem; margin-bottom:10px }
    .toggle {
      text-align:center; margin:15px 0;
    }
    .btn {
      padding:8px 16px; margin:0 5px; border:none; border-radius:4px;
      cursor:pointer; background:#ccc; color:#333;
    }
    .btn-default { background:#ccc; }
    .btn-blue    { background:#007BFF; color:#fff; }
    .grid {
      display:grid;
      grid-template-columns:repeat(auto-fit,minmax(280px,1fr));
      gap:20px; padding:0 20px 20px;
    }
    .card {
      background:#fff; border:2px solid #f36; border-radius:8px;
      padding:15px; box-shadow:0 2px 5px rgba(0,0,0,0.1);
    }
    .card h2 { margin-top:0; color:#007BFF; font-size:1.2rem }
    .numbers { margin:10px 0; font-size:1rem; line-height:1.4 }
    .form {
      max-width:400px; margin:0 auto 40px;
      background:#fff; padding:20px; border-radius:8px;
      box-shadow:0 2px 5px rgba(0,0,0,0.1);
    }
    .form h3 { text-align:center; color:#007BFF; margin-top:0 }
    .alert { padding:0.75rem; margin-bottom:1rem; border-radius:4px }
    .alert-success { background:#d4edda; color:#155724 }
    .alert-danger  { background:#f8d7da; color:#721c24 }
    label { display:block; margin:0.5rem 0; font-weight:bold }
    select,input[type=number] {
      width:100%; padding:0.5rem; border:1px solid #ccc; border-radius:4px;
      margin-bottom:1rem;
    }
    button {
      width:100%; padding:0.75rem; background:#007BFF; color:#fff;
      border:none; border-radius:4px; cursor:pointer;
    }
    button:hover { background:#0056b3 }
    .view { text-align:center; margin:15px 0 }
    .view a { color:#007BFF; text-decoration:underline }
  </style>
</head>
<body>

  <a href="dashboard.php" class="back">← Dashboard</a>

  <div class="header">
    <h1>Single Panna Bidding</h1>
    <div class="toggle">
      <button class="btn <?= $openBtnClass ?>">Open</button>
      <button class="btn <?= $closeBtnClass ?>">Close</button>
    </div>
    <p><strong>Game:</strong> <?= htmlspecialchars($game_name) ?></p>
    <p><strong>Open:</strong> <?= date("g:i A",strtotime($open_time)) ?> IST&nbsp;&nbsp;
       <strong>Close:</strong> <?= date("g:i A",strtotime($close_time)) ?> IST</p>
    <div class="wallet">Wallet Balance: ₹<?= number_format($wallet_balance,2) ?></div>
  </div>

  <div class="grid">
    <?php foreach($singlePanas as $title => $nums): ?>
      <div class="card">
        <h2><?= $title ?></h2>
        <div class="numbers"><?= implode(", ", $nums) ?></div>
      </div>
    <?php endforeach; ?>
  </div>

  <div class="form">
    <h3>Place Your Bid</h3>
    <?= $message ?>
    <?= $viewLink ?>
    <form method="POST">
      <label for="selected_number">Select Number:</label>
      <select name="selected_number" id="selected_number" required>
        <option value="">-- Choose --</option>
        <?php foreach($allNumbers as $n): ?>
          <option value="<?= htmlspecialchars($n) ?>"><?= htmlspecialchars($n) ?></option>
        <?php endforeach; ?>
      </select>

      <label for="bid_amount">Bid Amount (₹):</label>
      <input type="number" name="bid_amount" id="bid_amount"
             step="0.01" min="10" required>

      <button type="submit" name="place_bid">Place Bid</button>
    </form>
  </div>

</body>
</html>
<?php $conn->close(); ?>
