<?php
// Sai/sms_helper.php

//  ─── CONFIG ────────────────────────────────────────────────────────────────
define('SMSALERT_API_KEY',   '6832c4a37f78b');
define('SMSALERT_SENDER_ID', 'CVDEMO');
define('OTP_RETRY',           2);    // how many times user can request resend
define('OTP_VALIDITY_MIN',   10);    // how long before OTP expires, in minutes

//  ─── POST FORM-URLENCODED and return decoded JSON (with debug) ─────────────
function postJson(string $url, array $fields, array &$dbg = []): array {
    $dbg['fields'] = $fields;
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST           => true,
        CURLOPT_POSTFIELDS     => http_build_query($fields),
        CURLOPT_TIMEOUT        => 10,
    ]);
    $raw = curl_exec($ch);
    $dbg['curlErr'] = curl_error($ch);
    curl_close($ch);

    $dbg['raw'] = $raw;
    $json = @json_decode($raw, true);
    if (json_last_error() !== JSON_ERROR_NONE || !is_array($json)) {
        return ['status'=>'error','description'=>['desc'=>"Invalid JSON from SMSAlert: $raw"]];
    }
    return $json;
}

//  ─── Send OTP via SMSAlert’s mverify.json ─────────────────────────────────
function sendSmsOtp(string $mobile, array &$dbg = []): array {
    // ensure country code
    if (preg_match('/^[6-9]\d{9}$/', $mobile)) {
        $mobile = '91' . $mobile;
    }

    // your DLT-approved template; [otp] will be auto-replaced
    $fields = [
        'apikey'   => SMSALERT_API_KEY,
        'sender'   => SMSALERT_SENDER_ID,
        'mobileno' => $mobile,
        'template' => 'Dear [otp], This message is sent for demo purpose via www.smsalert.co.in.',
        'retry'    => OTP_RETRY,
        'validity' => OTP_VALIDITY_MIN,
    ];

    $resp = postJson(
        'https://www.smsalert.co.in/api/mverify.json',
        $fields,
        $dbg
    );
    $dbg['response'] = $resp;
    return $resp;
}

//  ─── Verify OTP via mverify.json ───────────────────────────────────────────
function verifySmsOtp(string $mobile, string $code, array &$dbg = []): bool {
    if (preg_match('/^[6-9]\d{9}$/', $mobile)) {
        $mobile = '91' . $mobile;
    }

    $fields = [
        'apikey'   => SMSALERT_API_KEY,
        'mobileno' => $mobile,
        'code'     => $code,
    ];
    $resp = postJson(
        'https://www.smsalert.co.in/api/mverify.json',
        $fields,
        $dbg
    );
    $dbg['response'] = $resp;
    $status = $resp['Status'] ?? $resp['status'] ?? '';
    return strcasecmp($status, 'success') === 0;
}
