<?php
/* trs.php — Live SD/DP/SP/TP/JD/HS/FS (short version) */
(isset($_GET['debug'])?ini_set('display_errors',1):ini_set('display_errors',0));
error_reporting(E_ALL); session_start(); date_default_timezone_set('Asia/Kolkata');
require __DIR__.'/db.php'; if(!$conn||!($conn instanceof mysqli)){http_response_code(500);exit('DB not connected');}
require_once __DIR__.'/lib/wallet_helper.php';

/* ---------- payout multipliers (per ₹1 stake) ---------- */
/* --- payout multipliers (₹10 → …) --- */
$PAYOUT_SD = 10;      // 10x
$PAYOUT_JD = 100;     // 100x
$PAYOUT_SP = 160;     // 160x
$PAYOUT_DP = 320;     // 320x
$PAYOUT_TP = 1000;    // 1000x
$PAYOUT_HS = 1000;    // 1000x   (not used here)
$PAYOUT_FS = 10000;   // 10000x  (not used here)

$PAYOUT = [
  'SD' => $PAYOUT_SD,
  'JD' => $PAYOUT_JD,
  'SP' => $PAYOUT_SP,
  'DP' => $PAYOUT_DP,
  'TP' => $PAYOUT_TP,
  'HS' => $PAYOUT_HS,
  'FS' => $PAYOUT_FS,
];


/* ---------- tiny helpers ---------- */
function H($s){return htmlspecialchars((string)$s,ENT_QUOTES,'UTF-8');}
function dtToday($hms){ if(!$hms)return null; $p=explode(':',$hms); if(count($p)<2)return null; $d=new DateTime('today',new DateTimeZone('Asia/Kolkata')); $d->setTime((int)$p[0],(int)$p[1],(int)($p[2]??0)); return $d;}
function mmss($sec){$sec=max(0,(int)$sec);return sprintf('%02d:%02d',floor($sec/60),$sec%60);}
function tableExists($t,$c){$r=$c->query("SHOW TABLES LIKE '".$c->real_escape_string($t)."'");return $r&&$r->num_rows>0;}

function is_blank($v){
  if (!isset($v)) return true;
  if (is_string($v)) return trim($v) === '';
  if (is_array($v))  return count($v) === 0;
  return $v === null;
}

function sd_mod10(string $s): int {
  $sum = 0;
  for ($i = 0, $n = strlen($s); $i < $n; $i++) $sum += (int)$s[$i];
  return $sum % 10;
}

/* ---------- Single Digit parsing ---------- */
/* 1) JSON-like: {"0":50,"3":20} or {'0':50} or "0":"50" fragments */
function parseSD_jsonish($raw){
  $out=[]; if(!is_string($raw)||$raw==='')return $out;
  if($raw[0]=='{'&&substr($raw,-1)=='}'){
    // allow single quotes in keys, spaces after colon, etc.
    $j=str_replace(["'",": "],['" ',':'],preg_replace('/([{\s,])(\')([^\'"]+)(\')(\s*:)/','"$3":',$raw));
    $a=json_decode($j,true);
    if(is_array($a)) foreach($a as $k=>$v) if(preg_match('/^\d$/',$k)) $out[(int)$k]=($out[(int)$k]??0)+(float)$v;
  }
  if(!$out&&preg_match_all('/"(\d)"\s*:\s*"?(\d+(?:\.\d+)?)"?/',$raw,$m,PREG_SET_ORDER))
    foreach($m as $h)$out[(int)$h[1]]=(float)$h[2];
  ksort($out);return $out;
}



/* ---- Single Digit: robust extractor (handles 0 reliably) ---- */
/* ---- Single Digit: ultra-robust extractor (never drops 0) ---- */
function sd_extract_pairs($raw, $stake = null): array {
  if (!is_string($raw) || $raw === '') return [];

  // Normalise: unescape, decode HTML entities, remove NBSPs, fix trailing commas
  $s = trim(stripslashes($raw));
  $s = html_entity_decode($s, ENT_QUOTES | ENT_HTML5, 'UTF-8');       // &quot;0&quot; -> "0"
  $s = preg_replace('/\x{00A0}|\x{2007}|\x{202F}/u', ' ', $s);       // NBSP family -> space
  $s = preg_replace('/,(\s*[}\]])/', '$1', $s);                       // {"0":46,} -> {"0":46}

  $out = [];

  // A) True JSON object (or close enough after normalisation)
  $try = [$s];
  // also try to coerce single-quoted JSON into valid JSON
  $try[] = preg_replace('/([{\s,])\'([^\'"]+)\'\s*:/', '$1"$2":', $s);
  foreach ($try as $cand) {
    $j = json_decode($cand, true);
    if (is_array($j) && !empty($j)) {
      foreach ($j as $k => $v) {
        if (preg_match('/^\d$/', (string)$k)) {
          $out[(int)$k] = ($out[(int)$k] ?? 0) + (float)$v;
        }
      }
      if ($out) { ksort($out); return $out; }
    }
  }

  // B) Object-like fragments anywhere: {"0":46}, {0:"46"}, '0':46, 0:46
  if (preg_match_all('/[{,]\s*[\'"]?([0-9])[\'"]?\s*:\s*[\'"]?(\d+(?:\.\d+)?)[\'"]?\s*(?=,|})/u',
                     '{'.$s.'}', $m, PREG_SET_ORDER)) {
    foreach ($m as $h) {
      $d = (int)$h[1];
      $out[$d] = ($out[$d] ?? 0) + (float)$h[2];
    }
  }

  // C) Compact codes 194..203 => digit 0..9 (optional [amount]); falls back to $stake
  if (preg_match_all('/\b(19[4-9]|20[0-3])\b[^\d\[]*(?:\[\s*(\d+(?:\.\d+)?)\s*\])?/u', $s, $m2, PREG_SET_ORDER)) {
    foreach ($m2 as $h) {
      $d   = (int)$h[1] - 194;
      $amt = ($h[2] !== '' ? (float)$h[2] : (float)$stake);
      if ($amt > 0) $out[$d] = ($out[$d] ?? 0) + $amt;
    }
  }

  // D) Plain list of digits -> assign $stake per digit ([0], [0,3], "0 3", "0,3")
  if (!$out) {
    $j = json_decode($s, true);
    if (is_array($j) && array_keys($j) === range(0, count($j)-1)) {
      foreach ($j as $d) if (is_numeric($d) && $d >= 0 && $d <= 9) $out[(int)$d] = (float)$stake;
    } elseif (preg_match('/^\s*\[\s*([0-9])\s*\]\s*$/', $s, $mm)) {
      $out[(int)$mm[1]] = (float)$stake;
    } else {
      foreach (preg_split('/\D+/', $s) as $tok) {
        if ($tok !== '' && ctype_digit($tok)) {
          $d = (int)$tok; if ($d >= 0 && $d <= 9) $out[$d] = (float)$stake;
        }
      }
    }
  }

  // E) Final safety: literal zero in any form => use $stake
  if (!$out && preg_match('/^\s*(?:\[?\s*[\'"]?0[\'"]?\s*\]?)\s*$/u', $s)) {
    $out = [0 => (float)$stake];
  }

  ksort($out);
  return $out;
}




/* Parse Single-Digit from many formats and ALWAYS keep digit 0 */
function sd_pairs_all(string $raw, $stake = null): array {
  $pairs = [];

  // 1) JSON-ish map: {"0":200}, {'0':"200"}, "0":200 fragments
  $s = trim(stripslashes($raw));
  if ($s !== '' && $s[0] === '{' && substr($s, -1) === '}') {
    $json = preg_replace('/([{\s,])\'([^\'"]+)\'\s*:/', '$1"$2":', $s);       // '0': -> "0":
    $json = preg_replace('/:\s*\'([^\'"]*)\'/', ':"$1"', $json);              // : '123' -> :"123"
    $m = json_decode($json, true);
    if (is_array($m)) {
      foreach ($m as $k => $v) {
        if (preg_match('/^\d$/', (string)$k)) {
          $d = (int)$k;
          $pairs[$d] = ($pairs[$d] ?? 0) + (float)$v;
        }
      }
    }
  }
  if (!$pairs && preg_match_all('/"(\d)"\s*:\s*"?(\d+(?:\.\d+)?)"?/', $s, $mm, PREG_SET_ORDER)) {
    foreach ($mm as $h) {
      $d = (int)$h[1];
      $pairs[$d] = ($pairs[$d] ?? 0) + (float)$h[2];
    }
  }

  // 2) Code form 194..203 (digit 0..9) with optional [amount]
  if (preg_match_all('/\b(19[4-9]|20[0-3])\b[^\d\[]*(?:\[\s*(\d+(?:\.\d+)?)\s*\])?/u', $s, $mm, PREG_SET_ORDER)) {
    foreach ($mm as $h) {
      $digit = (int)$h[1] - 194;                          // 194 ⇒ 0
      $amt   = ($h[2] !== '' ? (float)$h[2] : (float)$stake);
      if ($amt > 0) $pairs[$digit] = ($pairs[$digit] ?? 0) + $amt;
    }
  }

  // 3) Plain “0”, “[0]”, “0 3”, “0,3”, or JSON array [0,3] — use $stake per digit
  if (!$pairs) {
    $j = json_decode($s, true);
    if (is_array($j) && array_keys($j) === range(0, count($j)-1)) {
      foreach ($j as $d) if (is_numeric($d) && $d >= 0 && $d <= 9) $pairs[(int)$d] = (float)$stake;
    } elseif (preg_match('/^\[\s*(\d)\s*\]$/', $s, $m1)) {
      $pairs[(int)$m1[1]] = (float)$stake;
    } else {
      foreach (preg_split('/\D+/', $s) as $tok) {
        if ($tok !== '' && ctype_digit($tok)) {
          $d = (int)$tok;
          if ($d >= 0 && $d <= 9) $pairs[$d] = (float)$stake;
        }
      }
    }
  }

  ksort($pairs);                      // ensure 0 is not lost and order is stable
  return $pairs;                      // array like [0 => 500, 3 => 120]
}


/* 2) Compact codes: 194..203 map to digits 0..9, amount inside [ .. ]
      Examples: "194 [1247]"  -> digit 0, amt 1247
                "197  [120]"  -> digit 3, amt 120
      Tolerates NBSP/odd spaces and extra words around. */
/* 2) Compact codes: 194..203 map to digits 0..9.
      If [amount] is missing, fall back to $stake (e.g., total_bid_amount). */
function parseSD_code_amount($raw, $stake=null){
  $out=[]; if(!is_string($raw)||$raw==='') return $out;
  // normalize NBSP-like spaces
  $raw=preg_replace('/\x{00A0}|\x{2007}|\x{202F}/u',' ',$raw);
  if(preg_match_all('/\b(19[4-9]|20[0-3])\b[^\d\[]*(?:\[\s*(\d+(?:\.\d+)?)\s*\])?/u',$raw,$m,PREG_SET_ORDER)){
    foreach($m as $h){
      $code=(int)$h[1];
      $digit=$code-194; if($digit<0||$digit>9) continue;
      // use bracket amount if present; otherwise use fallback stake (if positive)
      $amt = (isset($h[2]) && $h[2]!=='') ? (float)$h[2] : ((is_numeric($stake) && (float)$stake>0) ? (float)$stake : 0.0);
      if($amt>0) $out[$digit]=($out[$digit]??0)+$amt;
    }
  }
  return $out;
}


/* 3) Fallback: plain "0", "[0]", "0 3", "0,3", [0,3] → use total stake per digit */
function parseSD_plain_with_stake($raw,$stake){
  $out=[]; if(!is_string($raw)||$raw==='')return $out;
  // JSON array of digits: [0,3]
  $j=json_decode($raw,true);
  if(json_last_error()===JSON_ERROR_NONE && is_array($j)){
    $is_assoc=array_keys($j)!==range(0,count($j)-1);
    if(!$is_assoc){ foreach($j as $d) if(is_numeric($d)&&$d>=0&&$d<=9) $out[(int)$d]=(float)$stake; return $out; }
  }
  // single bracketed digit like "[0]"
  if(preg_match('/^\s*\[\s*(\d)\s*\]\s*$/',$raw,$m)){ $out[(int)$m[1]]=(float)$stake; return $out; }
  // tokens
  foreach(preg_split('/\D+/',$raw) as $d){
    if($d!=='' && ctype_digit($d) && (int)$d>=0 && (int)$d<=9) $out[(int)$d]=(float)$stake;
  }
  return $out;
}

/* ---------- Panna / JD helpers (unchanged) ---------- */
function parsePanna($raw){
  $rows=[]; if(!is_string($raw)||$raw==='')return $rows; $j=json_decode($raw,true);
  if(is_array($j)&&isset($j[0])&&is_array($j[0])){
    $acc=[]; foreach($j as $e){$n=(string)($e['number']??$e['num']??''); if($n==='')continue;
      $amt=(float)($e['amount']??$e['amt']??0); $s=strtoupper((string)($e['session']??'')); $s=($s==='C'||$s==='CLOSE')?'CLOSE':(($s==='O'||$s==='OPEN')?'OPEN':null);
      $acc[$n.'|'.($s?:'-')]=($acc[$n.'|'.($s?:'-')]??0)+$amt;}
    foreach ($acc as $k => $v) {
  $parts = array_pad(explode('|', $k, 2), 2, '-');
  $n = $parts[0]; $s = $parts[1];
  $rows[] = ['num'=>$n,'amt'=>$v,'sess'=>($s==='-'?null:$s)];
}

    return $rows;
  }
  if(is_array($j)){ foreach($j as $k=>$v) if(preg_match('/^\d{2,3}$/',(string)$k)) $rows[]=['num'=>(string)$k,'amt'=>(float)$v,'sess'=>null]; return $rows; }
  if(preg_match_all('/"(\d{2,3})"\s*:\s*"?(\d+(?:\.\d+)?)"?/',$raw,$m,PREG_SET_ORDER))
    foreach($m as $h)$rows[]=['num'=>$h[1],'amt'=>(float)$h[2],'sess'=>null];
  return $rows;
}

/* --- Jodi parser that returns per-number amounts --- */
function parseJD_items($raw, $fallbackTotal = null){
  $out = [];
  if (!is_string($raw) || trim($raw) === '') return $out;
  $s = trim(stripslashes($raw));

  // 1) JSON array of objects: [{number: "12", amount: 50, ...}, ...]
  $j = json_decode($s, true);
  if (is_array($j)) {
    // a) objects
    if (isset($j[0]) && is_array($j[0])) {
      foreach ($j as $e) {
        $n = isset($e['number']) ? $e['number'] :
             (isset($e['num']) ? $e['num'] :
             (isset($e['jd']) ? $e['jd'] :
             (isset($e['jodi']) ? $e['jodi'] : '')));
        if ($n === '') continue;
        $n = preg_replace('/\D+/','', (string)$n);
        if ($n === '') continue;
        $n = str_pad($n, 2, '0', STR_PAD_LEFT);
        $amt = (float)($e['amount'] ?? $e['amt'] ?? $e['stake'] ?? 0);
        $out[$n] = ($out[$n] ?? 0) + $amt;
      }
    } else {
      // b) map form: {"12": 100, "34": 50}
      foreach ($j as $k => $v) {
        if (preg_match('/^\d{1,2}$/', (string)$k)) {
          $n = str_pad((string)$k, 2, '0', STR_PAD_LEFT);
          $out[$n] = ($out[$n] ?? 0) + (float)$v;
        }
      }
      // c) plain array of numbers: ["12","34"] (no amounts provided)
      if (!$out && array_keys($j) === range(0, count($j)-1)) {
        $nums = [];
        foreach ($j as $v) {
          if (preg_match('/^\d{1,2}$/', (string)$v)) {
            $nums[] = str_pad((string)$v, 2, '0', STR_PAD_LEFT);
          }
        }
        if ($nums) {
          $per = (is_numeric($fallbackTotal) && $fallbackTotal > 0)
                 ? ((float)$fallbackTotal / count($nums)) : 0.0;
          foreach ($nums as $n) $out[$n] = ($out[$n] ?? 0) + $per;
        }
      }
    }
  }

  // 2) Text pairs like: 12:50, 12=50, "12" 50, 12-50, 12 -> 50
  if (!$out && preg_match_all('/\b(\d{1,2})\b\D+(\d+(?:\.\d+)?)/', $s, $m, PREG_SET_ORDER)) {
    foreach ($m as $h) {
      $n = str_pad($h[1], 2, '0', STR_PAD_LEFT);
      $out[$n] = ($out[$n] ?? 0) + (float)$h[2];
    }
  }

  // 3) Plain list without amounts: "12,34" or "12 34"
  if (!$out) {
    $nums = [];
    if (preg_match_all('/\b(\d{1,2})\b/', $s, $m)) {
      foreach ($m[1] as $n) $nums[] = str_pad($n, 2, '0', STR_PAD_LEFT);
    }
    if ($nums) {
      $nums = array_values(array_unique($nums));
      $per  = (is_numeric($fallbackTotal) && $fallbackTotal > 0)
              ? ((float)$fallbackTotal / count($nums)) : 0.0;
      foreach ($nums as $n) $out[$n] = ($out[$n] ?? 0) + $per;
    }
  }

  // return as list of ['num' => '12', 'amt' => 50.0]
  $rows = [];
  foreach ($out as $n => $a) $rows[] = ['num' => $n, 'amt' => (float)$a];
  return $rows;
}

function parseJD($raw){
  $out=[]; if(!is_string($raw)||$raw==='')return $out; $t=trim($raw);
  if(preg_match('/^\d{1,2}$/',$t)) return [str_pad($t,2,'0',STR_PAD_LEFT)];
  if(preg_match('/^\s*\d{1,2}(\s*[, ]\s*\d{1,2})+\s*$/',$t)){ foreach(preg_split('/\s*[, ]\s*/',$t) as $n)$out[]=str_pad($n,2,'0',STR_PAD_LEFT); return $out; }
  $j=json_decode($t,true); if(is_array($j)){
    if(isset($j[0])&&is_array($j[0])){ foreach($j as $e){$n=(string)($e['number']??$e['num']??''); if($n!=='')$out[]=str_pad($n,2,'0',STR_PAD_LEFT);} return $out; }
    foreach($j as $k=>$v) if(preg_match('/^\d{1,2}$/',(string)$k)) $out[]=str_pad((string)$k,2,'0',STR_PAD_LEFT);
    if($out) return $out;
  }
  if(preg_match_all('/\b\d{1,2}\b/',$t,$m)) foreach($m[0] as $n)$out[]=str_pad($n,2,'0',STR_PAD_LEFT);
  return $out;
}

/* ---------- AJAX: return <tr> rows ---------- */
if(isset($_GET['ajax'])){
  header('Content-Type:text/html; charset=utf-8'); header('Cache-Control:no-store, no-cache, must-revalidate, max-age=0');
  $t=$_GET['type']??'sd'; $now=new DateTime('now',new DateTimeZone('Asia/Kolkata'));

  /* SD */
  /* SD */
if ($t === 'sd') {
  $q = "SELECT b.id bid_id,b.bid_details,b.bid_session,b.total_bid_amount,b.game_name, b.user_id AS user_id, u.username,u.mobile,
        DATE_FORMAT(b.created_at,'%d-%m-%Y %h:%i %p') created_fmt,UNIX_TIMESTAMP(b.created_at) ts,
        COALESCE(TIME_FORMAT(g.open_time,'%h:%i %p'),TIME_FORMAT(r.open_time,'%h:%i %p')) g_open_12,
        COALESCE(TIME_FORMAT(g.close_time,'%h:%i %p'),TIME_FORMAT(r.close_time,'%h:%i %p')) g_close_12,
        COALESCE(TIME_FORMAT(g.open_time,'%H:%i:%s'),TIME_FORMAT(r.open_time,'%H:%i:%s')) g_open_hms,
        COALESCE(TIME_FORMAT(g.close_time,'%H:%i:%s'),TIME_FORMAT(r.close_time,'%H:%i:%s')) g_close_hms,
        r.winning_open_time_sd win_o,r.winning_close_time_sd win_c
        FROM user_bids b
        LEFT JOIN users_data u ON u.user_id=b.user_id
        LEFT JOIN game56 g     ON g.id=b.game_id
        LEFT JOIN sd_rewards r ON r.game_id=b.game_id AND r.reward_date=CURDATE()
        ORDER BY b.created_at DESC,b.id DESC LIMIT 400";

  if (!($res = $conn->query($q))) { echo "<tr><td colspan=20>SQL error</td></tr>"; exit; }

  $rows = [];
  while ($R = $res->fetch_assoc()) {
    // 1) Robust parse that ALWAYS keeps digit 0 if present
    // 1) JSON/object style first
// 1) Parse all normal formats first
// 1) Parse all normal formats first
$pairs = sd_extract_pairs((string)$R['bid_details'], (float)$R['total_bid_amount']);



/* ---- FINAL RESCUE for “only 0” bids ---- */
if (!$pairs) {
  $bd = (string)$R['bid_details'];

  // 1) fix common glitches: \" … \", trailing comma, weird spaces
  $bd2 = trim(stripslashes($bd));
  $bd2 = preg_replace('/,(\s*[}\]])/', '$1', $bd2);           // {"0":46,} -> {"0":46}
  $bd2 = preg_replace('/\x{00A0}|\x{2007}|\x{202F}/u',' ', $bd2); // NBSPs

  // 2) Strict forms that should mean “only 0”
  //    {"0":46} | {'0':46} | {0:46} | "0":46 | '0':"46"
   if (preg_match('/^\s*\{\s*["\']?0["\']?\s*:\s*["\']?(\d+(?:\.\d+)?)["\']?\s*\}\s*$/u', $bd2, $m)) {
    $pairs = [0 => (float)$m[1]];
  }
  if (!$pairs && preg_match('/^\s*(?:\[?\s*["\']?0["\']?\s*\]?)\s*$/u', $bd2)) {
    $pairs = [0 => (float)$R['total_bid_amount']];
  }
  if (!$pairs && preg_match('/["\']?\s*0\s*["\']?\s*[:=]\s*["\']?(\d+(?:\.\d+)?)["\']?/u', $bd2, $m)) {
    $pairs = [0 => (float)$m[1]];
  }
}

if (!$pairs) continue;   // ✅ only skip now, after trying the fallbacks



    if (count($pairs) === 0) continue; // nothing parseable

    $od = dtToday($R['g_open_hms']);
    $cd = dtToday($R['g_close_hms']);
    $wO = ($R['win_o'] !== '' ? (int)$R['win_o'] : null);
    $wC = ($R['win_c'] !== '' ? (int)$R['win_c'] : null);
    $wOwait = ($od && $now < $od) ? $od->getTimestamp() - $now->getTimestamp() : 0;
    $wCwait = ($cd && $now < $cd) ? $cd->getTimestamp() - $now->getTimestamp() : 0;

    foreach ($pairs as $d => $amt) {
      $rO = 'Pending';
      if ($od && $now >= $od && $wO !== null) $rO = ((int)$d === $wO) ? 'You win' : 'Better luck';
      $rC = 'Pending';
      if ($cd && $now >= $cd && $wC !== null) $rC = ((int)$d === $wC) ? 'You win' : 'Better luck';
      
      $pay = 0.0;
if ($R['bid_session'] === 'open'  && $wO !== null && (int)$d === $wO) $pay = (float)$amt * $PAYOUT['SD'];
if ($R['bid_session'] === 'close' && $wC !== null && (int)$d === $wC) $pay = (float)$amt * $PAYOUT['SD'];
// Auto-credit (idempotent) – credit the winner once
if ($pay > 0 && !empty($R['user_id'])) {
  $sessionUC = (strtolower($R['bid_session']) === 'close') ? 'CLOSE' : 'OPEN';
  wallet_win_credit((int)$R['user_id'], (float)$pay, 'SD', (int)$R['bid_id'], (string)$d, $sessionUC);
}


      $rows[] = [
        'id' => $R['bid_id'] . '_' . $d,
        'ts' => $R['ts'],
        'g'  => $R['game_name'],
        'o12'=> $R['g_open_12'],
        'c12'=> $R['g_close_12'],
        'u'  => $R['username'],
        'm'  => $R['mobile'],

        'digit' => (string)$d,                 // keep “0” as a string to avoid truthiness issues
        'amt'   => (float)$amt,
        'sess'  => $R['bid_session'],
        'wO'    => $wO,
        'wC'    => $wC,
        'rO'    => $rO,
        'rC'    => $rC,
        'wOwait'=> $wOwait,
        'wCwait'=> $wCwait,
        'pay' => $pay,

        'created' => $R['created_fmt']
      ];
    }
  }

  if (!$rows) { echo "<tr><td colspan=20>No rows</td></tr>"; exit; }

  usort($rows, function($a,$b){ return $b['ts'] <=> $a['ts'] ?: strcmp($b['id'], $a['id']); });

  foreach ($rows as $r) {
    $pO  = $r['rO'] === 'Pending' && $r['wOwait'] > 0;
    $pC  = $r['rC'] === 'Pending' && $r['wCwait'] > 0;
    $tO  = $pO ? ('Pending ⏳ ' . mmss($r['wOwait'])) : $r['rO'];
    $tC  = $pC ? ('Pending ⏳ ' . mmss($r['wCwait'])) : $r['rC'];
    $cO  = $pO ? 'pending-time' : ($r['rO'] !== 'Pending' ? 'result-now' : '');
    $cC  = $pC ? 'pending-time' : ($r['rC'] !== 'Pending' ? 'result-now' : '');
    $rowC= (($r['rO'] !== 'Pending') || ($r['rC'] !== 'Pending')) ? 'resolved-row' : '';

    echo '<tr class="'.$rowC.'" data-type="sd" data-id="'.H($r['id']).'" data-ts="'.$r['ts'].'"' .
         ' data-open-digit="'.H($r['wO']).'" data-close-digit="'.H($r['wC']).'">' .
         '<td>'.H($r['g']).'</td><td>'.H($r['o12']).'</td><td>'.H($r['c12']).'</td>' .
         '<td>'.H($r['u']).'</td><td>'.H($r['m']?:'—').'</td>' .
         '<td>'.H($r['digit']).'</td><td>₹'.number_format($r['amt'],2).'</td>' .
         '<td>'.H($r['sess']).'</td><td>'.H($r['wO']).'</td><td>'.H($r['wC']).'</td>' .
         '<td class="'.$cO.'">'.H($tO).'</td><td class="'.$cC.'">'.H($tC).'</td>' .
         '<td>'.($r['pay']>0 ? '₹'.number_format($r['pay'],2) : '—').'</td>' .

         '<td>'.H($r['created']).'</td></tr>';
  }
  exit;
}


  /* DP / SP / TP share same pattern except table + reward + result columns */
  if(in_array($t,['dp','sp','tp'],true)){
    $map=['dp'=>['tbl'=>'user_bids_dp','rew'=>'dp_rewards','co'=>'winning_open_time_dp','cc'=>'winning_close_time_dp'],
          'sp'=>['tbl'=>'user_bids_sp','rew'=>'sp_rewards','co'=>'winning_open_time_sp','cc'=>'winning_close_time_sp'],
          'tp'=>['tbl'=>'user_bids_tp','rew'=>'tp_rewards','co'=>'winning_open_time_tp','cc'=>'winning_close_time_tp']];
    [$tbl,$rew,$CO,$CC]=[$map[$t]['tbl'],$map[$t]['rew'],$map[$t]['co'],$map[$t]['cc']];
    $q="SELECT b.id bid_id,b.bid_details,b.bid_session,b.game_name,b.user_id AS user_id, b.total_bid_amount,u.username,u.mobile,
    DATE_FORMAT(b.created_at,'%d-%m-%Y %h:%i %p') created_fmt,UNIX_TIMESTAMP(b.created_at) ts,
    TIME_FORMAT(g.open_time,'%h:%i %p') g_open_12,TIME_FORMAT(g.close_time,'%h:%i %p') g_close_12,
    TIME_FORMAT(g.open_time,'%H:%i:%s') g_open_hms,TIME_FORMAT(g.close_time,'%H:%i:%s') g_close_hms,
    r.$CO win_o,r.$CC win_c
    FROM $tbl b LEFT JOIN users_data u ON u.user_id=b.user_id LEFT JOIN game56 g ON g.id=b.game_id
    LEFT JOIN $rew r ON r.game_id=b.game_id AND r.reward_date=CURDATE()
    ORDER BY b.created_at DESC,b.id DESC LIMIT 400";
    if(!($res=$conn->query($q))){echo "<tr><td colspan=20>SQL error</td></tr>";exit;}
    $now=new DateTime('now',new DateTimeZone('Asia/Kolkata'));
    while($R=$res->fetch_assoc()){
      $items=parsePanna($R['bid_details']); if(!$items)continue;
      $o=dtToday($R['g_open_hms']); $c=dtToday($R['g_close_hms']); $wO=$R['win_o']!==''?(string)$R['win_o']:null; $wC=$R['win_c']!==''?(string)$R['win_c']:null;
      $wOwait=($o&&$now<$o)?$o->getTimestamp()-$now->getTimestamp():0; $wCwait=($c&&$now<$c)?$c->getTimestamp()-$now->getTimestamp():0;
            /* --- payout for this row --- */
      $mult = ($t === 'sp') ? $PAYOUT_SP : (($t === 'dp') ? $PAYOUT_DP : $PAYOUT_TP);
     

      foreach($items as $e){
        $num=$e['num']; $amt=(float)$e['amt']; $sess=strtoupper($e['sess']?:$R['bid_session']); $sess=$sess==='CLOSE'?'close':'open';
         $pay  = 0.0;
      if ($sess === 'open'  && $wO !== null && $num === $wO)  $pay = $amt * $mult;
      if ($sess === 'close' && $wC !== null && $num === $wC)  $pay = $amt * $mult;
      if ($pay > 0 && !empty($R['user_id'])) {
  $sessionUC = ($sess === 'close') ? 'CLOSE' : 'OPEN';
  $type = strtoupper($t); // 'DP', 'SP', or 'TP'
  wallet_win_credit((int)$R['user_id'], (float)$pay, $type, (int)$R['bid_id'], (string)$num, $sessionUC);
}

        $rO='Pending'; if($o&&$now>=$o&&$wO!==null)$rO=($num===$wO)?'You win':'Better luck';
        $rC='Pending'; if($c&&$now>=$c&&$wC!==null)$rC=($num===$wC)?'You win':'Better luck';
        $pO=$rO==='Pending'&&$wOwait>0; $pC=$rC==='Pending'&&$wCwait>0;
        $tO=$pO?('Pending ⏳ '.mmss($wOwait)):$rO; $tC=$pC?('Pending ⏳ '.mmss($wCwait)):$rC;
        $cO=$pO?'pending-time':($rO!=='Pending'?'result-now':''); $cC=$pC?'pending-time':($rC!=='Pending'?'result-now':'');
        $rowC=(($rO!=='Pending')||($rC!=='Pending'))?'resolved-row':'';
              echo '<tr class="'.$rowC.'" data-type="'.H($t).'" data-id="'.(int)$R['bid_id'].'" data-ts="'.(int)$R['ts'].'" data-open-digit="'.H($wO).'" data-close-digit="'.H($wC).'">'.
           '<td>'.H($R['game_name']).'</td><td>'.H($R['g_open_12']).'</td><td>'.H($R['g_close_12']).'</td><td>'.H($R['username']).'</td><td>'.H($R['mobile']?:'—').'</td>'.
           '<td>'.H($num).'</td><td>₹'.number_format($amt,2).'</td><td>'.H($sess).'</td><td>'.H($wO).'</td><td>'.H($wC).'</td>'.
           '<td class="'.$cO.'">'.H($tO).'</td><td class="'.$cC.'">'.H($tC).'</td>'.
           /* NEW cell: Win ₹ */
           '<td>'.($pay > 0 ? '₹'.number_format($pay, 2) : '–').'</td>'.
           /* existing last cell */
           '<td>'.H($R['created_fmt']).'</td>'.
      '</tr>';

      }
    } exit;
  }

  /* JD */
  if($t==='jd'){
  $q="SELECT b.id bid_id,b.bid_details,b.total_bid_amount,b.bid_session,b.game_name, b.user_id AS user_id, u.username,u.mobile,
      DATE_FORMAT(b.created_at,'%d-%m-%Y %h:%i %p') created_fmt,UNIX_TIMESTAMP(b.created_at) ts,
      COALESCE(TIME_FORMAT(g.open_time,'%h:%i %p'),TIME_FORMAT(r.open_time,'%h:%i %p')) g_open_12,
      COALESCE(TIME_FORMAT(g.close_time,'%h:%i %p'),TIME_FORMAT(r.close_time,'%h:%i %p')) g_close_12,
      COALESCE(TIME_FORMAT(g.open_time,'%H:%i:%s'),TIME_FORMAT(r.open_time,'%H:%i:%s')) g_open_hms,
      COALESCE(TIME_FORMAT(g.close_time,'%H:%i:%s'),TIME_FORMAT(r.close_time,'%H:%i:%s')) g_close_hms,
      r.winning_open_time_jd win_o, r.winning_close_time_jd win_c
      FROM user_bids_jd b
      LEFT JOIN users_data u ON u.user_id=b.user_id
      LEFT JOIN game56 g ON g.id=b.game_id
      LEFT JOIN jd_rewards r ON r.game_id=b.game_id AND r.reward_date=CURDATE()
      ORDER BY b.created_at DESC,b.id DESC LIMIT 400";

  if(!($res=$conn->query($q))){echo "<tr><td colspan=20>SQL error</td></tr>";exit;}

  $now=new DateTime('now',new DateTimeZone('Asia/Kolkata'));
  while($R=$res->fetch_assoc()){
    // NEW: get per-number amounts
    $items = parseJD_items($R['bid_details'], (float)$R['total_bid_amount']);
    if(!$items) continue;

    $o=dtToday($R['g_open_hms']); $c=dtToday($R['g_close_hms']);
    $wO=$R['win_o']!==''?str_pad($R['win_o'],2,'0',STR_PAD_LEFT):null;
    $wC=$R['win_c']!==''?str_pad($R['win_c'],2,'0',STR_PAD_LEFT):null;
    $wOwait=($o&&$now<$o)?$o->getTimestamp()-$now->getTimestamp():0;
    $wCwait=($c&&$now<$c)?$c->getTimestamp()-$now->getTimestamp():0;

    foreach($items as $e){
      $num = $e['num'];                  // '12'
      $amt = (float)$e['amt'];           // per-number amount
      $sess=strtoupper($R['bid_session'])==='CLOSE'?'close':'open';

      $rO='Pending'; if($o&&$now>=$o&&$wO!==null)$rO=($num===$wO)?'You win':'Better luck';
      $rC='Pending'; if($c&&$now>=$c&&$wC!==null)$rC=($num===$wC)?'You win':'Better luck';
      
            /* --- payout for this row (JD = 100x) --- */
      $pay = 0.0;
      if ($sess === 'open'  && $wO !== null && $num === $wO)  $pay = $amt * $PAYOUT_JD;
      if ($sess === 'close' && $wC !== null && $num === $wC)  $pay = $amt * $PAYOUT_JD;
if ($pay > 0 && !empty($R['user_id'])) {
  $sessionUC = ($sess === 'close') ? 'CLOSE' : 'OPEN';
  wallet_win_credit((int)$R['user_id'], (float)$pay, 'JD', (int)$R['bid_id'], (string)$num, $sessionUC);
}


      $pO=$rO==='Pending'&&$wOwait>0; $pC=$rC==='Pending'&&$wCwait>0;
      $tO=$pO?('Pending ⏳ '.mmss($wOwait)):$rO;
      $tC=$pC?('Pending ⏳ '.mmss($wCwait)):$rC;
      $cO=$pO?'pending-time':($rO!=='Pending'?'result-now':'');
      $cC=$pC?'pending-time':($rC!=='Pending'?'result-now':'');
      $rowC=(($rO!=='Pending')||($rC!=='Pending'))?'resolved-row':'';

      echo '<tr class="'.$rowC.'" data-type="jd" data-id="'.(int)$R['bid_id'].'_'.$num.'" data-ts="'.(int)$R['ts'].'"
                 data-open-digit="'.H($wO).'" data-close-digit="'.H($wC).'">'.
              '<td>'.H($R['game_name']).'</td>'.
              '<td>'.H($R['g_open_12']).'</td>'.
              '<td>'.H($R['g_close_12']).'</td>'.
              '<td>'.H($R['username']).'</td>'.
              '<td>'.H($R['mobile']?:'—').'</td>'.
              '<td>'.H($num).'</td>'.
              '<td>₹'.number_format($amt,2).'</td>'.   // <-- per-number amount
              '<td>'.H($sess).'</td>'.
              '<td>'.H($wO).'</td>'.
              '<td>'.H($wC).'</td>'.
              '<td class="'.$cO.'">'.H($tO).'</td>'.
              '<td class="'.$cC.'">'.H($tC).'</td>'.
               '<td>'.($pay > 0 ? '₹'.number_format($pay, 2) : '–').'</td>'.
              '<td>'.H($R['created_fmt']).'</td>'.
           '</tr>';
    }
  }
  exit;
}


  /* HS (Half Sangam): bid_open_hs (OD) + bid_close_hs (CP) */
  if($t==='hs'){
    $q="SELECT b.id bid_id,b.bid_open_hs bid_od,b.bid_close_hs bid_cp,b.total_bid_amount,b.bid_session,b.game_name, b.user_id AS user_id, u.username,u.mobile,
    DATE_FORMAT(b.created_at,'%d-%m-%Y %h:%i %p') created_fmt,UNIX_TIMESTAMP(b.created_at) ts,
    TIME_FORMAT(g.open_time,'%h:%i %p') g_open_12,TIME_FORMAT(g.close_time,'%h:%i %p') g_close_12,
    TIME_FORMAT(g.open_time,'%H:%i:%s') g_open_hms,TIME_FORMAT(g.close_time,'%H:%i:%s') g_close_hms,
    r.winning_open_time_od_hs w_open_od,r.winning_open_time_cp_hs w_open_cp,r.winning_close_time_od_hs w_close_od,r.winning_close_time_cp_hs w_close_cp
    FROM user_bids_hs b LEFT JOIN users_data u ON u.user_id=b.user_id LEFT JOIN game56 g ON g.id=b.game_id
    LEFT JOIN hs_rewards r ON r.game_id=b.game_id AND r.reward_date=CURDATE()
    ORDER BY b.created_at DESC,b.id DESC LIMIT 400";
    if(!($res=$conn->query($q))){echo "<tr><td colspan=20>SQL error</td></tr>";exit;}
    $now=new DateTime('now',new DateTimeZone('Asia/Kolkata'));
    while($R=$res->fetch_assoc()){
      $o=dtToday($R['g_open_hms']); $c=dtToday($R['g_close_hms']);
      $wOod=$R['w_open_od']!==''?(string)$R['w_open_od']:null; $wOcp=$R['w_open_cp']!==''?(string)$R['w_open_cp']:null;
      $wCod=$R['w_close_od']!==''?(string)$R['w_close_od']:null; $wCcp=$R['w_close_cp']!==''?(string)$R['w_close_cp']:null;
      $bidOD=(string)$R['bid_od']; $bidCP=(string)$R['bid_cp'];
      $oWait=($o&&$now<$o)?$o->getTimestamp()-$now->getTimestamp():0; $cWait=($c&&$now<$c)?$c->getTimestamp()-$now->getTimestamp():0;
      $rOod=$o&&$now>=$o?($wOod===null?'Pending':($bidOD===$wOod?'You win':'Better luck')):'Pending';
      $rOcp=$o&&$now>=$o?($wOcp===null?'Pending':($bidCP===$wOcp?'You win':'Better luck')):'Pending';
      $rCod=$c&&$now>=$c?($wCod===null?'Pending':($bidOD===$wCod?'You win':'Better luck')):'Pending';
      $rCcp=$c&&$now>=$c?($wCcp===null?'Pending':($bidCP===$wCcp?'You win':'Better luck')):'Pending';
      
      $winAmtO = ($rOod === 'You win' && $rOcp === 'You win') ? (float)$R['total_bid_amount'] * $PAYOUT_HS : 0.0;
$winAmtC = ($rCod === 'You win' && $rCcp === 'You win') ? (float)$R['total_bid_amount'] * $PAYOUT_HS : 0.0;
$sessionUC = (strtolower($R['bid_session']) === 'close') ? 'CLOSE' : 'OPEN';
$toCredit  = ($sessionUC === 'OPEN') ? $winAmtO : $winAmtC;

if ($toCredit > 0 && !empty($R['user_id'])) {
  $sub = $bidOD.'|'.$bidCP; // make the win ref unique per pair
  wallet_win_credit((int)$R['user_id'], (float)$toCredit, 'HS', (int)$R['bid_id'], $sub, $sessionUC);
}

      $pO=(($rOod==='Pending'||$rOcp==='Pending')&&$oWait>0); $pC=(($rCod==='Pending'||$rCcp==='Pending')&&$cWait>0);
      $txO=$pO?('Pending ⏳ '.mmss($oWait)):''; $txC=$pC?('Pending ⏳ '.mmss($cWait)):'';
      $cO=$pO?'pending-time':(($rOod!=='Pending'||$rOcp!=='Pending')?'result-now':''); $cC=$pC?'pending-time':(($rCod!=='Pending'||$rCcp!=='Pending')?'result-now':''); $rowC=(($rOod!=='Pending'||$rOcp!=='Pending'||$rCod!=='Pending'||$rCcp!=='Pending'))?'resolved-row':'';
      echo '<tr class="'.$rowC.'" data-type="hs" data-id="'.(int)$R['bid_id'].'" data-ts="'.(int)$R['ts'].'" data-open-od="'.H($wOod).'" data-open-cp="'.H($wOcp).'" data-close-od="'.H($wCod).'" data-close-cp="'.H($wCcp).'">'.
      '<td>'.H($R['game_name']).'</td><td>'.H($R['g_open_12']).'</td><td>'.H($R['g_close_12']).'</td><td>'.H($R['username']).'</td><td>'.H($R['mobile']?:'—').'</td>'.
      '<td>'.H($bidOD).'</td><td>'.H($bidCP).'</td><td>₹'.number_format((float)$R['total_bid_amount'],2).'</td><td>'.H($R['bid_session']).'</td>'.
      '<td>'.H($wOod?:'—').'</td><td>'.H($wOcp?:'—').'</td><td>'.H($wCod?:'—').'</td><td>'.H($wCcp?:'—').'</td>'.
      '<td class="'.$cO.'">'.H($pO?$txO:$rOod).'</td><td class="'.$cO.'">'.H($pO?$txO:$rOcp).'</td><td class="'.$cC.'">'.H($pC?$txC:$rCod).'</td><td class="'.$cC.'">'.H($pC?$txC:$rCcp).'</td>'.
      '<td>'.($winAmtO>0?'₹'.number_format($winAmtO,2):'—').'</td>'.
'<td>'.($winAmtC>0?'₹'.number_format($winAmtC,2):'—').'</td>'.

      '<td>'.H($R['created_fmt']).'</td></tr>';
    } exit;
  }

  /* FS (Full Sangam): picks user_bids_fs OR user_bids_fsp automatically */
  /* FS (Full Sangam): show user_bids_fs with today's winners from fs_rewards */
if ($t === 'fs') {
  // hard-bind to user_bids_fs (your schema); don’t fall back to legacy names
  if (!tableExists('user_bids_fs', $conn)) { echo "<tr><td colspan=20>No rows</td></tr>"; exit; }

  $q = "
    SELECT
      b.id AS bid_id,
      b.bid_open_fs AS bid_op,
      b.bid_close_fs AS bid_cp,
      b.total_bid_amount,
      b.bid_session,
      u.username, u.mobile,
      g.game_name,
       b.user_id AS user_id, 
      DATE_FORMAT(b.created_at, '%d-%m-%Y %h:%i %p') AS created_fmt,
      UNIX_TIMESTAMP(b.created_at)                   AS ts,

      TIME_FORMAT(g.open_time,  '%h:%i %p')          AS g_open_12,
      TIME_FORMAT(g.close_time, '%h:%i %p')          AS g_close_12,
      TIME_FORMAT(g.open_time,  '%H:%i:%s')          AS g_open_hms,
      TIME_FORMAT(g.close_time, '%H:%i:%s')          AS g_close_hms,

      /* winners for today (may be NULL if not declared yet) */
      r.winning_open_op_fs  AS w_open_op,
      r.winning_open_cp_fs  AS w_open_cp,
      r.winning_close_op_fs AS w_close_op,
      r.winning_close_cp_fs AS w_close_cp

    FROM user_bids_fs b
    LEFT JOIN users_data u ON u.user_id = b.user_id
    LEFT JOIN game56 g     ON g.id      = b.game_id
    LEFT JOIN fs_rewards r ON r.game_id = b.game_id AND r.reward_date = CURDATE()
    ORDER BY b.created_at DESC, b.id DESC
    LIMIT 400
  ";

  if (!($res = $conn->query($q))) { echo "<tr><td colspan=20>SQL error</td></tr>"; exit; }

  $now = new DateTime('now', new DateTimeZone('Asia/Kolkata'));
  $printed = false;

  while ($R = $res->fetch_assoc()) {
    $o = dtToday($R['g_open_hms']);
    $c = dtToday($R['g_close_hms']);

    $wOop = ($R['w_open_op']  !== null && $R['w_open_op']  !== '') ? (string)$R['w_open_op']  : null;
    $wOcp = ($R['w_open_cp']  !== null && $R['w_open_cp']  !== '') ? (string)$R['w_open_cp']  : null;
    $wCop = ($R['w_close_op'] !== null && $R['w_close_op'] !== '') ? (string)$R['w_close_op'] : null;
    $wCcp = ($R['w_close_cp'] !== null && $R['w_close_cp'] !== '') ? (string)$R['w_close_cp'] : null;

    $bidOP = (string)$R['bid_op'];
    $bidCP = (string)$R['bid_cp'];

    // skip truly malformed rows (both picks empty)
    if ($bidOP === '' && $bidCP === '') { continue; }

    $oWait = ($o && $now < $o) ? $o->getTimestamp() - $now->getTimestamp() : 0;
    $cWait = ($c && $now < $c) ? $c->getTimestamp() - $now->getTimestamp() : 0;

    $rOop = $o && $now >= $o ? ($wOop === null ? 'Pending' : ($bidOP === $wOop ? 'You win' : 'Better luck')) : 'Pending';
    $rOcp = $o && $now >= $o ? ($wOcp === null ? 'Pending' : ($bidCP === $wOcp ? 'You win' : 'Better luck')) : 'Pending';
    $rCop = $c && $now >= $c ? ($wCop === null ? 'Pending' : ($bidOP === $wCop ? 'You win' : 'Better luck')) : 'Pending';
    $rCcp = $c && $now >= $c ? ($wCcp === null ? 'Pending' : ($bidCP === $wCcp ? 'You win' : 'Better luck')) : 'Pending';
    
    $winAmtO = ($rOop === 'You win' && $rOcp === 'You win') ? (float)$R['total_bid_amount'] * $PAYOUT['FS'] : 0.0;
$winAmtC = ($rCop === 'You win' && $rCcp === 'You win') ? (float)$R['total_bid_amount'] * $PAYOUT['FS'] : 0.0;
$sessionUC = (strtoupper((string)$R['bid_session']) === 'CLOSE') ? 'CLOSE' : 'OPEN';
$toCredit  = ($sessionUC === 'OPEN') ? $winAmtO : $winAmtC;

if ($toCredit > 0 && !empty($R['user_id'])) {
  $sub = $bidOP.'|'.$bidCP;
  wallet_win_credit((int)$R['user_id'], (float)$toCredit, 'FS', (int)$R['bid_id'], $sub, $sessionUC);
}


    $pO  = (($rOop === 'Pending' || $rOcp === 'Pending') && $oWait > 0);
    $pC  = (($rCop === 'Pending' || $rCcp === 'Pending') && $cWait > 0);
    $txO = $pO ? ('Pending ⏳ ' . mmss($oWait)) : '';
    $txC = $pC ? ('Pending ⏳ ' . mmss($cWait)) : '';

    $cO   = $pO ? 'pending-time' : (($rOop !== 'Pending' || $rOcp !== 'Pending') ? 'result-now' : '');
    $cC   = $pC ? 'pending-time' : (($rCop !== 'Pending' || $rCcp !== 'Pending') ? 'result-now' : '');
    $rowC = (($rOop !== 'Pending' || $rOcp !== 'Pending' || $rCop !== 'Pending' || $rCcp !== 'Pending')) ? 'resolved-row' : '';

    echo
      '<tr class="'.$rowC.'" data-type="fs" data-id="'.(int)$R['bid_id'].'" data-ts="'.(int)$R['ts'].'" '.
      'data-open-op="'.H($wOop).'" data-open-cp="'.H($wOcp).'" data-close-op="'.H($wCop).'" data-close-cp="'.H($wCcp).'">'.
        '<td>'.H($R['game_name']).'</td>'.
        '<td>'.H($R['g_open_12']).'</td>'.
        '<td>'.H($R['g_close_12']).'</td>'.
        '<td>'.H($R['username']).'</td>'.
        '<td>'.H($R['mobile'] ?: '—').'</td>'.
        '<td>'.H($bidOP).'</td>'.
        '<td>'.H($bidCP).'</td>'.
        '<td>₹'.number_format((float)$R['total_bid_amount'], 2).'</td>'.
        '<td>'.H($R['bid_session']).'</td>'.
        '<td>'.H($wOop ?: '—').'</td>'.
        '<td>'.H($wOcp ?: '—').'</td>'.
        '<td>'.H($wCop ?: '—').'</td>'.
        '<td>'.H($wCcp ?: '—').'</td>'.
        '<td class="'.$cO.'">'.H($pO ? $txO : $rOop).'</td>'.
        '<td class="'.$cO.'">'.H($pO ? $txO : $rOcp).'</td>'.
        '<td class="'.$cC.'">'.H($pC ? $txC : $rCop).'</td>'.
        '<td class="'.$cC.'">'.H($pC ? $txC : $rCcp).'</td>'.
         '<td>'.($winAmtO>0?'₹'.number_format($winAmtO,2):'—').'</td>'.
'<td>'.($winAmtC>0?'₹'.number_format($winAmtC,2):'—').'</td>'.
        '<td>'.H($R['created_fmt']).'</td>'.
      '</tr>';

    $printed = true;
  }

  if (!$printed) {
    echo "<tr><td colspan=20>No rows</td></tr>";
  }
  exit;
}



  echo "<tr><td colspan=20>Bad type</td></tr>"; exit;
}
?>
<!doctype html><html lang="en"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Live — Single/Double/SingleP/TripleP/Jodi/Half S./Full S.</title>
<meta http-equiv="refresh" content="60">
<style>
 body{font:15px system-ui,Arial;margin:16px} .bar{display:flex;gap:8px;align-items:center;margin:6px 0 10px;flex-wrap:wrap}
 .tab{padding:8px 12px;border:1px solid #ddd;background:#f7f7f7;cursor:pointer;border-radius:6px} .tab.active{background:#fff;border-color:#bbb;font-weight:700}
 .btn{padding:8px 12px;border:1px solid #ddd;border-radius:6px;cursor:pointer;background:#f7f7f7} .muted{color:#666;font-size:12px;margin:6px 0 10px}
 table{border-collapse:collapse;width:100%;font-size:14px} th,td{border:1px solid #e3e3e3;padding:6px 8px;white-space:nowrap;text-align:left}
 th{background:#f7f7f7;position:sticky;top:0;z-index:1} tbody tr:nth-child(even){background:#fafafa}
 .new-row{background:#ffe6e6!important;color:#b00000;font-weight:700;animation:flash 1s ease-in-out 3}@keyframes flash{0%{box-shadow:0 0 0 rgba(176,0,0,0)}50%{box-shadow:0 0 10px rgba(176,0,0,.6)}100%{box-shadow:0 0 0 rgba(176,0,0,0)}}
 .pending-time{background:#fff3cd!important;color:#7a5f1a;font-weight:600}.result-now{background:#ffe6e6!important;color:#b00000;font-weight:700}.resolved-row{background:#fff0f0!important}
 #toast{position:fixed;left:50%;transform:translateX(-50%);bottom:14px;background:#111;color:#fff;padding:10px 14px;border-radius:8px;font:13px system-ui;display:none;z-index:9999;box-shadow:0 6px 20px rgba(0,0,0,.25)}
</style></head><body>
<h1>Live — Single/Double/SingleP/TripleP/Jodi/Half S./Full S.</h1>
<div class="bar">
  <button class="tab active" data-type="sd">Single Digit</button>
  <button class="tab" data-type="dp">Double Panna</button>
  <button class="tab" data-type="sp">Single Panna</button>
  <button class="tab" data-type="tp">Triple Panna</button>
  <button class="tab" data-type="jd">Jodi</button>
  <button class="tab" data-type="hs">Half Sangam</button>
  <button class="tab" data-type="fs">Full Sangam</button>
  <button id="soundToggle" class="btn" style="margin-left:auto">🔔 Sound: ON</button>
  <label class="muted" style="display:flex;align-items:center;gap:6px">Vol <input id="vol" type="range" min="0" max="1" step="0.01" value="0.5" style="width:120px"></label>
</div>
<div class="muted" id="status">Loading…</div>
<h2 style="font:700 22px system-ui;margin:8px 0"><span id="label">SD</span> Latest — Open: <span id="openDigit">–</span> | Close: <span id="closeDigit">–</span></h2>
<table><thead id="thead"></thead><tbody id="rows"><tr><td colspan="20">No rows</td></tr></tbody></table>
<div id="toast"></div>
<script>
const POLL=60000,HIGHLIGHT=15000; setInterval(()=>{try{location.reload()}catch(e){}},60000);
const rows=document.getElementById('rows'),head=document.getElementById('thead'),statusEl=document.getElementById('status'),
openEl=document.getElementById('openDigit'),closeEl=document.getElementById('closeDigit'),labelEl=document.getElementById('label'),
toast=document.getElementById('toast'),vol=document.getElementById('vol'),btn=document.getElementById('soundToggle');
let type='sd',last={sd:0,dp:0,sp:0,tp:0,jd:0,hs:0,fs:0},skip={sd:1,dp:1,sp:1,tp:1,jd:1,hs:1,fs:1}; try{last=JSON.parse(localStorage.getItem('lastTs')||JSON.stringify(last))}catch(e){}
const heads = {
  sd: `<tr>
    <th>Game</th><th>Open</th><th>Close</th><th>User</th><th>Mobile</th>
    <th>Digit</th><th>Amt</th><th>Session</th>
    <th>Win # (O)</th><th>Win # (C)</th>
    <th>Result O</th><th>Result C</th>
    <th>Win ₹</th>
    <th>created_at</th>
  </tr>`,

  dp: `<tr>
    <th>Game</th><th>Open</th><th>Close</th><th>User</th><th>Mobile</th>
    <th>Digit</th><th>Amt</th><th>Session</th>
    <th>Win # (O)</th><th>Win # (C)</th>
    <th>Result O</th><th>Result C</th>
    <th>Win ₹</th>
    <th>created_at</th>
  </tr>`,

  sp: `<tr>
    <th>Game</th><th>Open</th><th>Close</th><th>User</th><th>Mobile</th>
    <th>Digit</th><th>Amt</th><th>Session</th>
    <th>Win # (O)</th><th>Win # (C)</th>
    <th>Result O</th><th>Result C</th>
    <th>Win ₹</th>
    <th>created_at</th>
  </tr>`,

  tp: `<tr>
    <th>Game</th><th>Open</th><th>Close</th><th>User</th><th>Mobile</th>
    <th>Digit</th><th>Amt</th><th>Session</th>
    <th>Win # (O)</th><th>Win # (C)</th>
    <th>Result O</th><th>Result C</th>
    <th>Win ₹</th>
    <th>created_at</th>
  </tr>`,

  jd: `<tr>
    <th>Game</th><th>Open</th><th>Close</th><th>User</th><th>Mobile</th>
    <th>Digit</th><th>Amt</th><th>Session</th>
    <th>Win # (O)</th><th>Win # (C)</th>
    <th>Result O</th><th>Result C</th>
    <th>Win ₹</th>
    <th>created_at</th>
  </tr>`,

  /* HS/FS need TWO payout columns (open/close) */
  hs: `<tr>
    <th>Game</th><th>Open</th><th>Close</th><th>User</th><th>Mobile</th>
    <th>Bid OD</th><th>Bid CP</th><th>Amt</th><th>Session</th>
    <th>Win OD (O)</th><th>Win CP (O)</th><th>Win OD (C)</th><th>Win CP (C)</th>
    <th>Res OD (O)</th><th>Res CP (O)</th><th>Res OD (C)</th><th>Res CP (C)</th>
    <th>Win ₹ (O)</th><th>Win ₹ (C)</th>
    <th>created_at</th>
  </tr>`,

  fs: `<tr>
    <th>Game</th><th>Open</th><th>Close</th><th>User</th><th>Mobile</th>
    <th>Bid OP</th><th>Bid CP</th><th>Amt</th><th>Session</th>
    <th>Win OP (O)</th><th>Win CP (O)</th><th>Win OP (C)</th><th>Win CP (C)</th>
    <th>Res OP (O)</th><th>Res CP (O)</th><th>Res OP (C)</th><th>Res CP (C)</th>
    <th>Win ₹ (O)</th><th>Win ₹ (C)</th>
    <th>created_at</th>
  </tr>`
};

function setHead(){head.innerHTML=heads[type];} function setLbl(){labelEl.textContent=type.toUpperCase();}
let next=0,lastUpd=0; setInterval(()=>{if(!next)return;const s=Math.max(0,Math.round((next-Date.now())/1000));statusEl.textContent=`Last update: ${lastUpd?new Date(lastUpd).toLocaleTimeString():'—'} • next in ${s}s`;},1000);
let sound=localStorage.getItem('sound')!=='0',ctx,gain; function setBtn(){btn.textContent=sound?'🔔 Sound: ON':'🔕 Sound: OFF'} setBtn();
function initAudio(){if(!ctx){const C=window.AudioContext||window.webkitAudioContext;ctx=new C();gain=ctx.createGain();gain.gain.value=+vol.value||0.5;gain.connect(ctx.destination);}}
btn.onclick=async()=>{initAudio();sound=!sound;localStorage.setItem('sound',sound?'1':'0');setBtn();if(sound&&ctx.state==='suspended')try{await ctx.resume()}catch(e){}}; // eslint-disable-line
vol.oninput=()=>{if(gain)gain.gain.value=+vol.value}; function beep(f=800,ms=140){if(!sound)return;initAudio();if(!ctx||ctx.state!=='running')return;const o=ctx.createOscillator(),g=ctx.createGain();o.connect(g);g.connect(gain);o.frequency.value=f;g.gain.setValueAtTime(0.0001,ctx.currentTime);g.gain.linearRampToValueAtTime(0.9,ctx.currentTime+0.01);g.gain.exponentialRampToValueAtTime(0.0001,ctx.currentTime+ms/1000);o.start();o.stop(ctx.currentTime+ms/1000+0.02);}
function toastMsg(s){toast.textContent=s;toast.style.display='block';setTimeout(()=>toast.style.display='none',3000);}
function notify(tag,od,cd,id){document.title=`${tag}: new #${id}`;toastMsg(`${tag} new entry`);beep(700,130);setTimeout(()=>beep(520,130),180);setTimeout(()=>beep(420,160),360);}
function hiNew(lastTs){const trs=rows.querySelectorAll('tr[data-ts]');let max=lastTs,any=false;trs.forEach(tr=>{const ts=+tr.dataset.ts||0;if(ts>lastTs){tr.classList.add('new-row');any=true;if(ts>max)max=ts;setTimeout(()=>tr.classList.remove('new-row'),HIGHLIGHT);}});return {any,max};}
function sortRows(){[...rows.querySelectorAll('tr[data-ts]')].sort((a,b)=>{const tb=+b.dataset.ts||0,ta=+a.dataset.ts||0;return tb-ta||(b.dataset.id||'').localeCompare(a.dataset.id||'')}).forEach(tr=>rows.appendChild(tr));}
async function refresh(){
  try{statusEl.textContent='Refreshing…'; const r=await fetch(`<?php echo basename(__FILE__); ?>?ajax=1&type=${type}`,{cache:'no-store'}); const html=await r.text();
    rows.innerHTML=html||'<tr><td colspan=20>No rows</td></tr>'; sortRows(); lastUpd=Date.now(); next=lastUpd+POLL;
    const first=rows.querySelector('tr[data-id]'); if(!first){openEl.textContent=closeEl.textContent='–';return;}
    if(type==='hs'){openEl.textContent=`OD: ${first.dataset.openOd||'–'} | CP: ${first.dataset.openCp||'–'}`; closeEl.textContent=`OD: ${first.dataset.closeOd||'–'} | CP: ${first.dataset.closeCp||'–'}`;}
    else if(type==='fs'){openEl.textContent=`OP: ${first.dataset.openOp||'–'} | CP: ${first.dataset.openCp||'–'}`; closeEl.textContent=`OP: ${first.dataset.closeOp||'–'} | CP: ${first.dataset.closeCp||'–'}`;}
    else {openEl.textContent=(first.dataset.openDigit??'')||'–'; closeEl.textContent=(first.dataset.closeDigit??'')||'–';}
    const lastTs=last[type]||0; if(skip[type]){last[type]=+first.dataset.ts||Date.now()/1000|0; localStorage.setItem('lastTs',JSON.stringify(last)); skip[type]=0;}
    else {const {any,max}=hiNew(lastTs); if(any){notify(type.toUpperCase(),openEl.textContent,closeEl.textContent,first.dataset.id||'?'); last[type]=max; localStorage.setItem('lastTs',JSON.stringify(last));}}
  }catch(e){console.error(e);statusEl.textContent='Error… retrying'; next=Date.now()+POLL;}
}
document.addEventListener('visibilitychange',()=>{if(!document.hidden)refresh()}); window.addEventListener('focus',refresh);
function setAll(){setHead();setLbl();} setAll(); refresh(); setInterval(refresh,POLL);
document.querySelectorAll('.tab').forEach(b=>b.onclick=()=>{document.querySelectorAll('.tab').forEach(x=>x.classList.remove('active')); b.classList.add('active'); type=b.dataset.type; skip[type]=1; setAll(); refresh();});
</script>
</body></html>
