<?php
// trs_api.php — auto-refresh viewer powered by api_trs.php (10s polling, newest-first).
(isset($_GET['debug']) ? ini_set('display_errors', 1) : ini_set('display_errors', 0));
error_reporting(E_ALL);
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate, max-age=0">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Live — SD / DP (API)</title>
<style>
  body { font-family: system-ui, Arial, sans-serif; margin:16px }
  .bar { display:flex; gap:8px; align-items:center; margin:8px 0 12px; flex-wrap:wrap }
  .tab { padding:8px 12px; border:1px solid #ddd; background:#f7f7f7; cursor:pointer; border-radius:6px }
  .tab.active { background:#fff; border-color:#bbb; font-weight:700 }
  .btn { padding:8px 12px; border:1px solid #ddd; border-radius:6px; cursor:pointer; background:#f7f7f7 }
  .muted { color:#666; font-size:12px }
  table { border-collapse: collapse; width:100%; font-size:14px }
  th,td { border:1px solid #e3e3e3; padding:6px 8px; text-align:left }
  th { background:#f7f7f7; position: sticky; top:0; z-index:1 }
  tbody tr:nth-child(even){ background:#fafafa }
  .new-row { background:#ffe6e6 !important; color:#b00000; font-weight:700; }
  #toast { position:fixed; left:50%; transform:translateX(-50%); bottom:14px; background:#111; color:#fff; padding:10px 14px; border-radius:8px; font:13px system-ui; display:none; z-index:9999 }
  .input { padding:6px 8px; border:1px solid #ddd; border-radius:6px }
</style>
</head>
<body>
  <h1>Live — Single Digit / Double Panna (API)</h1>

  <div class="bar">
    <button class="tab active" data-type="sd">Single Digit</button>
    <button class="tab" data-type="dp">Double Panna</button>

    <label class="muted" style="display:flex;align-items:center;gap:6px;margin-left:12px;">
      Username <input id="uname" class="input" placeholder="(optional)" style="width:160px">
    </label>
    <button id="applyUser" class="btn">Apply</button>

    <button id="soundToggle" class="btn" style="margin-left:auto">🔕 Sound: OFF</button>
    <label class="muted" style="display:flex;align-items:center;gap:6px">
      Vol <input id="vol" type="range" min="0" max="1" step="0.01" value="0.5" style="width:120px">
    </label>
  </div>

  <div class="muted" id="status">Loading…</div>

  <h2 style="font:700 22px system-ui;margin:8px 0">
    <span id="label">SD</span> Latest — Open: <span id="openDigit">–</span> | Close: <span id="closeDigit">–</span>
  </h2>

  <table>
    <thead id="thead"></thead>
    <tbody id="rows"><tr><td>Loading…</td></tr></tbody>
  </table>

  <div id="toast"></div>

<script>
const API_URL = 'api_trs.php';
const POLL_MS = 10000, HIGHLIGHT_MS = 15000;

const rowsEl = document.getElementById('rows');
const headEl = document.getElementById('thead');
const statusEl = document.getElementById('status');
const openEl = document.getElementById('openDigit');
const closeEl = document.getElementById('closeDigit');
const labelEl = document.getElementById('label');
const soundBtn = document.getElementById('soundToggle');
const volEl = document.getElementById('vol');
const unameInput = document.getElementById('uname');
const applyUserBtn = document.getElementById('applyUser');
const toastEl = document.getElementById('toast');

let currentType = 'sd';
let usernameFilter = new URLSearchParams(location.search).get('username') || '';
unameInput.value = usernameFilter;

let nextRefreshAt = 0, lastUpdatedAt = 0;
let lastSeen = { sd:0, dp:0 };  // tracked per tab + username (we’ll key with uname)
let skipFirst = { sd:true, dp:true };

function storageKey(tab){ return `api_lastSeen_${tab}_${usernameFilter||'-'}`; }
function loadLastSeen(){ const v = localStorage.getItem(storageKey(currentType)); if (v) lastSeen[currentType]=+v||0; }
function saveLastSeen(){ localStorage.setItem(storageKey(currentType), String(lastSeen[currentType]||0)); }

const heads = {
  sd: `<tr>
        <th>id</th><th>user_id</th><th>username</th><th>game_id</th><th>bid_details</th>
        <th>total_bid_amount</th><th>created_at</th><th>game_name</th>
        <th>bid_session</th><th>winning_open_time_sd</th><th>winning_close_time_sd</th>
      </tr>`,
  dp: `<tr>
        <th>id</th><th>user_id</th><th>username</th><th>game_id</th><th>bid_details</th>
        <th>total_bid_amount</th><th>created_at</th><th>game_name</th>
        <th>bid_session</th><th>winning_open_time_dp</th><th>winning_close_time_dp</th>
      </tr>`
};
function setHead(){ headEl.innerHTML = heads[currentType]; }
function setLabel(){ labelEl.textContent = currentType.toUpperCase(); }
function showToast(msg){ toastEl.textContent=msg; toastEl.style.display='block'; setTimeout(()=>toastEl.style.display='none',3000); }

async function askNotif(){ if ('Notification' in window && Notification.permission==='default') { try { await Notification.requestPermission(); } catch {} } }
function notify(tag, od, cd, id){
  if ('Notification' in window && Notification.permission==='granted') {
    new Notification(`${tag} new entry`, { body:`#${id} — Open: ${od??'—'} | Close: ${cd??'—'}`, icon:'/favicon.ico', tag:`live-${tag}` });
  }
  document.title = `${tag}: new #${id} (${od??'•'}/${cd??'•'})`;
  showToast(`${tag} new #${id} (O:${od??'—'} / C:${cd??'—'})`);
}

// sound
let soundEnabled = (localStorage.getItem('soundEnabled') ?? '1')==='1';
let audioCtx=null, gain=null;
function setSoundLabel(){ soundBtn.textContent = soundEnabled ? '🔔 Sound: ON' : '🔕 Sound: OFF'; }
function initAudio(){ if (!audioCtx) { const Ctx = window.AudioContext||window.webkitAudioContext; audioCtx=new Ctx(); gain=audioCtx.createGain(); gain.gain.value=+volEl.value||0.5; gain.connect(audioCtx.destination); } }
async function toggleSound(){ initAudio(); soundEnabled=!soundEnabled; localStorage.setItem('soundEnabled', soundEnabled?'1':'0'); setSoundLabel(); if (soundEnabled && audioCtx.state==='suspended') { try { await audioCtx.resume(); } catch {} } }
soundBtn.addEventListener('click', toggleSound);
volEl.addEventListener('input', ()=>{ if (gain) gain.gain.value=+volEl.value; });
function beep(f=880,ms=140){ if(!soundEnabled) return; initAudio(); if(!audioCtx || audioCtx.state!=='running') return; const o=audioCtx.createOscillator(), g=audioCtx.createGain(); o.type='sine'; o.frequency.value=f; o.connect(g); g.connect(gain); const t=audioCtx.currentTime; g.gain.setValueAtTime(0.0001,t); g.gain.linearRampToValueAtTime(0.9,t+0.01); g.gain.exponentialRampToValueAtTime(0.0001,t+ms/1000); o.start(t); o.stop(t+ms/1000+0.02); }
function alertSound(kind){ if(!soundEnabled) return; if(kind==='dp'){ beep(700,130); setTimeout(()=>beep(520,130),180); setTimeout(()=>beep(420,160),360); } else { beep(900,120); setTimeout(()=>beep(660,120),180); } }

// countdown
setInterval(()=>{ if(!nextRefreshAt) return; const now=Date.now(); const secs=Math.max(0, Math.round((nextRefreshAt-now)/1000)); const last= lastUpdatedAt? new Date(lastUpdatedAt).toLocaleTimeString() : '—'; statusEl.textContent=`Last update: ${last} • next in ${secs}s`; },1000);

function trFromRow(r){
  const tr=document.createElement('tr');
  tr.dataset.id=r.id; tr.dataset.ts=r.ts;
  tr.dataset.openDigit=r.w_open??''; tr.dataset.closeDigit=r.w_close??'';
  tr.innerHTML = `
    <td>${r.id}</td><td>${r.user_id}</td><td>${r.username??''}</td>
    <td>${r.game_id}</td><td>${escapeHtml(r.bid_details??'')}</td>
    <td>${Number(r.total_bid_amount).toFixed(2)}</td>
    <td>${r.created_at??''}</td><td>${escapeHtml(r.game_name??'')}</td>
    <td>${r.bid_session??''}</td><td>${r.w_open??''}</td><td>${r.w_close??''}</td>
  `;
  return tr;
}
function escapeHtml(s){ return String(s).replace(/[&<>"]/g,c=>({ '&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;' }[c])); }
function sortNewest(){ [...rowsEl.querySelectorAll('tr[data-id]')].sort((a,b)=>{ const tb=+b.dataset.ts||0, ta=+a.dataset.ts||0; if(tb!==ta) return tb-ta; return (+b.dataset.id||0)-(+a.dataset.id||0);} ).forEach(tr=>rowsEl.appendChild(tr)); }
function highlightNew(sinceId){ let any=false, max=sinceId; rowsEl.querySelectorAll('tr[data-id]').forEach(tr=>{ const id=+tr.dataset.id||0; if(id>sinceId){ tr.classList.add('new-row'); any=true; if(id>max) max=id; setTimeout(()=>tr.classList.remove('new-row'), HIGHLIGHT_MS);} }); return {any,max}; }

async function fetchAndRender() {
  try {
    statusEl.textContent='Refreshing…';
    const since = lastSeen[currentType] || 0;
    const qs = new URLSearchParams({ type: currentType, limit: '200', order:'desc' });
    if (usernameFilter) qs.set('username', usernameFilter);
    if (since>0) qs.set('since_id', String(since));
    const r = await fetch(`${API_URL}?${qs}`, { cache:'no-store' });
    const data = await r.json();

    // First load: if table empty, render all rows
    if (rowsEl.children.length===1 && rowsEl.firstElementChild && !rowsEl.firstElementChild.dataset) rowsEl.innerHTML='';

    if (Array.isArray(data.rows) && data.rows.length) {
      // insert new rows
      data.rows.forEach(row => rowsEl.insertBefore(trFromRow(row), rowsEl.firstChild));
    } else if (rowsEl.children.length===0) {
      rowsEl.innerHTML = '<tr><td colspan="11">No rows</td></tr>';
    }

    sortNewest();

    const first = rowsEl.querySelector('tr[data-id]');
    if (first) {
      const id=+first.dataset.id||0, od=first.dataset.openDigit||null, cd=first.dataset.closeDigit||null;
      openEl.textContent = (od===''||od==='null')?'–':od;
      closeEl.textContent= (cd===''||cd==='null')?'–':cd;

      if (skipFirst[currentType]) {
        lastSeen[currentType]=id; saveLastSeen(); skipFirst[currentType]=false;
      } else if (data.rows && data.rows.length) {
        const {any,max}=highlightNew(lastSeen[currentType]||0);
        if (any) { notify(currentType.toUpperCase(), od, cd, id); alertSound(currentType); lastSeen[currentType]=max; saveLastSeen(); }
      }
    }

    lastUpdatedAt = Date.now();
    nextRefreshAt = lastUpdatedAt + POLL_MS;
  } catch (e) {
    console.error(e);
    nextRefreshAt = Date.now() + POLL_MS;
    statusEl.textContent='Error updating. Will retry…';
  }
}

function tick(){ fetchAndRender(); }
function setHead(){ headEl.innerHTML = heads[currentType]; }
function setLabel(){ labelEl.textContent = currentType.toUpperCase(); }

// events
document.querySelectorAll('.tab').forEach(btn=>{
  btn.addEventListener('click', ()=>{
    document.querySelectorAll('.tab').forEach(b=>b.classList.remove('active'));
    btn.classList.add('active');
    currentType = btn.dataset.type;
    setHead(); setLabel();
    // reset first-load baseline per tab+username
    lastSeen[currentType]=+(localStorage.getItem(storageKey(currentType))||0);
    skipFirst[currentType]=true;
    rowsEl.innerHTML=''; // clear table for clean load
    fetchAndRender();
  });
});
applyUserBtn.addEventListener('click', ()=>{
  usernameFilter = unameInput.value.trim();
  // reset per-username storage + view
  lastSeen={sd:0,dp:0}; skipFirst={sd:true,dp:true};
  rowsEl.innerHTML='';
  fetchAndRender();
  const url = new URL(location.href); if (usernameFilter) url.searchParams.set('username', usernameFilter); else url.searchParams.delete('username'); history.replaceState(null,'',url.toString());
});

document.addEventListener('visibilitychange', ()=>{ if (!document.hidden) fetchAndRender(); });
window.addEventListener('focus', fetchAndRender);

// boot
askNotif();
setSoundLabel();
setHead(); setLabel();
loadLastSeen();
fetchAndRender();
setInterval(tick, POLL_MS);
</script>
</body>
</html>
