<?php
// update_cache_cron.php — build SD/DP caches every 5s for ~55s (shared hosting friendly)
ini_set('display_errors', 0);
error_reporting(E_ALL);
set_time_limit(0);
date_default_timezone_set('Asia/Kolkata');

$BASE = __DIR__;

// ---- db.php (must create $conn = new mysqli(...)) ----
$DB_FILE = $BASE . '/db.php';
if (!is_file($DB_FILE)) {
  @mkdir($BASE.'/logs', 0775, true);
  @file_put_contents($BASE.'/logs/cron_boot.log', date('c')." db.php missing\n", FILE_APPEND);
  exit(0);
}
require $DB_FILE; // $conn (mysqli)

// ---- dirs / lock / log ----
$CACHE_DIR = $BASE . '/cache';
$LOG_DIR   = $BASE . '/logs';
@is_dir($CACHE_DIR) || @mkdir($CACHE_DIR, 0775, true);
@is_dir($LOG_DIR)   || @mkdir($LOG_DIR,   0775, true);
$LOCK_FILE = $BASE . '/update_cache_cron.lock';
$LOG_FILE  = $LOG_DIR . '/update_cache_cron.log';

// single instance so overlapping crons don't fight
$lock = @fopen($LOCK_FILE, 'c');
if (!$lock || !@flock($lock, LOCK_EX | LOCK_NB)) exit(0);

function log_line($msg){global $LOG_FILE; @file_put_contents($LOG_FILE, date('Y-m-d H:i:s')." $msg\n", FILE_APPEND);}

function build_cache(mysqli $conn, string $type, string $file){
  // map table/cols
  if ($type === 'dp') {
    $table='user_bids_dp'; $openCol='winning_open_time_dp'; $closeCol='winning_close_time_dp';
  } else {
    $type='sd'; $table='user_bids'; $openCol='winning_open_time_sd'; $closeCol='winning_close_time_sd';
  }

  // JOIN users_data to get username
  $sql = "SELECT b.id, b.user_id, u.username,
                 b.game_id, b.bid_details, b.total_bid_amount, b.created_at,
                 b.game_name, b.bid_session, {$openCol} AS w_open, {$closeCol} AS w_close
          FROM {$table} b
          LEFT JOIN users_data u ON u.user_id = b.user_id
          ORDER BY b.id DESC
          LIMIT 200";

  $rows = [];
  if ($res = $conn->query($sql)) { while ($r=$res->fetch_assoc()) $rows[]=$r; $res->free(); }
  else { log_line("SQL error ($type): ".$conn->error); }

  if (!$rows) {
    $html = '<tr><td colspan="11">No rows</td></tr>';
  } else {
    $html = '';
    foreach ($rows as $r) {
      $html .= '<tr data-type="'.$type.'" data-id="'.(int)$r['id']
            .  '" data-open-digit="'.htmlspecialchars((string)$r['w_open'])
            .  '" data-close-digit="'.htmlspecialchars((string)$r['w_close']).'">'
            .  '<td>'.(int)$r['id'].'</td>'
            .  '<td>'.(int)$r['user_id'].'</td>'
            .  '<td>'.htmlspecialchars((string)($r['username'] ?? '')).'</td>'
            .  '<td>'.(int)$r['game_id'].'</td>'
            .  '<td>'.htmlspecialchars($r['bid_details']).'</td>'
            .  '<td>'.htmlspecialchars($r['total_bid_amount']).'</td>'
            .  '<td>'.htmlspecialchars($r['created_at']).'</td>'
            .  '<td>'.htmlspecialchars($r['game_name']).'</td>'
            .  '<td>'.htmlspecialchars($r['bid_session']).'</td>'
            .  '<td>'.htmlspecialchars($r['w_open']).'</td>'
            .  '<td>'.htmlspecialchars($r['w_close']).'</td>'
            .  '</tr>';
    }
  }

  $tmp = $file.'.tmp';
  @file_put_contents($tmp, $html, LOCK_EX);
  @rename($tmp, $file); // atomic swap
}

for ($i=0; $i<11; $i++) {
  if (!@$conn->ping()) { @mysqli_close($conn); require $DB_FILE; } // reconnect if needed
  build_cache($conn, 'sd', $CACHE_DIR.'/user_bids_rows_sd.html');
  build_cache($conn, 'dp', $CACHE_DIR.'/user_bids_rows_dp.html');
  log_line("wrote caches (iter ".($i+1).")");
  if ($i<10) sleep(5);
}
