<?php
// Sai/verify_otp.php

ini_set('display_errors','1');
ini_set('display_startup_errors','1');
error_reporting(E_ALL);

header('Content-Type: application/json; charset=UTF-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');

require_once __DIR__ . '/sms_helper.php';

try {
    $data   = json_decode(file_get_contents('php://input'), true);
    $mobile = trim($data['mobile'] ?? '');
    $otp    = trim($data['otp']    ?? '');

    if (!preg_match('/^[6-9]\d{9}$/', $mobile) || !preg_match('/^\d{4}$/', $otp)) {
        throw new Exception('Invalid mobile or OTP format');
    }

    $dbg = [];
    if (verifySmsOtp($mobile, $otp, $dbg)) {
        echo json_encode(['status'=>'success','message'=>'OTP verified']);
    } else {
        throw new Exception('OTP verification failed');
    }
} catch (Exception $e) {
    http_response_code(401);
    echo json_encode([
        'status'  => 'error',
        'message' => $e->getMessage()
    ]);
}
