<?php
require __DIR__ . '/_bootstrap.php';

file_put_contents('log.txt', file_get_contents('php://input'));


// 1) read payload (IMB webhook data)
$raw = file_get_contents('php://input');
$form = $_POST;
$json = json_decode($raw, true);
$incoming = (is_array($json) && $json) ? $json : $form;

// log webhook data for debugging
@file_put_contents(IMB_LOG_FILE, date('c') . " RAW:$raw\nFORM:" . print_r($form, true) . "\n", FILE_APPEND);

// 2) (optional) security check — enable only if IMB supports a secret header
/*
if (empty($_SERVER['HTTP_X_SECRET']) || $_SERVER['HTTP_X_SECRET'] !== 'YOUR_SECRET_KEY') {
    http_response_code(403);
    echo 'Forbidden';
    exit;
}
*/

// 3) get order id
$orderId = '';
foreach (['order_id','orderId','orderid','ORDER_ID'] as $k) {
    if (!empty($incoming[$k])) { 
        $orderId = (string)$incoming[$k]; 
        break; 
    }
}
if ($orderId === '') { 
    http_response_code(400); 
    echo 'Missing order_id'; 
    exit; 
}

// 4) load order from database
$stmt = $conn->prepare("SELECT id,mobile,amount,status FROM wallet_orders WHERE order_id=? LIMIT 1");
$stmt->bind_param('s', $orderId);
$stmt->execute(); 
$stmt->bind_result($rowId, $mobile, $orderAmt, $curStatus);
if (!$stmt->fetch()) { 
    $stmt->close(); 
    echo 'NOT_FOUND'; 
    exit; 
}
$stmt->close();

// ignore if already processed
if (in_array($curStatus, ['SUCCESS','FAILED'], true)) { 
    echo 'OK'; 
    exit; 
}

// 5) use webhook data directly (no double-check)
$data = $incoming;
$upper = strtoupper(json_encode($data));

// 6) detect success/fail
$success = (strpos($upper,'"STATUS":"SUCCESS"')!==false)
        || (strpos($upper,'"PAYMENT_STATUS":"SUCCESS"')!==false)
        || (strpos($upper,'"TXNSTATUS":"SUCCESS"')!==false)
        || (strpos($upper,'"TXNSTATUS":"COMPLETED"')!==false)
        || (strpos($upper,'STATUS=SUCCESS')!==false)
        || (strpos($upper,'TXNSTATUS=COMPLETED')!==false);

$failed  = (strpos($upper,'"STATUS":"FAILED"')!==false)
        || (strpos($upper,'"PAYMENT_STATUS":"FAILED"')!==false)
        || (strpos($upper,'"TXNSTATUS":"FAILED"')!==false)
        || (strpos($upper,'"CANCELLED"')!==false)
        || (strpos($upper,'"REVERSED"')!==false);

// extract UTR
$utr = null;
if (!empty($data['result']) && is_array($data['result'])) {
    $r = $data['result'];
    $utr = $r['utr'] ?? ($r['bank_rrn'] ?? ($r['rrn'] ?? null));
}

// 7) process success
if ($success) {
    $conn->begin_transaction();
    try {
        $gp = json_encode($data, JSON_UNESCAPED_UNICODE);
        $stmt = $conn->prepare("UPDATE wallet_orders SET status='SUCCESS', utr=?, gateway_payload=?, updated_at=NOW() WHERE id=?");
        $stmt->bind_param('ssi', $utr, $gp, $rowId);
        $stmt->execute(); 
        $stmt->close();

        // credit user wallet
        $userId = getUserIdByMobile($conn, $mobile);
        if ($userId !== null) { 
            creditWallet($conn, $userId, (float)$orderAmt); 
        }

        $conn->commit();
        echo 'OK';
    } catch (Throwable $e) {
        $conn->rollback();
        @file_put_contents(IMB_LOG_FILE, "ERROR: " . $e->getMessage() . "\n", FILE_APPEND);
        echo 'ERROR';
    }
    exit;
}

// 8) process failure
if ($failed) {
    $gp = json_encode($data, JSON_UNESCAPED_UNICODE);
    $stmt = $conn->prepare("UPDATE wallet_orders SET status='FAILED', gateway_payload=?, updated_at=NOW() WHERE id=?");
    $stmt->bind_param('si', $gp, $rowId);
    $stmt->execute(); 
    $stmt->close();
    echo 'FAIL';
    exit;
}

// 9) if still not success or failed
echo 'PENDING';
exit;
?>
