<?php
// websocket-server.php
header('Content-Type: text/event-stream');
header('Cache-Control: no-cache');
header('Connection: keep-alive');
header('Access-Control-Allow-Origin: *');

// Prevent timeout
set_time_limit(0);
ini_set('auto_detect_line_endings', 1);

require_once __DIR__ . '/db.php';

$filter_date = $_GET['filter_date'] ?? date('Y-m-d');
$lastCheck = time();

// Function to get current results count
function getCurrentResultsHash($conn, $filter_date) {
    $sql = "SELECT COUNT(*) as count, MAX(created_at) as last_update 
            FROM user_bids 
            WHERE DATE(created_at) = ?";
    
    $stmt = $conn->prepare($sql);
    $stmt->bind_param('s', $filter_date);
    $stmt->execute();
    $result = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    
    return md5($result['count'] . $result['last_update']);
}

$lastHash = '';

while (true) {
    $currentHash = getCurrentResultsHash($conn, $filter_date);
    
    if ($currentHash !== $lastHash) {
        // Data changed, send update signal
        echo "event: update\n";
        echo "data: " . json_encode([
            'timestamp' => time(),
            'hash' => $currentHash,
            'filter_date' => $filter_date
        ]) . "\n\n";
        
        $lastHash = $currentHash;
    } else {
        // Send heartbeat
        echo "event: heartbeat\n";
        echo "data: " . json_encode(['timestamp' => time()]) . "\n\n";
    }
    
    ob_flush();
    flush();
    
    // Check every 2 seconds
    sleep(2);
    
    // Break if connection is closed
    if (connection_aborted()) break;
}

$conn->close();
?>