<?php
// Include database connection
include('db.php');

// Fetch the withdrawal requests with related bank details and wallet balance
$sql = "SELECT withdrawal_requests.id, withdrawal_requests.user_id, users_data.username, withdrawal_requests.amount, withdrawal_requests.status, withdrawal_requests.created_at, 
        bank_details.holder_name, bank_details.bank_name, bank_details.account_no, bank_details.ifsc, 
        wallet.balance 
        FROM withdrawal_requests
        JOIN bank_details ON withdrawal_requests.user_id = bank_details.user_id
        JOIN users_data ON withdrawal_requests.user_id = users_data.user_id
        JOIN wallet ON withdrawal_requests.user_id = wallet.user_id
        ORDER BY withdrawal_requests.created_at DESC";

$result = mysqli_query($conn, $sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Withdrawal Requests</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body>
    <div class="container mt-5">
        <h2>Withdrawal Requests</h2>

        <!-- Filter Date Range -->
        <form method="GET" action="">
            <div class="row mb-4">
                <div class="col-md-4">
                    <label for="start_date" class="form-label">Start Date</label>
                    <input type="text" class="form-control" id="start_date" name="start_date" placeholder="dd-mm-yyyy">
                </div>
                <div class="col-md-4">
                    <label for="end_date" class="form-label">End Date</label>
                    <input type="text" class="form-control" id="end_date" name="end_date" placeholder="dd-mm-yyyy">
                </div>
                <div class="col-md-4">
                    <label for="filter_button" class="form-label">Filter</label>
                    <button type="submit" class="btn btn-primary w-100" id="filter_button">Filter</button>
                </div>
            </div>
        </form>

        <!-- Table -->
        <table class="table table-striped">
            <thead>
                <tr>
                    <th>#</th>
                    <th>User ID</th>
                    <th>Holder Name</th>
                    <th>Bank</th>
                    <th>Account No</th>
                    <th>IFSC Code</th>
                    <th>Amount</th>
                    <th>Wallet Balance</th>
                    <th>Status</th>
                    <th>Date</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if (mysqli_num_rows($result) > 0) {
                    while ($row = mysqli_fetch_assoc($result)) {
                        echo '<tr>';
                        echo '<td>' . $row['id'] . '</td>';
                        echo '<td>' . $row['user_id'] . '</td>';
                        echo '<td>' . $row['holder_name'] . '</td>';
                        echo '<td>' . $row['bank_name'] . '</td>';
                        echo '<td>' . $row['account_no'] . '</td>';
                        echo '<td>' . $row['ifsc'] . '</td>';
                        echo '<td>' . '₹' . $row['amount'] . '</td>';
                        echo '<td>' . '₹' . $row['balance'] . '</td>';
                        echo '<td><span class="badge bg-warning text-dark">' . $row['status'] . '</span></td>';
                        echo '<td>' . $row['created_at'] . '</td>';
                        echo '<td>
                                <button class="btn btn-danger delete-btn" data-id="' . $row['id'] . '">Delete</button>
                                <select class="form-select status-dropdown" data-id="' . $row['id'] . '">
                                    <option value="pending"' . ($row['status'] == 'Pending' ? ' selected' : '') . '>Pending</option>
                                    <option value="completed"' . ($row['status'] == 'Completed' ? ' selected' : '') . '>Completed</option>
                                </select>
                            </td>';
                        echo '</tr>';
                    }
                } else {
                    echo '<tr><td colspan="11" class="text-center">No records found</td></tr>';
                }
                ?>
            </tbody>
        </table>
    </div>

    <script>
        // Handle status change
        $(document).on('change', '.status-dropdown', function() {
            var status = $(this).val();
            var id = $(this).data('id');
            $.ajax({
                url: 'update_status.php',
                type: 'POST',
                data: {id: id, status: status},
                success: function(response) {
                    alert('Status updated successfully');
                    location.reload(); // Refresh the page
                }
            });
        });

        // Handle delete request
        $(document).on('click', '.delete-btn', function() {
            var id = $(this).data('id');
            var confirmDelete = confirm('Are you sure you want to delete this withdrawal request?');
            if (confirmDelete) {
                $.ajax({
                    url: 'delete_withdrawal.php',
                    type: 'POST',
                    data: {id: id},
                    success: function(response) {
                        alert('Record deleted successfully');
                        location.reload(); // Refresh the page
                    }
                });
            }
        });
    </script>
</body>
</html>
