<?php
// withdraw_api.php — handle withdrawal & save bank details

header('Content-Type: application/json; charset=utf-8');
error_reporting(0);
require __DIR__.'/db.php';
$conn->set_charset('utf8mb4');

// 1) parse request
$in = json_decode(file_get_contents('php://input'), true);
$mobile = trim($in['mobile'] ?? '');
$amount = floatval($in['amount'] ?? 0);
$method = trim($in['method'] ?? '');

if (!preg_match('/^\d{10}$/',$mobile) || $amount<=0 || !$method) {
  http_response_code(400);
  exit(json_encode(['status'=>false,'message'=>'Invalid input']));
}

// 2) lookup user
$stmt = $conn->prepare("SELECT user_id FROM users_data WHERE mobile=? LIMIT 1");
$stmt->bind_param('s',$mobile); $stmt->execute(); $stmt->bind_result($uid);
if (!$stmt->fetch()) {
  http_response_code(404);
  exit(json_encode(['status'=>false,'message'=>'User not found']));
}
$stmt->close();

// 3) fetch & lock wallet
$stmt = $conn->prepare("SELECT balance FROM wallet WHERE user_id=? FOR UPDATE");
$stmt->bind_param('i',$uid); $stmt->execute(); $stmt->bind_result($bal);
$stmt->fetch(); $stmt->close();
if ($amount > $bal) {
  http_response_code(400);
  exit(json_encode(['status'=>false,'message'=>'Insufficient balance']));
}

// 4) If bank method, upsert bank details
$bank_id = null;
if ($method==='Bank Account') {
  $h = trim($in['holder_name'] ?? '');
  $b = trim($in['bank_name']   ?? '');
  $a = trim($in['account_no']  ?? '');
  $i = trim($in['ifsc']        ?? '');
  if (!$h||!$b||!$a||!$i) {
    http_response_code(400);
    exit(json_encode(['status'=>false,'message'=>'Incomplete bank data']));
  }

  // insert or update
  $stmt = $conn->prepare("
    INSERT INTO bank_details
      (user_id, holder_name, bank_name, account_no, ifsc)
    VALUES (?,?,?,?,?)
    ON DUPLICATE KEY UPDATE
      holder_name=VALUES(holder_name),
      bank_name=VALUES(bank_name),
      account_no=VALUES(account_no),
      ifsc=VALUES(ifsc)
  ");
  $stmt->bind_param('issss',$uid,$h,$b,$a,$i);
  $stmt->execute();
  $bank_id = $stmt->insert_id ?: $conn->insert_id;
  $stmt->close();
}

// 5) Record withdrawal request
$stmt = $conn->prepare("
  INSERT INTO withdrawal_requests
    (user_id, method, amount, bank_detail_id, created_at, status)
  VALUES (?,?,?,?,NOW(),'pending')
");
$stmt->bind_param('isdi',$uid,$method,$amount,$bank_id);
$stmt->execute();
$stmt->close();

// 6) Debit wallet
$stmt = $conn->prepare("UPDATE wallet SET balance=balance-? WHERE user_id=?");
$stmt->bind_param('di',$amount,$uid);
$stmt->execute();
$stmt->close();

$newBal = $bal - $amount;
echo json_encode([
  'status'=>true,
  'message'=>"Withdrawal ₹{$amount} requested via {$method}.",
  'data'=>['wallet_balance'=>$newBal]
]);
exit;
