<?php
session_start();
include 'db.php';

// Check if admin is logged in
if (!isset($_SESSION['admin_id'])) {
    header("Location: login.php");
    exit();
}

$admin = $conn->query("SELECT * FROM admins WHERE id = {$_SESSION['admin_id']}")->fetch_assoc();

// Get Statistics
$total_employees = $conn->query("SELECT COUNT(*) as count FROM users")->fetch_assoc()['count'];
$active_employees = $conn->query("SELECT COUNT(*) as count FROM users WHERE status='active'")->fetch_assoc()['count'];
$inactive_employees = $conn->query("SELECT COUNT(*) as count FROM users WHERE status='inactive'")->fetch_assoc()['count'];
$today_registered = $conn->query("SELECT COUNT(*) as count FROM users WHERE DATE(created_at) = CURDATE()")->fetch_assoc()['count'];

// Get Recent Employees
$recent_employees = $conn->query("SELECT * FROM users ORDER BY id DESC LIMIT 5");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - Employee Management System</title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    
    <style>
        * { font-family: 'Inter', sans-serif !important; }
        
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 30px 20px;
        }
        
        .dashboard-wrapper {
            max-width: 1600px;
            margin: 0 auto;
        }
        
        .top-header {
            background: white;
            padding: 30px 40px;
            border-radius: 24px;
            margin-bottom: 30px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .top-header h1 {
            font-size: 2rem;
            font-weight: 800;
            color: #1a1a1a;
            margin: 0;
        }
        
        .admin-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .admin-avatar {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 800;
            font-size: 1.2rem;
        }
        
        .admin-details h6 {
            margin: 0;
            font-weight: 700;
            color: #1a1a1a;
        }
        
        .admin-details p {
            margin: 0;
            font-size: 0.85rem;
            color: #64748b;
            font-weight: 600;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 25px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background: white;
            padding: 35px;
            border-radius: 20px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
            transition: 0.3s;
            position: relative;
            overflow: hidden;
        }
        
        .stat-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 5px;
            height: 100%;
        }
        
        .stat-card.primary::before { background: linear-gradient(180deg, #667eea 0%, #764ba2 100%); }
        .stat-card.success::before { background: linear-gradient(180deg, #10b981 0%, #059669 100%); }
        .stat-card.warning::before { background: linear-gradient(180deg, #f59e0b 0%, #d97706 100%); }
        .stat-card.danger::before { background: linear-gradient(180deg, #ef4444 0%, #dc2626 100%); }
        
        .stat-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 20px 60px rgba(0,0,0,0.15);
        }
        
        .stat-icon {
            width: 70px;
            height: 70px;
            border-radius: 16px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2rem;
            margin-bottom: 20px;
        }
        
        .stat-card.primary .stat-icon { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; }
        .stat-card.success .stat-icon { background: linear-gradient(135deg, #10b981 0%, #059669 100%); color: white; }
        .stat-card.warning .stat-icon { background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); color: white; }
        .stat-card.danger .stat-icon { background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%); color: white; }
        
        .stat-card h6 {
            font-size: 0.85rem;
            text-transform: uppercase;
            letter-spacing: 1px;
            color: #64748b;
            font-weight: 700;
            margin-bottom: 10px;
        }
        
        .stat-card .number {
            font-size: 3rem;
            font-weight: 800;
            color: #1a1a1a;
            line-height: 1;
        }
        
        .content-grid {
            display: grid;
            grid-template-columns: 2fr 1fr;
            gap: 25px;
            margin-bottom: 30px;
        }
        
        .card-box {
            background: white;
            padding: 35px;
            border-radius: 20px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
        }
        
        .card-box h5 {
            font-size: 1.5rem;
            font-weight: 800;
            color: #1a1a1a;
            margin-bottom: 25px;
            display: flex;
            align-items: center;
            gap: 12px;
        }
        
        .employee-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 20px;
            background: #f8fafc;
            border-radius: 14px;
            margin-bottom: 15px;
            transition: 0.2s;
        }
        
        .employee-item:hover {
            background: #e2e8f0;
            transform: translateX(5px);
        }
        
        .employee-item:last-child {
            margin-bottom: 0;
        }
        
        .emp-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .emp-avatar {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 800;
            font-size: 1.1rem;
        }
        
        .emp-details h6 {
            margin: 0;
            font-weight: 700;
            color: #1a1a1a;
            font-size: 0.95rem;
        }
        
        .emp-details p {
            margin: 0;
            font-size: 0.8rem;
            color: #64748b;
            font-weight: 600;
        }
        
        .emp-status {
            padding: 8px 16px;
            border-radius: 8px;
            font-weight: 700;
            font-size: 0.75rem;
            text-transform: uppercase;
        }
        
        .emp-status.active {
            background: #d1fae5;
            color: #065f46;
        }
        
        .emp-status.inactive {
            background: #fee2e2;
            color: #991b1b;
        }
        
        .quick-action-btn {
            background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
            padding: 25px;
            border-radius: 16px;
            text-decoration: none;
            color: #1a1a1a;
            font-weight: 700;
            transition: 0.3s;
            text-align: center;
            display: block;
            margin-bottom: 15px;
            border: 2px solid #e2e8f0;
        }
        
        .quick-action-btn:hover {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            transform: translateY(-5px);
            box-shadow: 0 15px 40px rgba(0,0,0,0.2);
        }
        
        .quick-action-btn i {
            font-size: 2rem;
            display: block;
            margin-bottom: 12px;
        }
        
        .view-all-btn {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 15px 30px;
            border-radius: 12px;
            text-decoration: none;
            font-weight: 800;
            display: inline-block;
            margin-top: 20px;
            transition: 0.3s;
            box-shadow: 0 10px 30px rgba(102, 126, 234, 0.3);
        }
        
        .view-all-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 15px 40px rgba(102, 126, 234, 0.5);
            color: white;
        }
        
        .logout-btn {
            background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
            color: white;
            padding: 12px 24px;
            border-radius: 10px;
            text-decoration: none;
            font-weight: 700;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            transition: 0.3s;
            font-size: 0.9rem;
        }
        
        .logout-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(239, 68, 68, 0.4);
            color: white;
        }
        
        /* Dark Mode */
        body.dark-mode {
            background: linear-gradient(135deg, #1e293b 0%, #0f172a 100%);
        }
        
        body.dark-mode .top-header,
        body.dark-mode .stat-card,
        body.dark-mode .card-box {
            background: linear-gradient(135deg, #1e293b 0%, #0f172a 100%);
            color: #f1f5f9;
            border: 1px solid #334155;
        }
        
        body.dark-mode .top-header h1,
        body.dark-mode .stat-card .number,
        body.dark-mode .card-box h5,
        body.dark-mode .emp-details h6,
        body.dark-mode .admin-details h6 {
            color: #f1f5f9;
        }
        
        body.dark-mode .employee-item {
            background: #0f172a;
            border: 1px solid #334155;
        }
        
        body.dark-mode .employee-item:hover {
            background: #1e293b;
        }
        
        body.dark-mode .quick-action-btn {
            background: linear-gradient(135deg, #334155 0%, #1e293b 100%);
            color: #f1f5f9;
            border-color: #475569;
        }
        
        body.dark-mode .quick-action-btn:hover {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
    </style>
</head>
<body>

<div class="dashboard-wrapper">
    
    <!-- Top Header -->
    <div class="top-header">
        <div>
            <h1><i class="fa-solid fa-dashboard me-3" style="color: #667eea;"></i>Admin Dashboard</h1>
        </div>
        <div class="admin-info">
            <div class="admin-avatar">A</div>
            <div class="admin-details">
                <h6>Admin User</h6>
                <p>Administrator</p>
            </div>
            <a href="logout.php" class="logout-btn">
                <i class="fa-solid fa-right-from-bracket"></i>
                Logout
            </a>
        </div>
    </div>
    
    <!-- Statistics Cards -->
    <div class="stats-grid">
        <div class="stat-card primary">
            <div class="stat-icon">
                <i class="fa-solid fa-users"></i>
            </div>
            <h6>Total Employees</h6>
            <div class="number"><?= $total_employees; ?></div>
        </div>
        
        <div class="stat-card success">
            <div class="stat-icon">
                <i class="fa-solid fa-user-check"></i>
            </div>
            <h6>Active Employees</h6>
            <div class="number"><?= $active_employees; ?></div>
        </div>
        
        <div class="stat-card warning">
            <div class="stat-icon">
                <i class="fa-solid fa-user-clock"></i>
            </div>
            <h6>Inactive Employees</h6>
            <div class="number"><?= $inactive_employees; ?></div>
        </div>
        
        <div class="stat-card danger">
            <div class="stat-icon">
                <i class="fa-solid fa-calendar-plus"></i>
            </div>
            <h6>Today Registered</h6>
            <div class="number"><?= $today_registered; ?></div>
        </div>
    </div>
    
    <!-- Content Grid -->
    <div class="content-grid">
        
        <!-- Recent Employees -->
        <div class="card-box">
            <h5>
                <i class="fa-solid fa-clock-rotate-left" style="color: #667eea;"></i>
                Recent Employees
            </h5>
            
            <?php if($recent_employees->num_rows > 0): ?>
                <?php while($emp = $recent_employees->fetch_assoc()): ?>
                    <div class="employee-item">
                        <div class="emp-info">
                            <div class="emp-avatar">
                                <?= strtoupper(substr($emp['name'], 0, 1)); ?>
                            </div>
                            <div class="emp-details">
                                <h6><?= htmlspecialchars($emp['name']); ?></h6>
                                <p><?= htmlspecialchars($emp['email']); ?></p>
                            </div>
                        </div>
                        <div>
                            <span class="emp-status <?= $emp['status']; ?>">
                                <?= strtoupper($emp['status']); ?>
                            </span>
                        </div>
                    </div>
                <?php endwhile; ?>
                
                <a href="manage_employees.php" class="view-all-btn">
                    <i class="fa-solid fa-arrow-right me-2"></i>
                    View All Employees
                </a>
            <?php else: ?>
                <p class="text-muted text-center py-4">No employees found</p>
            <?php endif; ?>
        </div>
        
        <!-- Quick Actions -->
        <div class="card-box">
            <h5>
                <i class="fa-solid fa-bolt" style="color: #f59e0b;"></i>
                Quick Actions
            </h5>
            
            <a href="manage_employees.php" class="quick-action-btn">
                <i class="fa-solid fa-users-gear"></i>
                Manage Employees
            </a>
            
            <a href="manage_employees.php" class="quick-action-btn">
                <i class="fa-solid fa-user-plus"></i>
                Add New Employee
            </a>
            
            <a href="reports.php" class="quick-action-btn">
                <i class="fa-solid fa-chart-line"></i>
                View Reports
            </a>
            
            <a href="settings.php" class="quick-action-btn">
                <i class="fa-solid fa-gear"></i>
                Settings
            </a>
        </div>
        
    </div>
    
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
