<?php
// Include Database Connection
require_once 'db.php';

// Set Timezone to India (Important for your Reports)
date_default_timezone_set('Asia/Kolkata');

// ==========================================
// FUNCTION: Get Setting Value from Database
// Usage: get_setting('openai_key');
// ==========================================
if (!function_exists('get_setting')) {
    function get_setting($key_name) {
        global $conn;
        $key_name = $conn->real_escape_string($key_name);
        
        $sql = "SELECT setting_value FROM settings WHERE setting_name = '$key_name' LIMIT 1";
        $result = $conn->query($sql);
        
        if ($result && $result->num_rows > 0) {
            $row = $result->fetch_assoc();
            return $row['setting_value'];
        }
        return null; // Return null if not found
    }
}

// ==========================================
// FUNCTION: Update Setting Value in Database
// Usage: update_setting('openai_key', 'new-key-123');
// ==========================================
if (!function_exists('update_setting')) {
    function update_setting($key_name, $key_value) {
        global $conn;
        $key_name = $conn->real_escape_string($key_name);
        $key_value = $conn->real_escape_string($key_value);

        // Check if exists first
        $check = "SELECT id FROM settings WHERE setting_name = '$key_name'";
        $res = $conn->query($check);

        if ($res->num_rows > 0) {
            // Update
            $sql = "UPDATE settings SET setting_value = '$key_value' WHERE setting_name = '$key_name'";
        } else {
            // Insert
            $sql = "INSERT INTO settings (setting_name, setting_value) VALUES ('$key_name', '$key_value')";
        }
        
        return $conn->query($sql);
    }
}

// ==========================================
// BASE URL (Optional - For Links)
// ==========================================
define('BASE_URL', 'http://localhost/your_project_folder/'); 
// Note: Jab live server pe daalein, toh isse change kar dena example: 'https://vantagegrow.com/admin/'

?>
